/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.lang.reflect.Type;
import javax.json.bind.JsonbException;
import org.eclipse.yasson.internal.Unmarshaller;
import org.eclipse.yasson.internal.model.customization.Customization;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;
import org.eclipse.yasson.internal.serializer.AbstractNumberDeserializer;

public class IntegerTypeDeserializer
extends AbstractNumberDeserializer<Integer> {
    public IntegerTypeDeserializer(Customization customization) {
        super(Integer.class, customization);
    }

    @Override
    protected Integer deserialize(String jsonValue, Unmarshaller unmarshaller, Type rtType) {
        return this.deserializeFormatted(jsonValue, true, unmarshaller.getJsonbContext()).map(num -> Integer.parseInt(num.toString())).orElseGet(() -> {
            try {
                return Integer.parseInt(jsonValue);
            }
            catch (NumberFormatException e) {
                throw new JsonbException(Messages.getMessage(MessageKeys.DESERIALIZE_VALUE_ERROR, Integer.class));
            }
        });
    }
}

