/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versions.manipulation;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.tycho.model.IU;
import org.eclipse.tycho.versions.engine.MetadataManipulator;
import org.eclipse.tycho.versions.engine.ProjectMetadata;
import org.eclipse.tycho.versions.engine.VersionChange;
import org.eclipse.tycho.versions.engine.VersionChangesDescriptor;
import org.eclipse.tycho.versions.manipulation.AbstractMetadataManipulator;
import org.eclipse.tycho.versions.pom.PomFile;

@Component(role=MetadataManipulator.class, hint="p2-installable-unit")
public class P2iuXmlManipulator
extends AbstractMetadataManipulator {
    @Override
    public void applyChanges(ProjectMetadata project, VersionChangesDescriptor versionChangeContext) {
        if (!this.isIu(project)) {
            return;
        }
        IU iu = this.getIU(project);
        VersionChange change = versionChangeContext.findVersionChangeByArtifactId(iu.getId());
        if (change != null && change.getVersion().equals(iu.getVersion())) {
            this.logger.info("  p2iu.xml//unit/@version: " + change.getVersion() + " => " + change.getNewVersion());
            iu.setVersion(change.getNewVersion());
            project.putMetadata(iu);
        }
    }

    @Override
    public void writeMetadata(ProjectMetadata project) throws IOException {
        if (!this.isIu(project)) {
            return;
        }
        IU iu = project.getMetadata(IU.class);
        if (iu != null) {
            IU.write((IU)iu, (File)new File(project.getBasedir(), "p2iu.xml"), null);
        }
    }

    @Override
    public Collection<String> validateChanges(ProjectMetadata project, VersionChangesDescriptor versionChangeContext) {
        return null;
    }

    private IU getIU(ProjectMetadata project) {
        IU iu = project.getMetadata(IU.class);
        if (iu == null) {
            iu = IU.loadIU((File)project.getBasedir());
        }
        return iu;
    }

    private boolean isIu(ProjectMetadata project) {
        PomFile pom = project.getMetadata(PomFile.class);
        return "p2-installable-unit".equals(pom.getPackaging());
    }
}

