/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versions.manipulation;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.tycho.model.manifest.MutableBundleManifest;
import org.eclipse.tycho.versions.bundle.MutableBndFile;
import org.eclipse.tycho.versions.engine.MetadataManipulator;
import org.eclipse.tycho.versions.engine.PackageVersionChange;
import org.eclipse.tycho.versions.engine.PomVersionChange;
import org.eclipse.tycho.versions.engine.ProjectMetadata;
import org.eclipse.tycho.versions.engine.VersionChange;
import org.eclipse.tycho.versions.engine.VersionChangesDescriptor;
import org.eclipse.tycho.versions.engine.Versions;
import org.eclipse.tycho.versions.manipulation.AbstractMetadataManipulator;

@Component(role=MetadataManipulator.class, hint="bundle-manifest")
public class BundleManifestManipulator
extends AbstractMetadataManipulator {
    @Override
    public boolean addMoreChanges(ProjectMetadata project, VersionChangesDescriptor versionChangeContext) {
        if (this.isBundle(project) && versionChangeContext.shouldUpdatePackageVersions()) {
            Set<PackageVersionChange> changes = this.computeExportedPackageChanges(project, versionChangeContext);
            return versionChangeContext.addPackageVersionChanges(changes);
        }
        return false;
    }

    @Override
    public Collection<String> validateChanges(ProjectMetadata project, VersionChangesDescriptor versionChangeContext) {
        VersionChange versionChangeForProject;
        if (this.isBundle(project) && (versionChangeForProject = this.findVersionChangeForProject(project, versionChangeContext)) != null) {
            String error = Versions.validateOsgiVersion(versionChangeForProject.getNewVersion(), this.getManifestFile(project));
            return error != null ? Collections.singleton(error) : null;
        }
        return null;
    }

    @Override
    public void applyChanges(ProjectMetadata project, VersionChangesDescriptor versionChangeContext) {
        if (this.isBundle(project)) {
            this.updateBundleAndExportPackageVersions(project, versionChangeContext);
            this.updateFragmentHostVersion(project, versionChangeContext);
            this.updateRequireBundleVersions(project, versionChangeContext);
            this.updateImportPackageVersions(project, versionChangeContext);
        }
    }

    @Override
    public void writeMetadata(ProjectMetadata project) throws IOException {
        MutableBndFile bnd;
        MutableBundleManifest mf = project.getMetadata(MutableBundleManifest.class);
        if (mf != null) {
            MutableBundleManifest.write((MutableBundleManifest)mf, (File)this.getManifestFile(project));
        }
        if ((bnd = project.getMetadata(MutableBndFile.class)) != null) {
            bnd.write(this.getBndFile(project));
        }
    }

    private Set<PackageVersionChange> computeExportedPackageChanges(ProjectMetadata project, VersionChangesDescriptor versionChangeContext) {
        VersionChange versionChangeForProject = this.findVersionChangeForProject(project, versionChangeContext);
        if (versionChangeForProject == null) {
            return Collections.emptySet();
        }
        Optional<MutableBundleManifest> bundleManifest = this.getBundleManifest(project);
        if (bundleManifest.isEmpty()) {
            return Set.of();
        }
        MutableBundleManifest mf = bundleManifest.get();
        String versionToReplace = Versions.toBaseVersion(versionChangeForProject.getVersion());
        String newVersion = Versions.toBaseVersion(versionChangeForProject.getNewVersion());
        HashSet<PackageVersionChange> packageVersionChanges = new HashSet<PackageVersionChange>();
        for (Map.Entry exportedPackageVersion : mf.getExportedPackagesVersion().entrySet()) {
            String packageName = (String)exportedPackageVersion.getKey();
            String packageVersion = (String)exportedPackageVersion.getValue();
            if (packageVersion == null || !packageVersion.equals(versionToReplace)) continue;
            packageVersionChanges.add(new PackageVersionChange(mf.getSymbolicName(), packageName, packageVersion, newVersion));
        }
        return packageVersionChanges;
    }

    private VersionChange findVersionChangeForProject(ProjectMetadata project, VersionChangesDescriptor versionChangeContext) {
        Optional<MutableBundleManifest> bundleManifest = this.getBundleManifest(project);
        if (bundleManifest.isEmpty()) {
            Optional<MutableBndFile> bndFile = this.getBundleBndFile(project);
            if (bndFile.isPresent()) {
                MutableBndFile bnd = bndFile.get();
                String bsn = bnd.getValue("Bundle-SymbolicName");
                String vrs = bnd.getValue("Bundle-Version");
                VersionChange versionChangeForProject = versionChangeContext.findVersionChangeByArtifactId(bsn);
                if (versionChangeForProject != null && versionChangeForProject.getVersion().equals(vrs)) {
                    return versionChangeForProject;
                }
            }
            return null;
        }
        MutableBundleManifest mf = bundleManifest.get();
        VersionChange versionChangeForProject = versionChangeContext.findVersionChangeByArtifactId(mf.getSymbolicName());
        if (versionChangeForProject != null && versionChangeForProject.getVersion().equals(mf.getVersion())) {
            return versionChangeForProject;
        }
        return null;
    }

    private void updateBundleAndExportPackageVersions(ProjectMetadata project, VersionChangesDescriptor versionChangeContext) {
        Optional<MutableBundleManifest> bundleManifest = this.getBundleManifest(project);
        if (bundleManifest.isEmpty()) {
            Optional<MutableBndFile> bndFile = this.getBundleBndFile(project);
            if (bndFile.isPresent()) {
                MutableBndFile bnd = bndFile.get();
                VersionChange versionChangeForProject = this.findVersionChangeForProject(project, versionChangeContext);
                if (versionChangeForProject != null) {
                    this.logger.info("  pde.bnd//Bundle-Version: " + versionChangeForProject.getVersion() + " => " + versionChangeForProject.getNewVersion());
                    bnd.setValue("Bundle-Version", versionChangeForProject.getNewVersion());
                }
            }
            return;
        }
        MutableBundleManifest mf = bundleManifest.get();
        VersionChange versionChangeForProject = this.findVersionChangeForProject(project, versionChangeContext);
        if (versionChangeForProject != null) {
            this.logger.info("  META-INF/MANIFEST.MF//Bundle-Version: " + versionChangeForProject.getVersion() + " => " + versionChangeForProject.getNewVersion());
            mf.setVersion(versionChangeForProject.getNewVersion());
            HashMap<String, String> exportPackagesNewVersion = new HashMap<String, String>();
            for (PackageVersionChange packageVersionChange : versionChangeContext.getPackageVersionChanges()) {
                if (!packageVersionChange.getBundleSymbolicName().equals(mf.getSymbolicName())) continue;
                this.logger.info("  META-INF/MANIFEST.MF//Export-Package//" + packageVersionChange.getPackageName() + ";version: " + packageVersionChange.getVersion() + " => " + packageVersionChange.getNewVersion());
                exportPackagesNewVersion.put(packageVersionChange.getPackageName(), packageVersionChange.getNewVersion());
            }
            mf.updateExportedPackageVersions(exportPackagesNewVersion);
        }
    }

    private void updateFragmentHostVersion(ProjectMetadata project, VersionChangesDescriptor versionChangeContext) {
        VersionChange versionChange;
        Optional<MutableBundleManifest> bundleManifest = this.getBundleManifest(project);
        if (bundleManifest.isEmpty()) {
            return;
        }
        MutableBundleManifest mf = bundleManifest.get();
        if (mf.isFragment() && (versionChange = versionChangeContext.findVersionChangeByArtifactId(mf.getFragmentHostSymbolicName())) != null) {
            String newVersionRange = versionChangeContext.getVersionRangeUpdateStrategy().computeNewVersionRange(mf.getFragmentHostVersion(), versionChange.getVersion(), versionChange.getNewVersion());
            this.logger.info("  META-INF/MANIFEST.MF//Fragment-Host//" + mf.getFragmentHostSymbolicName() + ";bundle-version: " + newVersionRange + " => " + newVersionRange);
            mf.setFragmentHostVersion(Versions.toBaseVersion(newVersionRange));
        }
    }

    private void updateRequireBundleVersions(ProjectMetadata project, VersionChangesDescriptor versionChangeContext) {
        Optional<MutableBundleManifest> bundleManifest = this.getBundleManifest(project);
        if (bundleManifest.isEmpty()) {
            return;
        }
        MutableBundleManifest mf = bundleManifest.get();
        Map requiredBundleVersions = mf.getRequiredBundleVersions();
        HashMap<String, String> versionsToUpdate = new HashMap<String, String>();
        for (PomVersionChange versionChange : versionChangeContext.getVersionChanges()) {
            String bundleSymbolicName = versionChange.getArtifactId();
            if (!requiredBundleVersions.containsKey(bundleSymbolicName)) continue;
            String originalVersionRange = (String)requiredBundleVersions.get(bundleSymbolicName);
            versionsToUpdate.put(bundleSymbolicName, versionChangeContext.getVersionRangeUpdateStrategy().computeNewVersionRange(originalVersionRange, versionChange.getVersion(), versionChange.getNewVersion()));
        }
        mf.updateRequiredBundleVersions(versionsToUpdate);
    }

    private void updateImportPackageVersions(ProjectMetadata project, VersionChangesDescriptor versionChangeContext) {
        Optional<MutableBundleManifest> bundleManifest = this.getBundleManifest(project);
        if (bundleManifest.isEmpty()) {
            return;
        }
        MutableBundleManifest mf = bundleManifest.get();
        HashMap<String, String> importedPackageNewVersions = new HashMap<String, String>();
        for (Map.Entry importPackageVersions : mf.getImportPackagesVersions().entrySet()) {
            PackageVersionChange versionChange;
            String packageName = (String)importPackageVersions.getKey();
            String importVersionRange = (String)importPackageVersions.getValue();
            if (importVersionRange == null || (versionChange = versionChangeContext.findPackageVersionChange(packageName)) == null) continue;
            String newVersionRange = versionChangeContext.getVersionRangeUpdateStrategy().computeNewVersionRange(importVersionRange, versionChange.getVersion(), versionChange.getNewVersion());
            this.logger.info("  META-INF/MANIFEST.MF//Import-Package//" + packageName + ";version: " + importVersionRange + " => " + newVersionRange);
            importedPackageNewVersions.put(packageName, newVersionRange);
        }
        mf.updateImportedPackageVersions(importedPackageNewVersions);
    }

    private Optional<MutableBundleManifest> getBundleManifest(ProjectMetadata project) {
        File file;
        MutableBundleManifest mf = project.getMetadata(MutableBundleManifest.class);
        if (mf == null && (file = this.getManifestFile(project)).isFile()) {
            try {
                mf = MutableBundleManifest.read((File)file);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not parse bundle manifest " + String.valueOf(file), e);
            }
            project.putMetadata(mf);
            return Optional.of(mf);
        }
        return Optional.ofNullable(mf);
    }

    private Optional<MutableBndFile> getBundleBndFile(ProjectMetadata project) {
        File file;
        MutableBndFile bnd = project.getMetadata(MutableBndFile.class);
        if (bnd == null && (file = this.getBndFile(project)).isFile()) {
            try {
                bnd = MutableBndFile.read(file);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not parse bundle manifest " + String.valueOf(file), e);
            }
            project.putMetadata(bnd);
            return Optional.of(bnd);
        }
        return Optional.ofNullable(bnd);
    }

    private File getManifestFile(ProjectMetadata project) {
        return new File(project.getBasedir(), "META-INF/MANIFEST.MF");
    }

    private File getBndFile(ProjectMetadata project) {
        return new File(project.getBasedir(), "pde.bnd");
    }
}

