/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versions.engine;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.tycho.model.Feature;
import org.eclipse.tycho.model.IU;
import org.eclipse.tycho.model.ProductConfiguration;
import org.eclipse.tycho.model.manifest.MutableBundleManifest;
import org.eclipse.tycho.versions.bundle.MutableBndFile;
import org.eclipse.tycho.versions.engine.ProjectMetadata;
import org.eclipse.tycho.versions.engine.Versions;
import org.eclipse.tycho.versions.engine.VersionsEngine;
import org.eclipse.tycho.versions.pom.PomFile;
import org.eclipse.tycho.versions.utils.ProductFileFilter;

public abstract class VersionUpdater {
    @Requirement
    private Logger logger;
    @Requirement
    private VersionsEngine engine;
    private static final Map<String, VersionAdaptor> updaters = new HashMap<String, VersionAdaptor>();
    private Collection<ProjectMetadata> projects;

    public void setProjects(Collection<ProjectMetadata> projects) {
        this.projects = projects;
        this.engine.setProjects(projects);
    }

    public void apply() throws IOException {
        for (ProjectMetadata project : this.projects) {
            String osgiVersion;
            PomFile pom = project.getMetadata(PomFile.class);
            if (pom == null) {
                this.logger.info("Not a maven project " + String.valueOf(project.getBasedir()));
                continue;
            }
            String pomVersion = Versions.toCanonicalVersion(pom.getVersion());
            VersionAdaptor adaptor = updaters.get(pom.getPackaging());
            if (adaptor == null || (osgiVersion = Versions.toCanonicalVersion(adaptor.getVersion(project, this.logger))) == null || Versions.isVersionEquals(pomVersion, osgiVersion)) continue;
            this.addVersionChange(this.engine, pom, osgiVersion);
        }
        this.engine.apply();
    }

    protected abstract void addVersionChange(VersionsEngine var1, PomFile var2, String var3);

    private static File findProductFile(ProjectMetadata project, PomFile pom, Logger logger) {
        File productFile = new File(project.getBasedir(), pom.getArtifactId() + ".product");
        if (productFile.exists()) {
            return productFile;
        }
        File[] productFiles = project.getBasedir().listFiles(new ProductFileFilter());
        if (productFiles == null || productFiles.length == 0) {
            logger.warn("Skipping updating pom in directory " + String.valueOf(project.getBasedir()) + " because no product file found to extract the (new) version");
            return null;
        }
        if (productFiles.length > 1) {
            logger.warn("Skipping updating pom in directory " + String.valueOf(project.getBasedir()) + " because more than one product files have been found. Only one product file is supported or one must be named <artifactId>.product");
            return null;
        }
        return productFiles[0];
    }

    static {
        VersionAdaptor bundleVersionAdaptor = (project, logger) -> {
            File manifestFile = new File(project.getBasedir(), "META-INF/MANIFEST.MF");
            if (manifestFile.isFile()) {
                MutableBundleManifest manifest = MutableBundleManifest.read((File)manifestFile);
                return manifest.getVersion();
            }
            File bndFile = new File(project.getBasedir(), "pde.bnd");
            if (bndFile.isFile()) {
                MutableBndFile mutableBndFile = MutableBndFile.read(bndFile);
                return mutableBndFile.getValue("Bundle-Version");
            }
            throw new IllegalStateException("neither META-INF/MANIFEST.MF nor pde.bnd file found in project " + String.valueOf(project.getBasedir()));
        };
        updaters.put("eclipse-plugin", bundleVersionAdaptor);
        updaters.put("eclipse-test-plugin", bundleVersionAdaptor);
        updaters.put("eclipse-feature", (project, logger) -> {
            Feature feature = Feature.read((File)new File(project.getBasedir(), "feature.xml"));
            return feature.getVersion();
        });
        VersionAdaptor productVersionAdapter = (project, logger) -> {
            PomFile pom = project.getMetadata(PomFile.class);
            File productFile = VersionUpdater.findProductFile(project, pom, logger);
            if (productFile == null) {
                return null;
            }
            ProductConfiguration product = ProductConfiguration.read((File)productFile);
            return product.getVersion();
        };
        updaters.put("eclipse-repository", productVersionAdapter);
        updaters.put("p2-installable-unit", (project, logger) -> {
            IU iu = IU.loadIU((File)project.getBasedir());
            return iu.getVersion();
        });
    }

    private static interface VersionAdaptor {
        public String getVersion(ProjectMetadata var1, Logger var2) throws IOException;
    }
}

