/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versions.engine;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.eclipse.tycho.versions.engine.PackageVersionChange;
import org.eclipse.tycho.versions.engine.PomVersionChange;
import org.eclipse.tycho.versions.engine.ProjectMetadata;
import org.eclipse.tycho.versions.engine.VersionChange;
import org.eclipse.tycho.versions.engine.VersionRangeUpdateStrategy;

public class VersionChangesDescriptor {
    private final Set<PomVersionChange> aritfactsVersionChanges;
    private final Set<PackageVersionChange> packageVersionChanges;
    private final VersionRangeUpdateStrategy versionRangeUpdateStrategy;
    private Collection<ProjectMetadata> projects;
    private boolean updatePackageVersions = true;

    public VersionChangesDescriptor(Set<PomVersionChange> originalVersionChanges, VersionRangeUpdateStrategy versionRangeUpdateStrategy, Collection<ProjectMetadata> projects) {
        this.projects = projects;
        this.aritfactsVersionChanges = new LinkedHashSet<PomVersionChange>(originalVersionChanges);
        this.versionRangeUpdateStrategy = versionRangeUpdateStrategy;
        this.packageVersionChanges = new LinkedHashSet<PackageVersionChange>();
    }

    public Optional<ProjectMetadata> findMetadataByBasedir(File baseDir) {
        Path path = baseDir.toPath();
        for (ProjectMetadata meta : this.projects) {
            Path projectPath = meta.getBasedir().toPath();
            try {
                if (!Files.isSameFile(projectPath, path)) continue;
                return Optional.of(meta);
            }
            catch (IOException iOException) {
            }
        }
        return Optional.empty();
    }

    public Set<PomVersionChange> getVersionChanges() {
        return Collections.unmodifiableSet(new HashSet<PomVersionChange>(this.aritfactsVersionChanges));
    }

    public boolean addVersionChange(PomVersionChange versionChange) {
        return this.aritfactsVersionChanges.add(versionChange);
    }

    public VersionChange findVersionChangeByArtifactId(String symbolicName) {
        for (PomVersionChange versionChange : this.aritfactsVersionChanges) {
            if (!versionChange.getArtifactId().equals(symbolicName)) continue;
            return versionChange;
        }
        return null;
    }

    public Set<PackageVersionChange> getPackageVersionChanges() {
        return Collections.unmodifiableSet(this.packageVersionChanges);
    }

    public VersionRangeUpdateStrategy getVersionRangeUpdateStrategy() {
        return this.versionRangeUpdateStrategy;
    }

    public boolean shouldUpdatePackageVersions() {
        return this.updatePackageVersions;
    }

    public void setUpdatePackageVersions(boolean updatePackageVersions) {
        this.updatePackageVersions = updatePackageVersions;
    }

    public boolean addPackageVersionChanges(Set<PackageVersionChange> changes) {
        return this.packageVersionChanges.addAll(changes);
    }

    public PackageVersionChange findPackageVersionChange(String packageName) {
        for (PackageVersionChange versionChange : this.packageVersionChanges) {
            if (!versionChange.getPackageName().equals(packageName)) continue;
            return versionChange;
        }
        return null;
    }
}

