/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versions;

import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.tycho.helper.ProjectHelper;

@Mojo(name="bump-versions", threadSafe=true, defaultPhase=LifecyclePhase.VERIFY, requiresProject=true)
public class VersionBumpMojo
extends AbstractMojo {
    static final String ARTIFACT_ID = "tycho-versions-plugin";
    static final String GROUP_ID = "org.eclipse.tycho";
    static final int DEFAULT_INCREMENT = 1;
    static final String NAME = "bump-versions";
    static final String PROPERTY_INCREMENT = "tycho.bump-versions.increment";
    @Parameter(property="tycho.bump-versions.increment", defaultValue="1")
    private int increment = 1;

    public void execute() throws MojoExecutionException, MojoFailureException {
    }

    public static int getIncrement(MavenSession mavenSession, MavenProject project, ProjectHelper projectHelper) {
        Xpp3Dom child;
        String prop = mavenSession.getUserProperties().getProperty(PROPERTY_INCREMENT);
        if (prop != null) {
            return Integer.parseInt(prop);
        }
        Xpp3Dom configuration = projectHelper.getPluginConfiguration(GROUP_ID, ARTIFACT_ID, NAME, project, mavenSession);
        if (configuration != null && (child = configuration.getChild("increment")) != null) {
            return Integer.parseInt(child.getValue());
        }
        return 1;
    }
}

