/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versions;

import java.io.IOException;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.tycho.versions.AbstractChangeMojo;
import org.eclipse.tycho.versions.engine.VersionsEngine;

@Mojo(name="set-property", aggregator=true, requiresDependencyResolution=ResolutionScope.NONE)
public class SetPropertyMojo
extends AbstractChangeMojo {
    @Parameter(property="properties")
    private String properties;

    @Override
    protected void addChanges(List<String> artifacts, VersionsEngine engine) throws MojoExecutionException, IOException {
        if (this.properties == null || this.properties.isEmpty()) {
            throw new MojoExecutionException("Missing required parameter properties");
        }
        for (String artifactId : artifacts) {
            for (String propertyName : SetPropertyMojo.split(this.properties)) {
                if (propertyName.isBlank()) continue;
                String userPropertyName = "new" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
                String property = this.session.getUserProperties().getProperty(userPropertyName);
                if (property == null) {
                    throw new MojoExecutionException("No user property '" + userPropertyName + "' defined");
                }
                engine.addPropertyChange(artifactId, propertyName, property);
            }
        }
    }
}

