/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versions;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.tycho.versions.AbstractChangeMojo;
import org.eclipse.tycho.versions.engine.PomVersionChange;
import org.eclipse.tycho.versions.engine.VersionsEngine;
import org.eclipse.tycho.versions.pom.GAV;
import org.eclipse.tycho.versions.pom.PomFile;

@Mojo(name="set-parent-version", aggregator=true, requiresDependencyResolution=ResolutionScope.NONE)
public class SetParentVersionMojo
extends AbstractChangeMojo {
    @Parameter(property="newParentVersion", required=true)
    private String newParentVersion;

    @Override
    protected void addChanges(List<String> artifacts, VersionsEngine engine) throws MojoExecutionException, IOException {
        if (this.newParentVersion == null || this.newParentVersion.isEmpty()) {
            throw new MojoExecutionException("Missing required parameter newParentVersion");
        }
        for (String artifactId : artifacts) {
            PomFile pom = engine.getMutablePom(artifactId);
            GAV parent = pom.getParent();
            if (parent == null) continue;
            engine.addVersionChange(new ParentPomVersionChange(pom, parent.getVersion(), this.newParentVersion, parent));
        }
    }

    private final class ParentPomVersionChange
    extends PomVersionChange {
        private final GAV parent;

        private ParentPomVersionChange(PomFile pom, String version, String newVersion, GAV parent) {
            super(pom, version, newVersion);
            this.parent = parent;
        }

        @Override
        public String getGroupId() {
            return this.parent.getGroupId();
        }

        @Override
        public String getArtifactId() {
            return this.parent.getArtifactId();
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + ((Object)((Object)this.getEnclosingInstance())).hashCode();
            result = 31 * result + Objects.hash(this.parent);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ParentPomVersionChange other = (ParentPomVersionChange)obj;
            if (!((Object)((Object)this.getEnclosingInstance())).equals((Object)other.getEnclosingInstance())) {
                return false;
            }
            return Objects.equals(this.parent, other.parent);
        }

        private SetParentVersionMojo getEnclosingInstance() {
            return SetParentVersionMojo.this;
        }
    }
}

