/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versions.manipulation;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.tycho.versions.engine.MetadataManipulator;
import org.eclipse.tycho.versions.engine.PomVersionChange;
import org.eclipse.tycho.versions.engine.ProjectMetadata;
import org.eclipse.tycho.versions.engine.VersionChangesDescriptor;
import org.eclipse.tycho.versions.engine.Versions;
import org.eclipse.tycho.versions.manipulation.AbstractMetadataManipulator;
import org.eclipse.tycho.versions.pom.Build;
import org.eclipse.tycho.versions.pom.DependencyManagement;
import org.eclipse.tycho.versions.pom.GAV;
import org.eclipse.tycho.versions.pom.Plugin;
import org.eclipse.tycho.versions.pom.PluginManagement;
import org.eclipse.tycho.versions.pom.PomFile;
import org.eclipse.tycho.versions.pom.Profile;
import org.eclipse.tycho.versions.pom.Property;

@Component(role=MetadataManipulator.class, hint="pom")
public class PomManipulator
extends AbstractMetadataManipulator {
    private static final String POM = "pom";
    private static final String NULL = "<null>";
    public static final String HINT = "pom";
    private static final Pattern CI_FRIENDLY_EXPRESSION = Pattern.compile("\\$\\{(.+?)\\}");

    @Override
    public boolean addMoreChanges(ProjectMetadata project, VersionChangesDescriptor versionChangeContext) {
        Optional<PomVersionChange> thisChange;
        PomFile pom = project.getMetadata(PomFile.class);
        if (pom == null) {
            throw new RuntimeException("no pom available for " + project.getBasedir());
        }
        GAV parent = pom.getParent();
        AtomicBoolean moreChanges = new AtomicBoolean();
        if (parent != null) {
            for (PomVersionChange change2 : versionChangeContext.getVersionChanges()) {
                if (!PomManipulator.isGavEquals(parent, change2) || !Versions.isVersionEquals(pom.getVersion(), change2.getVersion()) || !versionChangeContext.addVersionChange(new PomVersionChange(pom, change2.getVersion(), change2.getNewVersion()))) continue;
                moreChanges.set(true);
            }
        }
        if ("pom".equals(pom.getPackaging()) && (thisChange = versionChangeContext.getVersionChanges().stream().filter(change -> change.getProject() == pom).findFirst()).isPresent()) {
            PomVersionChange change2;
            change2 = thisChange.get();
            List<String> modules = pom.getModules();
            for (String module : modules) {
                versionChangeContext.findMetadataByBasedir(new File(project.getBasedir(), module)).ifPresent(moduleMeta -> {
                    PomFile modulePom = moduleMeta.getMetadata(PomFile.class);
                    if (modulePom != null && modulePom.isMutable() && "pom".equals(modulePom.getPackaging()) && Versions.isVersionEquals(modulePom.getVersion(), change2.getVersion()) && versionChangeContext.addVersionChange(new PomVersionChange(modulePom, change2.getNewVersion()))) {
                        moreChanges.set(true);
                    }
                });
            }
        }
        return moreChanges.get();
    }

    @Override
    public void applyChanges(ProjectMetadata project, VersionChangesDescriptor versionChangeContext) {
        PomFile pom = project.getMetadata(PomFile.class);
        if (!pom.isMutable()) {
            return;
        }
        String pomName = project.getPomFile().getName();
        for (PomVersionChange change : versionChangeContext.getVersionChanges()) {
            String version = Versions.toMavenVersion(change.getVersion());
            String newVersion = Versions.toMavenVersion(change.getNewVersion());
            if (PomManipulator.isGavEquals(pom, change)) {
                String v = pom.getVersion();
                if (this.isCiFriendly(v)) {
                    Matcher m = CI_FRIENDLY_EXPRESSION.matcher(v.trim());
                    ArrayList<String> ciFriendlyProperties = new ArrayList<String>();
                    while (m.find()) {
                        ciFriendlyProperties.add(m.group(1));
                    }
                    if (ciFriendlyProperties.size() == 1) {
                        this.applyPropertyChange(pomName, pom, (String)ciFriendlyProperties.get(0), newVersion);
                    } else {
                        String update = newVersion;
                        while (!ciFriendlyProperties.isEmpty()) {
                            String property = (String)ciFriendlyProperties.remove(ciFriendlyProperties.size() - 1);
                            String value = pom.getProperties().stream().filter(p -> p.getName().equals(property)).map(p -> p.getValue()).findFirst().orElse(NULL);
                            if (update.endsWith(value)) {
                                update = update.substring(0, update.length() - value.length());
                                continue;
                            }
                            this.applyPropertyChange(pomName, pom, property, update);
                            break;
                        }
                    }
                } else {
                    this.logger.info("  %s//project/version: %s => %s".formatted(pomName, version, newVersion));
                    pom.setVersion(newVersion);
                }
            } else {
                GAV parent = pom.getParent();
                if (parent != null && PomManipulator.isGavEquals(parent, change) && !this.isCiFriendly(parent.getVersion())) {
                    this.logger.info("  %s//project/parent/version: %s => %s".formatted(pomName, version, newVersion));
                    parent.setVersion(newVersion);
                }
            }
            this.changeDependencies("  %s//project/dependencies".formatted(pomName), pom.getDependencies(), change, version, newVersion);
            this.changeDependencyManagement("  %s//project/dependencyManagement".formatted(pomName), pom.getDependencyManagement(), change, version, newVersion);
            this.changeBuild("  //project/build".formatted(pomName), pom.getBuild(), change, version, newVersion);
            for (Profile profile : pom.getProfiles()) {
                String profileId = profile.getId() != null ? profile.getId() : NULL;
                String pomPath = "  %s//project/profiles/profile[ %s ]".formatted(pomName, profileId);
                this.changeDependencies(pomPath + "/dependencies", profile.getDependencies(), change, version, newVersion);
                this.changeDependencyManagement(pomPath + "/dependencyManagement", profile.getDependencyManagement(), change, version, newVersion);
                this.changeBuild(pomPath + "/build", profile.getBuild(), change, version, newVersion);
            }
        }
    }

    private boolean isCiFriendly(String v) {
        return v != null && v.contains("${");
    }

    protected void changeDependencyManagement(String pomPath, DependencyManagement dependencyManagment, PomVersionChange change, String version, String newVersion) {
        if (dependencyManagment != null) {
            this.changeDependencies(pomPath + "/dependencies", dependencyManagment.getDependencies(), change, version, newVersion);
        }
    }

    protected void changeDependencies(String pomPath, List<GAV> dependencies, PomVersionChange change, String version, String newVersion) {
        for (GAV dependency : dependencies) {
            if (!PomManipulator.isGavEquals(dependency, change)) continue;
            this.logger.info(pomPath + "/dependency/[ " + dependency.getGroupId() + ":" + dependency.getArtifactId() + " ] " + version + " => " + newVersion);
            dependency.setVersion(newVersion);
        }
    }

    private void changeBuild(String pomPath, Build build, PomVersionChange change, String version, String newVersion) {
        if (build == null) {
            return;
        }
        this.changePlugins(pomPath + "/plugins/plugin", build.getPlugins(), change, version, newVersion);
        PluginManagement pluginManagement = build.getPluginManagement();
        if (pluginManagement != null) {
            this.changePlugins(pomPath + "/pluginManagemment/plugins/plugin", pluginManagement.getPlugins(), change, version, newVersion);
        }
    }

    private void changePlugins(String pomPath, List<Plugin> plugins, PomVersionChange change, String version, String newVersion) {
        for (Plugin plugin : plugins) {
            GAV pluginGAV = plugin.getGAV();
            if (PomManipulator.isPluginGavEquals(pluginGAV, change)) {
                this.logger.info(pomPath + "/[ " + pluginGAV.getGroupId() + ":" + pluginGAV.getArtifactId() + " ] " + version + " => " + newVersion);
                pluginGAV.setVersion(newVersion);
            }
            this.changePlugins(pomPath, pluginGAV, change, version, newVersion, "/dependencies/dependency/", plugin.getDependencies());
            this.changePlugins(pomPath, pluginGAV, change, version, newVersion, "/configuration/target/artifact/", plugin.getTargetArtifacts());
        }
    }

    private void changePlugins(String pomPath, GAV pluginGAV, PomVersionChange change, String version, String newVersion, String subPath, List<GAV> gavs) {
        for (GAV targetArtifact : gavs) {
            if (!PomManipulator.isGavEquals(targetArtifact, change)) continue;
            this.logger.info(pomPath + "/[ " + pluginGAV.getGroupId() + ":" + pluginGAV.getArtifactId() + " ] " + subPath + "[ " + targetArtifact.getGroupId() + ":" + targetArtifact.getArtifactId() + " ] " + version + " => " + newVersion);
            targetArtifact.setVersion(newVersion);
        }
    }

    private static boolean isGavEquals(PomFile pom, PomVersionChange change) {
        return Versions.eq(change.getGroupId(), pom.getGroupId()) && Versions.eq(change.getArtifactId(), pom.getArtifactId()) && Versions.isVersionEquals(change.getVersion(), pom.getVersion());
    }

    public static boolean isGavEquals(GAV gav, PomVersionChange change) {
        return Versions.eq(change.getGroupId(), gav.getGroupId()) && Versions.eq(change.getArtifactId(), gav.getArtifactId()) && Versions.isVersionEquals(change.getVersion(), gav.getVersion());
    }

    public static boolean isPluginGavEquals(GAV gav, PomVersionChange change) {
        String groupId = gav.getGroupId() != null ? gav.getGroupId() : "org.apache.maven.plugins";
        return Versions.eq(change.getGroupId(), groupId) && Versions.eq(change.getArtifactId(), gav.getArtifactId()) && Versions.isVersionEquals(change.getVersion(), gav.getVersion());
    }

    @Override
    public void writeMetadata(ProjectMetadata project) throws IOException {
        PomFile pom = project.getMetadata(PomFile.class);
        File pomFile = project.getPomFile();
        if (pom != null && pomFile.exists()) {
            PomFile.write(pom, pomFile);
        }
    }

    public void applyPropertyChange(String pomName, PomFile pom, String propertyName, String propertyValue) {
        this.changeProperties("  %s//project/properties".formatted(pomName), pom.getProperties(), propertyName, propertyValue);
        for (Profile profile : pom.getProfiles()) {
            String pomPath = "  %s//project/profiles/profile[ %s ]/properties".formatted(pomName, profile.getId());
            this.changeProperties(pomPath, profile.getProperties(), propertyName, propertyValue);
        }
    }

    private void changeProperties(String pomPath, List<Property> properties, String propertyName, String propertyValue) {
        for (Property property : properties) {
            if (!propertyName.equals(property.getName())) continue;
            this.logger.info(pomPath + "/[ " + propertyName + " ] " + property.getValue() + " => " + propertyValue);
            property.setValue(propertyValue);
        }
    }

    @Override
    public Collection<String> validateChanges(ProjectMetadata project, VersionChangesDescriptor versionChangeContext) {
        return null;
    }
}

