/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versions.bundle;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.tycho.versions.bundle.ManifestAttribute;
import org.eclipse.tycho.versions.bundle.MutableManifestElement;
import org.eclipse.tycho.versions.engine.Versions;
import org.osgi.framework.BundleException;

public class MutableBundleManifest {
    private final List<ManifestAttribute> attributes = new ArrayList<ManifestAttribute>();
    private String lineEnding = "";
    private String unparsed;

    public void add(ManifestAttribute attribute) {
        this.attributes.add(attribute);
    }

    public static MutableBundleManifest read(File file) throws IOException {
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
            MutableBundleManifest mutableBundleManifest = MutableBundleManifest.read(is);
            return mutableBundleManifest;
        }
    }

    public static MutableBundleManifest read(InputStream is) throws IOException {
        String str;
        PushbackReader br = new PushbackReader(new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8)), 1);
        MutableBundleManifest mf = new MutableBundleManifest();
        ManifestAttribute curr = null;
        while ((str = MutableBundleManifest.readLineWithLineEnding(br, mf::setLineEndingWhenFirstLine)) != null && !str.trim().isEmpty()) {
            if (str.charAt(0) == ' ') {
                if (curr == null) {
                    throw new IOException("");
                }
                curr.add(str);
                continue;
            }
            curr = new ManifestAttribute(str);
            mf.add(curr);
        }
        if (str != null) {
            int ch;
            StringBuilder sb = new StringBuilder(str);
            while ((ch = br.read()) != -1) {
                sb.append((char)ch);
            }
            mf.setUnparsed(sb.toString());
        }
        return mf;
    }

    public static String readLineWithLineEnding(PushbackReader reader, Consumer<String> lineEndingConsumer) throws IOException {
        int ch;
        StringBuilder result = new StringBuilder();
        int lastch = -1;
        while ((ch = reader.read()) != -1) {
            if (lastch == 13) {
                if (ch == 10) {
                    result.append((char)ch);
                    lineEndingConsumer.accept("\r\n");
                    break;
                }
                reader.unread(ch);
                lineEndingConsumer.accept("\r");
                break;
            }
            result.append((char)ch);
            if (ch == 10 || ch == 8232 || ch == 8233 || ch == 133) {
                lineEndingConsumer.accept(new String(new char[]{(char)ch}));
                break;
            }
            lastch = ch;
        }
        if (result.length() > 0) {
            return result.toString();
        }
        return null;
    }

    private void setLineEndingWhenFirstLine(String lineEnding) {
        if (this.lineEnding.isEmpty() && lineEnding != null) {
            this.lineEnding = lineEnding;
        }
    }

    private void setUnparsed(String unparsed) {
        this.unparsed = unparsed;
    }

    public static void write(MutableBundleManifest mf, File file) throws IOException {
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));){
            MutableBundleManifest.write(mf, os);
        }
    }

    public static void write(MutableBundleManifest mf, OutputStream os) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(os, StandardCharsets.UTF_8);
        for (ManifestAttribute attribute : mf.attributes) {
            attribute.writeTo(w, mf.lineEnding);
        }
        if (mf.unparsed != null) {
            w.write(mf.unparsed);
        }
        ((Writer)w).flush();
    }

    public String getSymbolicName() {
        ManifestElement[] id = this.parseHeader("Bundle-SymbolicName");
        if (id != null && id.length > 0) {
            return id[0].getValue();
        }
        return null;
    }

    public String getVersion() {
        ManifestElement[] version = this.parseHeader("Bundle-Version");
        if (version != null && version.length > 0) {
            return version[0].getValue();
        }
        return null;
    }

    public String getFragmentHostSymbolicName() {
        ManifestElement[] fragmentHost = this.parseHeader("Fragment-Host");
        if (fragmentHost != null && fragmentHost.length > 0) {
            return fragmentHost[0].getValue();
        }
        return null;
    }

    public boolean isFragment() {
        return this.getFragmentHostSymbolicName() != null;
    }

    public String getFragmentHostVersion() {
        ManifestElement[] fragmentHost = this.parseHeader("Fragment-Host");
        if (fragmentHost != null && fragmentHost.length > 0) {
            return fragmentHost[0].getAttribute("bundle-version");
        }
        return null;
    }

    public void setFragmentHostVersion(String newVersion) {
        newVersion = Versions.toBaseVersion(newVersion);
        List<MutableManifestElement> fragmentHostElements = this.parseHeaderForMutation("Fragment-Host");
        if (fragmentHostElements == null || fragmentHostElements.isEmpty()) {
            return;
        }
        fragmentHostElements.get(0).setAttribute("bundle-version", newVersion);
        this.getAttribute("Fragment-Host").set("Fragment-Host", fragmentHostElements);
    }

    public Map<String, String> getRequiredBundleVersions() {
        ManifestElement[] requireBundleElements = this.parseHeader("Require-Bundle");
        if (requireBundleElements == null || requireBundleElements.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (ManifestElement manifestElement : requireBundleElements) {
            String symbolicName = manifestElement.getValue();
            String versionRangeString = manifestElement.getAttribute("bundle-version");
            result.put(symbolicName, versionRangeString);
        }
        return result;
    }

    public void updateRequiredBundleVersions(Map<String, String> versionsToUpdate) {
        List<MutableManifestElement> requireBundleElements = this.parseHeaderForMutation("Require-Bundle");
        if (requireBundleElements == null || requireBundleElements.isEmpty()) {
            return;
        }
        boolean somethingChanged = false;
        for (MutableManifestElement mutableManifestElement : requireBundleElements) {
            String bundleSymbolicName = mutableManifestElement.getValue();
            if (!versionsToUpdate.containsKey(bundleSymbolicName)) continue;
            somethingChanged |= mutableManifestElement.setAttribute("bundle-version", versionsToUpdate.get(bundleSymbolicName));
        }
        if (somethingChanged) {
            this.getAttribute("Require-Bundle").set("Require-Bundle", requireBundleElements);
        }
    }

    public Map<String, String> getImportPackagesVersions() {
        ManifestElement[] importPackageElements = this.parseHeader("Import-Package");
        if (importPackageElements == null || importPackageElements.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (ManifestElement manifestElement : importPackageElements) {
            String packageName = manifestElement.getValue();
            String versionRangeString = manifestElement.getAttribute("version");
            result.put(packageName, versionRangeString);
        }
        return result;
    }

    public void updateImportedPackageVersions(Map<String, String> versionsToUpdate) {
        List<MutableManifestElement> importPackageElements = this.parseHeaderForMutation("Import-Package");
        if (importPackageElements == null || importPackageElements.isEmpty()) {
            return;
        }
        boolean somethingChanged = false;
        for (MutableManifestElement mutableManifestElement : importPackageElements) {
            String packageName = mutableManifestElement.getValue();
            if (!versionsToUpdate.containsKey(packageName)) continue;
            somethingChanged |= mutableManifestElement.setAttribute("version", versionsToUpdate.get(packageName));
        }
        if (somethingChanged) {
            this.getAttribute("Import-Package").set("Import-Package", importPackageElements);
        }
    }

    public Map<String, String> getExportedPackagesVersion() {
        ManifestElement[] exportPackageElements = this.parseHeader("Export-Package");
        if (exportPackageElements == null || exportPackageElements.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (ManifestElement manifestElement : exportPackageElements) {
            String packageName = manifestElement.getValue();
            String versionRangeString = manifestElement.getAttribute("version");
            result.put(packageName, versionRangeString);
        }
        return result;
    }

    public void updateExportedPackageVersions(Map<String, String> versionsToUpdate) {
        List<MutableManifestElement> exportPackageElements = this.parseHeaderForMutation("Export-Package");
        if (exportPackageElements == null || exportPackageElements.isEmpty()) {
            return;
        }
        boolean somethingChanged = false;
        for (MutableManifestElement mutableManifestElement : exportPackageElements) {
            String packageName = mutableManifestElement.getValue();
            if (!versionsToUpdate.containsKey(packageName)) continue;
            somethingChanged |= mutableManifestElement.setAttribute("version", versionsToUpdate.get(packageName));
        }
        if (somethingChanged) {
            this.getAttribute("Export-Package").set("Export-Package", exportPackageElements);
        }
    }

    private ManifestElement[] parseHeader(String name) {
        ManifestAttribute property = this.getAttribute(name);
        if (property == null) {
            return null;
        }
        try {
            return ManifestElement.parseHeader((String)name, (String)property.getValue());
        }
        catch (BundleException e) {
            throw new IllegalArgumentException("Could not parse bundle manifest", e);
        }
    }

    private List<MutableManifestElement> parseHeaderForMutation(String name) {
        ManifestAttribute property = this.getAttribute(name);
        if (property == null) {
            return null;
        }
        try {
            return MutableManifestElement.parseHeader(name, property.getValue());
        }
        catch (BundleException e) {
            throw new IllegalArgumentException("Could not parse bundle manifest", e);
        }
    }

    private ManifestAttribute getAttribute(String name) {
        for (ManifestAttribute attribute : this.attributes) {
            if (!attribute.hasName(name)) continue;
            return attribute;
        }
        return null;
    }

    public void setVersion(String version) {
        ManifestAttribute attr = this.getAttribute("Bundle-Version");
        if (attr != null) {
            attr.set("Bundle-Version", version);
        } else {
            this.attributes.add(new ManifestAttribute("Bundle-Version", version));
        }
    }
}

