/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versions.manipulation;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.tycho.model.Feature;
import org.eclipse.tycho.model.FeatureRef;
import org.eclipse.tycho.model.PluginRef;
import org.eclipse.tycho.versions.engine.ImportRefVersionConstraint;
import org.eclipse.tycho.versions.engine.MetadataManipulator;
import org.eclipse.tycho.versions.engine.PomVersionChange;
import org.eclipse.tycho.versions.engine.ProjectMetadata;
import org.eclipse.tycho.versions.engine.VersionChangesDescriptor;
import org.eclipse.tycho.versions.engine.VersionRangeUpdateStrategy;
import org.eclipse.tycho.versions.engine.Versions;
import org.eclipse.tycho.versions.manipulation.AbstractMetadataManipulator;

@Component(role=MetadataManipulator.class, hint="eclipse-feature")
public class FeatureXmlManipulator
extends AbstractMetadataManipulator {
    @Override
    public void applyChanges(ProjectMetadata project, VersionChangesDescriptor versionChangeContext) {
        if (this.isFeature(project)) {
            Feature feature = this.getFeatureXml(project);
            for (PomVersionChange change : versionChangeContext.getVersionChanges()) {
                if (this.isFeature(change.getProject().getPackaging())) {
                    if (change.getArtifactId().equals(feature.getId()) && change.getVersion().equals(feature.getVersion())) {
                        this.logger.info("  feature.xml//feature/@version: " + change.getVersion() + " => " + change.getNewVersion());
                        feature.setVersion(change.getNewVersion());
                    }
                    this.changeLicenseFeature(change, feature);
                    this.changeIncludedFeatures(change, feature);
                    this.changeRequiredFeatures(change, feature, versionChangeContext.getVersionRangeUpdateStrategy());
                    continue;
                }
                if (!this.isBundle(change.getProject())) continue;
                this.changeIncludedPlugins(change, feature);
                this.changeRequiredPlugins(change, feature, versionChangeContext.getVersionRangeUpdateStrategy());
            }
        }
    }

    @Override
    public Collection<String> validateChanges(ProjectMetadata project, VersionChangesDescriptor versionChangeContext) {
        if (this.isFeature(project)) {
            Feature feature = this.getFeatureXml(project);
            for (PomVersionChange change : versionChangeContext.getVersionChanges()) {
                if (!change.getArtifactId().equals(feature.getId()) || !change.getVersion().equals(feature.getVersion())) continue;
                String error = Versions.validateOsgiVersion(change.getNewVersion(), this.getFeatureFile(project));
                return error != null ? Collections.singleton(error) : null;
            }
        }
        return null;
    }

    private void changeLicenseFeature(PomVersionChange change, Feature feature) {
        if (change.getArtifactId().equals(feature.getLicenseFeature()) && change.getVersion().equals(feature.getLicenseFeatureVersion())) {
            this.logger.info("  feature.xml//feature/@license-feature='" + feature.getLicenseFeature() + "'/@license-feature-version: " + change.getVersion() + " => " + change.getNewVersion());
            feature.setLicenseFeatureVersion(change.getNewVersion());
        }
    }

    private void changeIncludedFeatures(PomVersionChange change, Feature feature) {
        for (FeatureRef ref : feature.getIncludedFeatures()) {
            if (!change.getArtifactId().equals(ref.getId()) || !change.getVersion().equals(ref.getVersion())) continue;
            this.logger.info("  feature.xml//feature/includes/@id='" + ref.getId() + "'/@version: " + change.getVersion() + " => " + change.getNewVersion());
            ref.setVersion(change.getNewVersion());
        }
    }

    private void changeIncludedPlugins(PomVersionChange change, Feature feature) {
        for (PluginRef plugin : feature.getPlugins()) {
            if (!change.getArtifactId().equals(plugin.getId()) || !change.getVersion().equals(plugin.getVersion())) continue;
            this.logger.info("  feature.xml//feature/plugin/@id='" + plugin.getId() + "'/@version: " + change.getVersion() + " => " + change.getNewVersion());
            plugin.setVersion(change.getNewVersion());
        }
    }

    private void changeRequiredFeatures(PomVersionChange featureVersionChange, Feature feature, VersionRangeUpdateStrategy versionRangeUpdateStrategy) {
        for (Feature.RequiresRef ref : feature.getRequires()) {
            for (Feature.ImportRef importRef : ref.getImports()) {
                ImportRefVersionConstraint newImportRefVersionConstraint;
                if (importRef.getFeature() == null || !importRef.getFeature().equals(featureVersionChange.getArtifactId())) continue;
                boolean isPatch = importRef.getPatch().equals("true");
                ImportRefVersionConstraint originalVersionConstraint = new ImportRefVersionConstraint(importRef.getVersion(), isPatch ? "perfect" : importRef.getMatch());
                if (originalVersionConstraint.equals(newImportRefVersionConstraint = versionRangeUpdateStrategy.computeNewImportRefVersionConstraint(originalVersionConstraint, featureVersionChange.getVersion(), featureVersionChange.getNewVersion()))) continue;
                this.logger.info("  feature.xml//feature/requires/import/@feature='" + importRef.getFeature() + "'/@version: " + originalVersionConstraint + " => " + newImportRefVersionConstraint);
                importRef.setVersion(newImportRefVersionConstraint.getVersion());
                if (isPatch) continue;
                importRef.setMatch(newImportRefVersionConstraint.getMatch());
            }
        }
    }

    private void changeRequiredPlugins(PomVersionChange bundleVersionChange, Feature feature, VersionRangeUpdateStrategy versionRangeUpdateStrategy) {
        for (Feature.RequiresRef ref : feature.getRequires()) {
            for (Feature.ImportRef importRef : ref.getImports()) {
                ImportRefVersionConstraint newImportRefVersionConstraint;
                ImportRefVersionConstraint originalVersionConstraint;
                if (importRef.getPlugin() == null || !importRef.getPlugin().equals(bundleVersionChange.getArtifactId()) || (originalVersionConstraint = new ImportRefVersionConstraint(importRef.getVersion(), importRef.getMatch())).equals(newImportRefVersionConstraint = versionRangeUpdateStrategy.computeNewImportRefVersionConstraint(originalVersionConstraint, bundleVersionChange.getVersion(), bundleVersionChange.getNewVersion()))) continue;
                this.logger.info("  feature.xml//feature/requires/import/@plugin='" + importRef.getPlugin() + "'/@version: " + originalVersionConstraint + " => " + newImportRefVersionConstraint);
                importRef.setVersion(newImportRefVersionConstraint.getVersion());
                importRef.setMatch(newImportRefVersionConstraint.getMatch());
            }
        }
    }

    private Feature getFeatureXml(ProjectMetadata project) {
        Feature feature = project.getMetadata(Feature.class);
        if (feature == null) {
            File file = this.getFeatureFile(project);
            try {
                feature = Feature.read((File)file);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not read feature descriptor" + file, e);
            }
            project.putMetadata(feature);
        }
        return feature;
    }

    private File getFeatureFile(ProjectMetadata project) {
        return new File(project.getBasedir(), "feature.xml");
    }

    @Override
    public void writeMetadata(ProjectMetadata project) throws IOException {
        Feature feature = project.getMetadata(Feature.class);
        if (feature != null) {
            Feature.write((Feature)feature, (File)this.getFeatureFile(project));
        }
    }
}

