/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versions.engine;

import java.util.Objects;
import org.osgi.framework.Version;

public class ImportRefVersionConstraint {
    public static final String MATCH_GREATER_OR_EQUAL = "greaterOrEqual";
    public static final String MATCH_COMPATIBLE = "compatible";
    public static final String MATCH_EQUIVALENT = "equivalent";
    public static final String MATCH_PERFECT = "perfect";
    private final String version;
    private final String match;

    public ImportRefVersionConstraint(String version, String match) {
        this.version = version;
        this.match = match;
    }

    public String getVersion() {
        return this.version;
    }

    public String getMatch() {
        return this.match;
    }

    public ImportRefVersionConstraint withVersion(String newVersion) {
        return new ImportRefVersionConstraint(newVersion, this.getMatch());
    }

    public boolean matches(String otherVersion) {
        if (this.version == null) {
            return true;
        }
        Version parsedLocalVersion = Version.parseVersion((String)this.version);
        Version parsedOtherVersion = Version.parseVersion((String)otherVersion);
        if (this.match == null) {
            return this.isCompatible(parsedLocalVersion, parsedOtherVersion);
        }
        return switch (this.match) {
            case MATCH_PERFECT -> this.isPerfectMatch(parsedLocalVersion, parsedOtherVersion);
            case MATCH_EQUIVALENT -> this.isEquivalent(parsedLocalVersion, parsedOtherVersion);
            case MATCH_COMPATIBLE -> this.isCompatible(parsedLocalVersion, parsedOtherVersion);
            case MATCH_GREATER_OR_EQUAL -> this.isGreaterOrEqual(parsedLocalVersion, parsedOtherVersion);
            default -> this.isCompatible(parsedLocalVersion, parsedOtherVersion);
        };
    }

    private boolean isPerfectMatch(Version parsedLocalVersion, Version parsedOtherVersion) {
        return parsedLocalVersion.compareTo(parsedOtherVersion) == 0;
    }

    private boolean isEquivalent(Version parsedLocalVersion, Version parsedOtherVersion) {
        return this.isGreaterOrEqual(parsedLocalVersion, parsedOtherVersion) && parsedLocalVersion.getMajor() == parsedOtherVersion.getMajor() && parsedLocalVersion.getMinor() == parsedOtherVersion.getMinor();
    }

    private boolean isCompatible(Version parsedLocalVersion, Version parsedOtherVersion) {
        return this.isGreaterOrEqual(parsedLocalVersion, parsedOtherVersion) && parsedLocalVersion.getMajor() == parsedOtherVersion.getMajor();
    }

    private boolean isGreaterOrEqual(Version parsedLocalVersion, Version parsedOtherVersion) {
        return parsedLocalVersion.compareTo(parsedOtherVersion) <= 0;
    }

    public int hashCode() {
        return Objects.hash(this.version, this.match);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImportRefVersionConstraint other = (ImportRefVersionConstraint)obj;
        return Objects.equals(this.version, other.version) && Objects.equals(this.match, other.match);
    }

    public String toString() {
        if (this.version == null) {
            return "<no version>";
        }
        return this.version + "(match=" + this.match + ")";
    }
}

