/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versions;

import java.io.IOException;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.tycho.versions.AbstractChangeMojo;
import org.eclipse.tycho.versions.engine.VersionsEngine;

@Mojo(name="set-version", aggregator=true, requiresDependencyResolution=ResolutionScope.NONE)
public class SetVersionMojo
extends AbstractChangeMojo {
    @Parameter(property="newVersion", required=true, alias="developmentVersion")
    private String newVersion;
    @Parameter(property="updateVersionRangeMatchingBounds", defaultValue="false")
    private boolean updateVersionRangeMatchingBounds;
    @Parameter(property="properties")
    private String properties;

    @Override
    protected void addChanges(List<String> artifacts, VersionsEngine engine) throws MojoExecutionException, IOException {
        engine.setUpdateVersionRangeMatchingBounds(this.updateVersionRangeMatchingBounds);
        for (String artifactId : artifacts) {
            engine.addVersionChange(artifactId, this.newVersion);
            for (String propertyName : SetVersionMojo.split(this.properties)) {
                engine.addPropertyChange(artifactId, propertyName, this.newVersion);
            }
        }
    }
}

