/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versions.pom;

import de.pdark.decentxml.Document;
import de.pdark.decentxml.Element;
import de.pdark.decentxml.Node;
import de.pdark.decentxml.Parent;
import de.pdark.decentxml.Text;
import de.pdark.decentxml.XMLIOSource;
import de.pdark.decentxml.XMLParseException;
import de.pdark.decentxml.XMLParser;
import de.pdark.decentxml.XMLSource;
import de.pdark.decentxml.XMLWriter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.tycho.versions.pom.Build;
import org.eclipse.tycho.versions.pom.Dependencies;
import org.eclipse.tycho.versions.pom.DependencyManagement;
import org.eclipse.tycho.versions.pom.GAV;
import org.eclipse.tycho.versions.pom.Profile;
import org.eclipse.tycho.versions.pom.Property;

public class PomFile {
    public static final String POM_XML = "pom.xml";
    private static final String DEFAULT_XML_ENCODING = "UTF-8";
    private static XMLParser parser = new XMLParser();
    private Document document;
    private Element project;
    private String version;
    private final boolean preferExplicitProjectVersion;
    private final boolean isMutable;

    public PomFile(Document pom, boolean isMutable) {
        this.document = pom;
        this.isMutable = isMutable;
        this.project = this.document.getRootElement();
        this.version = this.getExplicitVersionFromXML();
        if (this.version == null) {
            this.version = this.getParentVersion();
            this.preferExplicitProjectVersion = false;
        } else {
            this.preferExplicitProjectVersion = this.version.equals(this.getParentVersion());
        }
    }

    public static PomFile read(File file, boolean isMutable) throws IOException {
        PomFile pomFile;
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
        try {
            pomFile = PomFile.read(is, isMutable);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (XMLParseException xpe) {
                throw new XMLParseException("This Pom " + file.getAbsolutePath() + " is in the Wrong Format", (Throwable)xpe);
            }
        }
        ((InputStream)is).close();
        return pomFile;
    }

    public static PomFile read(InputStream input, boolean isMutable) throws IOException {
        return new PomFile(parser.parse((XMLSource)new XMLIOSource(input)), isMutable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(PomFile pom, OutputStream out) throws IOException {
        String encoding = pom.document.getEncoding() != null ? pom.document.getEncoding() : DEFAULT_XML_ENCODING;
        OutputStreamWriter w = new OutputStreamWriter(out, encoding);
        XMLWriter xw = new XMLWriter((Writer)w);
        try {
            pom.setVersionInXML();
            pom.document.toXML(xw);
        }
        finally {
            xw.flush();
        }
    }

    public static void write(PomFile pom, File file) throws IOException {
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));){
            PomFile.write(pom, os);
        }
    }

    private String getExplicitVersionFromXML() {
        return this.getElementValue("version");
    }

    private void setVersionInXML() {
        boolean writeProjectVersion;
        boolean bl = writeProjectVersion = this.preferExplicitProjectVersion || !this.version.equals(this.getParentVersion());
        if (writeProjectVersion) {
            Element versionElement = this.project.getChild("version");
            if (versionElement == null) {
                versionElement = PomFile.addEmptyVersionElementToXML(this.project);
            }
            versionElement.setText(this.version);
        } else {
            PomFile.removeVersionElementFromXML(this.project);
        }
    }

    private static Element addEmptyVersionElementToXML(Element project) {
        Element result = new Element((Parent)project, "version");
        project.addNode((Node)new Text("\n"));
        return result;
    }

    private static void removeVersionElementFromXML(Element project) {
        List elements = project.getNodes();
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (!(node instanceof Element) || !"version".equals(((Element)node).getName())) continue;
            iterator.remove();
            if (iterator.hasNext() && iterator.next() instanceof Text) {
                iterator.remove();
            }
            return;
        }
    }

    public void setParentVersion(String newVersion) {
        Element element = this.project.getChild("parent/version");
        if (element == null) {
            throw new IllegalArgumentException("No parent/version");
        }
        element.setText(newVersion);
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public String getPackaging() {
        String packaging = this.getElementValue("packaging");
        return packaging != null ? packaging : "jar";
    }

    public String getParentVersion() {
        GAV parent = this.getParent();
        return parent != null ? parent.getVersion() : null;
    }

    private String getExplicitGroupId() {
        return this.getElementValue("groupId");
    }

    public String getGroupId() {
        String groupId = this.getExplicitGroupId();
        if (groupId == null) {
            groupId = this.getParent().getGroupId();
        }
        return groupId;
    }

    public String getArtifactId() {
        return this.getElementValue("artifactId");
    }

    public GAV getParent() {
        Element element = this.project.getChild("parent");
        return element != null ? new GAV(element) : null;
    }

    public List<String> getModules() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Element modules : this.project.getChildren("modules")) {
            for (Element module : modules.getChildren("module")) {
                result.add(module.getTrimmedText());
            }
        }
        return new ArrayList<String>(result);
    }

    public List<Profile> getProfiles() {
        ArrayList<Profile> result = new ArrayList<Profile>();
        for (Element profiles : this.project.getChildren("profiles")) {
            for (Element profile : profiles.getChildren("profile")) {
                result.add(new Profile(profile));
            }
        }
        return result;
    }

    public DependencyManagement getDependencyManagement() {
        return DependencyManagement.getDependencyManagement(this.project);
    }

    public List<GAV> getDependencies() {
        return Dependencies.getDependencies(this.project);
    }

    public Build getBuild() {
        return Build.getBuild(this.project);
    }

    public List<Property> getProperties() {
        return Property.getProperties(this.project);
    }

    private String getElementValue(String name) {
        Element child = this.project.getChild(name);
        return child != null ? child.getTrimmedText() : null;
    }

    public boolean isMutable() {
        return this.isMutable;
    }
}

