/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versions.engine;

import org.eclipse.tycho.versions.engine.Versions;

public class VersionChange {
    private final String version;
    private final String newVersion;

    public VersionChange(String version, String newVersion) {
        this.version = Versions.toCanonicalVersion(version);
        this.newVersion = Versions.toCanonicalVersion(newVersion);
    }

    public String getVersion() {
        return this.version;
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    public int hashCode() {
        int hash = this.version.hashCode();
        hash = 17 * hash + this.newVersion.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof VersionChange)) {
            return false;
        }
        VersionChange other = (VersionChange)obj;
        return this.version.equals(other.version) && this.newVersion.equals(other.newVersion);
    }

    public String toString() {
        return this.version + " => " + this.newVersion;
    }
}

