/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versions.engine;

import org.eclipse.tycho.versions.engine.VersionChange;
import org.eclipse.tycho.versions.pom.PomFile;

public class PomVersionChange
extends VersionChange {
    private final PomFile pom;

    public PomVersionChange(PomFile pom, String newVersion) {
        this(pom, pom.getVersion(), newVersion);
    }

    public PomVersionChange(PomFile pom, String version, String newVersion) {
        super(version, newVersion);
        this.pom = pom;
    }

    public String getGroupId() {
        return this.pom.getGroupId();
    }

    public String getArtifactId() {
        return this.pom.getArtifactId();
    }

    public PomFile getProject() {
        return this.pom;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 17 * hash + this.pom.getGroupId().hashCode();
        hash = 17 * hash + this.pom.getArtifactId().hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PomVersionChange)) {
            return false;
        }
        PomVersionChange other = (PomVersionChange)obj;
        return super.equals(other) && this.pom.getGroupId().equals(other.pom.getGroupId()) && this.pom.getArtifactId().equals(other.getArtifactId());
    }

    @Override
    public String toString() {
        return this.pom.getGroupId() + ":" + this.pom.getArtifactId() + ":" + super.toString();
    }
}

