/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versions.engine;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.tycho.versions.engine.IllegalVersionChangeException;
import org.eclipse.tycho.versions.engine.MetadataManipulator;
import org.eclipse.tycho.versions.engine.ProjectMetadata;
import org.eclipse.tycho.versions.engine.VersionChange;
import org.eclipse.tycho.versions.manipulation.PomManipulator;
import org.eclipse.tycho.versions.pom.MutablePomFile;

@Component(role=VersionsEngine.class, instantiationStrategy="per-lookup")
public class VersionsEngine {
    @Requirement
    private Logger logger;
    @Requirement(role=MetadataManipulator.class)
    private List<MetadataManipulator> manipulators;
    @Requirement(hint="pom")
    private MetadataManipulator pomManipulator;
    private Collection<ProjectMetadata> projects;
    private Set<VersionChange> versionChanges = new LinkedHashSet<VersionChange>();
    private Set<PropertyChange> propertyChanges = new LinkedHashSet<PropertyChange>();

    public void setProjects(Collection<ProjectMetadata> projects) {
        this.projects = projects;
    }

    public void addVersionChange(String artifactId, String newVersion) throws IOException {
        MutablePomFile pom = this.getMutablePom(artifactId);
        if (!newVersion.equals(pom.getVersion())) {
            this.addVersionChange(new VersionChange(pom, newVersion));
        }
    }

    private MutablePomFile getMutablePom(String artifactId) throws IOException {
        ProjectMetadata project = this.getProject(artifactId);
        if (project == null) {
            throw new IOException("Project with artifactId=" + artifactId + " cound not be found");
        }
        return project.getMetadata(MutablePomFile.class);
    }

    public void addVersionChange(VersionChange change) {
        this.versionChanges.add(change);
    }

    public void apply() throws IOException {
        boolean newChanges = true;
        while (newChanges) {
            newChanges = false;
            for (VersionChange change : new ArrayList<VersionChange>(this.versionChanges)) {
                for (ProjectMetadata project : this.projects) {
                    for (MetadataManipulator manipulator : this.manipulators) {
                        newChanges |= manipulator.addMoreChanges(project, change, this.versionChanges);
                    }
                }
            }
        }
        ArrayList<String> errors = new ArrayList<String>();
        for (ProjectMetadata project : this.projects) {
            for (VersionChange change : this.versionChanges) {
                for (MetadataManipulator manipulator : this.manipulators) {
                    Collection<String> error = manipulator.validateChange(project, change);
                    if (error == null) continue;
                    errors.addAll(error);
                }
            }
        }
        if (!errors.isEmpty()) {
            throw new IllegalVersionChangeException(errors);
        }
        for (ProjectMetadata project : this.projects) {
            this.logger.info("Making changes in " + project.getBasedir().getAbsolutePath());
            HashSet applied = new HashSet();
            MutablePomFile pom = project.getMetadata(MutablePomFile.class);
            for (PropertyChange propertyChange : this.propertyChanges) {
                if (pom != propertyChange.pom) continue;
                ((PomManipulator)this.pomManipulator).applyPropertyChange(pom, propertyChange.propertyName, propertyChange.propertyValue);
            }
            for (VersionChange change : this.versionChanges) {
                if (applied.contains(change)) continue;
                this.applyChange(project, change);
            }
        }
        for (ProjectMetadata project : this.projects) {
            for (MetadataManipulator manipulator : this.manipulators) {
                manipulator.writeMetadata(project);
            }
        }
    }

    private void applyChange(ProjectMetadata project, VersionChange change) {
        for (MetadataManipulator manipulator : this.manipulators) {
            manipulator.applyChange(project, change, this.versionChanges);
        }
    }

    private ProjectMetadata getProject(String artifactId) {
        for (ProjectMetadata project : this.projects) {
            MutablePomFile pom = project.getMetadata(MutablePomFile.class);
            if (!artifactId.equals(pom.getArtifactId())) continue;
            return project;
        }
        return null;
    }

    public void addPropertyChange(String artifactId, String propertyName, String propertyValue) throws IOException {
        MutablePomFile pom = this.getMutablePom(artifactId);
        this.propertyChanges.add(new PropertyChange(pom, propertyName, propertyValue));
    }

    private static class PropertyChange {
        final MutablePomFile pom;
        final String propertyName;
        String propertyValue;

        public PropertyChange(MutablePomFile pom, String propertyName, String propertyValue) {
            this.pom = pom;
            this.propertyName = propertyName;
            this.propertyValue = propertyValue;
        }
    }
}

