/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versions.bundle;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.codehaus.plexus.util.IOUtil;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.tycho.versions.bundle.ManifestAttribute;
import org.eclipse.tycho.versions.engine.Versions;
import org.osgi.framework.BundleException;

public class MutableBundleManifest {
    private final List<ManifestAttribute> attributes = new ArrayList<ManifestAttribute>();
    private String lineEnding = "";
    private String unparsed;

    public void add(ManifestAttribute attribute) {
        this.attributes.add(attribute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MutableBundleManifest read(File file) throws IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
        try {
            MutableBundleManifest mutableBundleManifest = MutableBundleManifest.read(is);
            return mutableBundleManifest;
        }
        finally {
            IOUtil.close((InputStream)is);
        }
    }

    public static MutableBundleManifest read(InputStream is) throws IOException {
        String str;
        PushbackReader br = new PushbackReader(new BufferedReader(new InputStreamReader(is, "UTF8")), 1);
        MutableBundleManifest mf = new MutableBundleManifest();
        ManifestAttribute curr = null;
        while ((str = MutableBundleManifest.readLineWithLineEnding(br, mf)) != null && str.trim().length() != 0) {
            if (str.charAt(0) == ' ') {
                if (curr == null) {
                    throw new IOException("");
                }
                curr.add(str);
                continue;
            }
            curr = new ManifestAttribute(str);
            mf.add(curr);
        }
        if (str != null) {
            int ch;
            StringBuilder sb = new StringBuilder(str);
            while ((ch = br.read()) != -1) {
                sb.append((char)ch);
            }
            mf.setUnparsed(sb.toString());
        }
        return mf;
    }

    private static String readLineWithLineEnding(PushbackReader reader, MutableBundleManifest mf) throws IOException {
        int ch;
        StringBuilder result = new StringBuilder();
        int lastch = -1;
        while ((ch = reader.read()) != -1) {
            if (lastch == 13) {
                if (ch == 10) {
                    result.append((char)ch);
                    mf.setLineEndingWhenFirstLine("\r\n");
                    break;
                }
                reader.unread(ch);
                mf.setLineEndingWhenFirstLine("\r");
                break;
            }
            result.append((char)ch);
            if (ch == 10 || ch == 8232 || ch == 8233 || ch == 133) {
                mf.setLineEndingWhenFirstLine(new String(new char[]{(char)ch}));
                break;
            }
            lastch = ch;
        }
        if (result.length() > 0) {
            return result.toString();
        }
        return null;
    }

    private void setLineEndingWhenFirstLine(String lineEnding) {
        if (this.lineEnding.length() == 0 && lineEnding != null) {
            this.lineEnding = lineEnding;
        }
    }

    private void setUnparsed(String unparsed) {
        this.unparsed = unparsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(MutableBundleManifest mf, File file) throws IOException {
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
        try {
            MutableBundleManifest.write(mf, os);
        }
        finally {
            IOUtil.close((OutputStream)os);
        }
    }

    public static void write(MutableBundleManifest mf, OutputStream os) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(os, "UTF8");
        for (ManifestAttribute attribute : mf.attributes) {
            attribute.writeTo(w, mf.lineEnding);
        }
        if (mf.unparsed != null) {
            w.write(mf.unparsed);
        }
        ((Writer)w).flush();
    }

    public String getSymbolicName() {
        ManifestElement[] id = this.parseHeader("Bundle-SymbolicName");
        if (id != null && id.length > 0) {
            return id[0].getValue();
        }
        return null;
    }

    public String getVersion() {
        ManifestElement[] version = this.parseHeader("Bundle-Version");
        if (version != null && version.length > 0) {
            return version[0].getValue();
        }
        return null;
    }

    private ManifestElement[] parseHeader(String name) {
        ManifestAttribute property = this.getAttribute(name);
        if (property == null) {
            return null;
        }
        try {
            return ManifestElement.parseHeader((String)name, (String)property.getValue());
        }
        catch (BundleException e) {
            throw new IllegalArgumentException("Could not parse bundle manifest", e);
        }
    }

    private ManifestAttribute getAttribute(String name) {
        for (ManifestAttribute attribute : this.attributes) {
            if (!attribute.hasName(name)) continue;
            return attribute;
        }
        return null;
    }

    public void setVersion(String version) {
        ManifestAttribute attr = this.getAttribute("Bundle-Version");
        if (attr != null) {
            attr.set("Bundle-Version", version);
        } else {
            this.attributes.add(new ManifestAttribute("Bundle-Version", version));
        }
    }

    public void setExportedPackageVersion(String oldVersion, String newVersion) {
        ManifestAttribute attr = this.getAttribute("Export-Package");
        if (attr == null) {
            return;
        }
        String oldBaseVersion = Versions.toBaseVersion(oldVersion);
        String newBaseVersion = Versions.toBaseVersion(newVersion);
        String oldExportedPackage = attr.getValue();
        String newExportedPackage = oldExportedPackage.replaceAll(";version=\"" + Pattern.quote(oldBaseVersion) + "\"", ";version=\"" + newBaseVersion + "\"");
        if (!newExportedPackage.equals(oldExportedPackage)) {
            attr.set("Export-Package", newExportedPackage);
        }
    }
}

