/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.targetplatform;

import java.util.Objects;
import java.util.StringJoiner;

public final class TargetPlatformFilter {
    private final CapabilityPattern scopePattern;
    private final FilterAction action;
    private final CapabilityPattern actionPattern;

    public static TargetPlatformFilter removeAllFilter(CapabilityPattern scopePattern) {
        return new TargetPlatformFilter(scopePattern, FilterAction.REMOVE_ALL, null);
    }

    public static TargetPlatformFilter restrictionFilter(CapabilityPattern scopePattern, CapabilityPattern restrictionPattern) {
        return new TargetPlatformFilter(scopePattern, FilterAction.RESTRICT, restrictionPattern);
    }

    private TargetPlatformFilter(CapabilityPattern scopePattern, FilterAction action, CapabilityPattern actionPattern) {
        this.scopePattern = scopePattern;
        this.action = action;
        this.actionPattern = actionPattern;
    }

    public CapabilityPattern getScopePattern() {
        return this.scopePattern;
    }

    public FilterAction getAction() {
        return this.action;
    }

    public CapabilityPattern getActionPattern() {
        return this.actionPattern;
    }

    public String toString() {
        String commonPart = "TargetPlatformFilter(scope=" + String.valueOf(this.scopePattern) + ", action=" + String.valueOf((Object)this.action);
        return switch (this.action.ordinal()) {
            case 0 -> commonPart + ")";
            case 1 -> commonPart + ", restriction=" + String.valueOf(this.actionPattern) + ")";
            default -> super.toString();
        };
    }

    public static enum FilterAction {
        REMOVE_ALL,
        RESTRICT;

    }

    public static final class CapabilityPattern {
        private final CapabilityType type;
        private final String id;
        private final String version;
        private final String versionRange;

        public static CapabilityPattern patternWithVersion(CapabilityType type, String id, String version) {
            return new CapabilityPattern(type, id, version, null);
        }

        public static CapabilityPattern patternWithVersionRange(CapabilityType type, String id, String versionRange) {
            return new CapabilityPattern(type, id, null, versionRange);
        }

        public static CapabilityPattern patternWithoutVersion(CapabilityType type, String id) {
            return new CapabilityPattern(type, id, null, null);
        }

        private CapabilityPattern(CapabilityType type, String id, String version, String versionRange) {
            this.type = type;
            this.id = id;
            this.version = version;
            this.versionRange = versionRange;
        }

        public CapabilityType getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        public String getVersion() {
            return this.version;
        }

        public String getVersionRange() {
            return this.versionRange;
        }

        public String toString() {
            StringJoiner result = new StringJoiner(", ", "CapabilityPattern(", ")");
            this.printMembers(result);
            return result.toString();
        }

        private void printMembers(StringJoiner result) {
            if (this.type != null) {
                result.add("type=" + String.valueOf((Object)this.type));
            }
            if (this.id != null) {
                result.add("id=\"" + this.id + "\"");
            }
            if (this.version != null) {
                result.add("version=\"" + this.version + "\"");
            }
            if (this.versionRange != null) {
                result.add("versionRange=\"" + this.versionRange + "\"");
            }
        }

        public String printMembers() {
            StringJoiner result = new StringJoiner(", ");
            this.printMembers(result);
            return result.toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.id, this.version, this.versionRange});
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof CapabilityPattern)) return false;
            CapabilityPattern other = (CapabilityPattern)obj;
            if (!Objects.equals((Object)this.type, (Object)other.type)) return false;
            if (!Objects.equals(this.id, other.id)) return false;
            if (!Objects.equals(this.version, other.version)) return false;
            if (!Objects.equals(this.versionRange, other.versionRange)) return false;
            return true;
        }
    }

    public static enum CapabilityType {
        OSGI_BUNDLE,
        JAVA_PACKAGE,
        P2_INSTALLABLE_UNIT;


        public static CapabilityType parsePomValue(String typeString) {
            if (typeString.equals("eclipse-plugin") || typeString.equals("osgi-bundle")) {
                return OSGI_BUNDLE;
            }
            if (typeString.equals("p2-installable-unit")) {
                return P2_INSTALLABLE_UNIT;
            }
            if (typeString.equals("java-package")) {
                return JAVA_PACKAGE;
            }
            throw new IllegalArgumentException("Non-recognized capability type: " + typeString);
        }
    }
}

