/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.surefire;

import aQute.bnd.build.ProjectTester;
import aQute.bnd.build.Workspace;
import aQute.bnd.build.model.conversions.RequirementListConverter;
import aQute.bnd.maven.lib.resolve.BndrunContainer;
import aQute.bnd.service.RepositoryPlugin;
import aQute.bnd.version.Version;
import aQute.lib.strings.Strings;
import biz.aQute.resolve.ResolveProcess;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.failsafe.util.FailsafeSummaryXmlUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.apache.maven.surefire.api.suite.RunResult;
import org.apache.maven.surefire.api.util.ScanResult;
import org.apache.maven.surefire.api.util.ScannerFilter;
import org.apache.maven.surefire.api.util.TestsToRun;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.DependencyResolutionException;
import org.eclipse.tycho.IllegalArtifactReferenceException;
import org.eclipse.tycho.MavenArtifactKey;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.ResolvedArtifactKey;
import org.eclipse.tycho.TargetPlatform;
import org.eclipse.tycho.core.osgitools.BundleReader;
import org.eclipse.tycho.core.osgitools.ClasspathReader;
import org.eclipse.tycho.core.osgitools.MavenBundleResolver;
import org.eclipse.tycho.core.osgitools.OsgiManifest;
import org.eclipse.tycho.core.osgitools.OsgiManifestParserException;
import org.eclipse.tycho.core.resolver.shared.PomDependencies;
import org.eclipse.tycho.core.utils.TychoProjectUtils;
import org.eclipse.tycho.model.classpath.JUnitBundle;
import org.eclipse.tycho.model.classpath.JUnitClasspathContainerEntry;
import org.eclipse.tycho.surefire.AbstractTestMojo;
import org.eclipse.tycho.surefire.bnd.ArtifactKeyRepository;
import org.eclipse.tycho.surefire.bnd.TargetPlatformRepository;
import org.eclipse.tycho.version.TychoVersion;
import org.osgi.service.resolver.ResolutionException;

@Mojo(name="bnd-test", defaultPhase=LifecyclePhase.INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class BndTestMojo
extends AbstractTestMojo {
    public static final String NAME = "bnd-test";
    private static final String ENGINE_VINTAGE_ENGINE = "junit-vintage-engine";
    private static final String ENGINE_JUPITER = "junit-jupiter-engine";
    private static final String ENGINES_DEFAULT = "junit-jupiter-engine,junit-vintage-engine";
    private static final String TESTER_DEFAULT = "biz.aQute.tester";
    private static final String TESTER_JUNIT_PLATFORM = "biz.aQute.tester.junit-platform";
    private static final String FW_FELIX = "org.apache.felix.framework";
    private static final String FW_EQUINOX = "org.eclipse.osgi";
    private static final int ERROR_PREPARE_CONTAINER = -1;
    private static final int ERROR_RESOLVE_CONTAINER = -2;
    private static final MavenArtifactKey FRAMEWORK_EQUINOX = MavenArtifactKey.bundle((String)"org.eclipse.osgi", (String)"[3,4)", (String)"org.eclipse.platform", (String)"org.eclipse.osgi");
    private static final MavenArtifactKey FRAMEWORK_FELIX = MavenArtifactKey.bundle((String)"org.apache.felix.framework", (String)"1", (String)"org.apache.felix", (String)"org.apache.felix.framework");
    private static final String BND_EMBEDDED_REPO_ARTIFACTS_GROUP = "biz.aQute.bnd";
    private static final Set<String> BND_EMBEDDED_REPO_ARTIFACTS = Set.of("biz.aQute.junit", "biz.aQute.launcher", "biz.aQute.remote.launcher", "biz.aQute.tester", "biz.aQute.tester.junit-platform");
    @Parameter(property="tycho.bnd-test.packaging", defaultValue="eclipse-plugin")
    private String packaging = "eclipse-plugin";
    @Parameter(property="tycho.bnd-test.trace", defaultValue="false")
    private boolean trace;
    @Parameter(property="tycho.bnd-test.testerTrace", defaultValue="false")
    private boolean testerTrace;
    @Parameter(property="tycho.bnd-test.printTests", defaultValue="true")
    private boolean printTests;
    @Parameter(property="tycho.bnd-test.eagerActivation", defaultValue="false")
    private boolean launchActivationEager;
    @Parameter(defaultValue="${project.build.directory}/failsafe-reports/failsafe-summary.xml", required=true)
    private File summaryFile;
    @Parameter
    private boolean summaryAppend;
    @Parameter
    private boolean enableSecurity;
    @Parameter
    private List<File> keyStores;
    @Parameter
    private File policyFile;
    @Parameter(defaultValue="${project.build.directory}/failsafe-reports", required=true)
    private File reportDirectory;
    @Parameter(property="project.build.testOutputDirectory")
    private File testClassesDirectory;
    @Parameter(defaultValue="biz.aQute.tester.junit-platform")
    private String tester = "biz.aQute.tester.junit-platform";
    @Parameter
    private Set<String> bundles;
    @Parameter(defaultValue="org.eclipse.osgi")
    private String runfw = "org.eclipse.osgi";
    @Parameter
    private Map<String, String> properties;
    @Parameter(defaultValue="junit-jupiter-engine,junit-vintage-engine", required=true)
    private String testEngines;
    @Component
    private BundleReader bundleReader;
    @Component
    private ProjectDependenciesResolver resolver;
    @Component
    private ArtifactFactory artifactFactory;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    private RepositorySystemSession repositorySession;
    @Component
    private RepositorySystem repositorySystem;
    @Component
    private MavenBundleResolver mavenBundleResolver;

    @Override
    protected void runTests(ScanResult scanResult) throws MojoExecutionException, MojoFailureException {
        ArrayList<ResolvedArtifactKey> implicitBundles = new ArrayList<ResolvedArtifactKey>();
        List<String> runrequire = this.addBundleUnderTest(scanResult, implicitBundles);
        this.addFramework(implicitBundles);
        this.addTestFramework(implicitBundles, runrequire);
        this.addBndEmbeddedRepo(implicitBundles);
        BndrunContainer container = new BndrunContainer.Builder(this.project, this.session, this.repositorySession, this.resolver, this.artifactFactory, this.repositorySystem).build();
        File runfile = new File(this.project.getBuild().getDirectory(), "test.bndrun");
        Properties properties = new Properties();
        String testProfileName = this.getTestProfileName();
        properties.setProperty("-runee", testProfileName);
        properties.setProperty("-tester", this.tester);
        properties.setProperty("-runrequires", runrequire.stream().collect(Collectors.joining(",")));
        properties.setProperty("-runtrace", String.valueOf(this.trace));
        properties.setProperty("-runfw", this.runfw);
        properties.setProperty("-runproperties", this.buildRunProperties());
        try {
            try (FileOutputStream out = new FileOutputStream(runfile);){
                properties.store(out, null);
            }
            String javaExecutable = this.getJavaExecutable();
            int returncode = container.execute(runfile, "testing", this.work, (file, bndrun, run) -> {
                if (new File(javaExecutable).isFile()) {
                    run.setProperty("java", javaExecutable);
                }
                Workspace workspace = run.getWorkspace();
                for (RepositoryPlugin rp : workspace.getRepositories()) {
                    workspace.removeBasicPlugin((Object)rp);
                }
                workspace.addBasicPlugin((Object)new TargetPlatformRepository(this.getReactorProject()));
                if (scanResult instanceof BundleScanResult) {
                    Iterator bundleScanResult = (BundleScanResult)scanResult;
                    workspace.addBasicPlugin((Object)new ArtifactKeyRepository(((BundleScanResult)((Object)bundleScanResult)).pomBundles, "pom-dependencies", this.project.getFile()));
                }
                workspace.addBasicPlugin((Object)new ArtifactKeyRepository(implicitBundles, "implicit-project-dependencies", this.project.getBasedir()));
                workspace.refresh();
                try {
                    this.getLog().info((CharSequence)"Resolving test-container");
                    if (this.printBundles) {
                        if (TESTER_JUNIT_PLATFORM.equals(this.tester)) {
                            for (String engine : Strings.split((String)this.testEngines)) {
                                this.getLog().info((CharSequence)String.format("-engine: %s", engine));
                            }
                        }
                        this.getLog().info((CharSequence)String.format("%s: %s", "-runee", testProfileName));
                        this.getLog().info((CharSequence)String.format("%s: %s", "-runfw", this.runfw));
                        this.getLog().info((CharSequence)String.format("%s: %s", "-tester", this.tester));
                        for (Object require : runrequire) {
                            this.getLog().info((CharSequence)String.format("%s: %s", "-runrequires", require));
                        }
                    }
                    String runBundles = run.resolve(false, false);
                    run.getWarnings().forEach(arg_0 -> ((Log)this.getLog()).warn(arg_0));
                    if (run.isOk()) {
                        if (this.printBundles) {
                            for (Object bundle : new RequirementListConverter().convert(runBundles)) {
                                this.getLog().info((CharSequence)String.format("%s: %s", "-runbundles", bundle));
                            }
                        }
                    } else {
                        run.getErrors().forEach(arg_0 -> ((Log)this.getLog()).error(arg_0));
                        return -2;
                    }
                    run.setProperty("-runbundles", runBundles);
                }
                catch (ResolutionException re) {
                    this.getLog().error((CharSequence)ResolveProcess.format((ResolutionException)re, (boolean)false));
                    return -2;
                }
                int numberOfTests = scanResult.size();
                ProjectTester tester = run.getProjectTester();
                tester.setReportDir(this.getReportsDirectory());
                if (this.test != null && !this.test.trim().isEmpty()) {
                    numberOfTests = 0;
                    for (String test : Strings.split((String)this.test)) {
                        tester.addTest(test);
                        ++numberOfTests;
                    }
                } else {
                    for (int i = 0; i < numberOfTests; ++i) {
                        tester.addTest(scanResult.getClassName(i));
                    }
                }
                tester.prepare();
                run.getWarnings().forEach(arg_0 -> ((Log)this.getLog()).warn(arg_0));
                if (!run.isOk()) {
                    run.getErrors().forEach(arg_0 -> ((Log)this.getLog()).error(arg_0));
                    return -1;
                }
                this.getLog().info((CharSequence)("Running " + numberOfTests + " test(s)"));
                int errors = tester.test();
                FailsafeSummaryXmlUtils.writeSummary((RunResult)new RunResult(numberOfTests, 0, errors, 0), (File)this.summaryFile, (boolean)this.summaryAppend);
                return 0;
            });
            if (returncode == -1) {
                throw new MojoExecutionException("prepare test container failed!");
            }
            if (returncode == -2) {
                throw new MojoExecutionException("resolve bundles failed!");
            }
        }
        catch (Exception e) {
            if (e instanceof MojoExecutionException) {
                MojoExecutionException mee = (MojoExecutionException)e;
                throw mee;
            }
            if (e instanceof MojoFailureException) {
                MojoFailureException mfe = (MojoFailureException)e;
                throw mfe;
            }
            throw new MojoExecutionException("executing test container failed!", e);
        }
    }

    private String buildRunProperties() {
        LinkedHashMap<String, Object> runProperties = new LinkedHashMap<String, Object>();
        runProperties.put("tester.trace", this.testerTrace);
        runProperties.put("tester.continuous", false);
        runProperties.put("launch.activation.eager", this.launchActivationEager);
        if (this.enableSecurity) {
            this.getLog().info((CharSequence)"Enable OSGi security for the framework");
            runProperties.put("org.osgi.framework.security", "osgi");
            if (this.keyStores != null) {
                runProperties.put("org.osgi.framework.trust.repositories", this.keyStores.stream().map(File::getAbsolutePath).collect(Collectors.joining(",")));
            }
            if (this.policyFile != null) {
                runProperties.put("java.security.policy", this.policyFile.getAbsolutePath());
            }
        }
        if (this.properties != null) {
            for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                runProperties.put(entry.getKey(), this.quotedValue(entry.getValue()));
            }
        }
        return runProperties.entrySet().stream().map(e -> (String)e.getKey() + "=" + e.getValue()).collect(Collectors.joining(","));
    }

    private String quotedValue(String value) {
        return "'" + value.replace('\t', ' ').replace('\n', ' ').replace('\r', ' ') + "'";
    }

    private void addTestFramework(List<ResolvedArtifactKey> bundles, List<String> runrequire) {
        runrequire.add("bnd.identity; id=" + this.tester);
        if (TESTER_JUNIT_PLATFORM.equals(this.tester)) {
            for (String engine : Strings.split((String)this.testEngines)) {
                runrequire.add("bnd.identity; id=" + engine);
            }
            for (JUnitBundle key : JUnitClasspathContainerEntry.JUNIT5_PLUGINS) {
                this.mavenBundleResolver.resolveMavenBundle(this.project, this.session, ClasspathReader.toMaven((JUnitBundle)key)).ifPresentOrElse(bundles::add, () -> this.getLog().warn((CharSequence)("Cannot get JUnit artifact " + key + ". Test run might not resolve")));
            }
            if (this.printTests || this.trace) {
                this.mavenBundleResolver.resolveMavenBundle(this.project, this.session, "org.eclipse.tycho", "org.eclipse.tycho.bnd.executionlistener", TychoVersion.getTychoVersion()).ifPresentOrElse(t -> {
                    bundles.add((ResolvedArtifactKey)t);
                    runrequire.add("bnd.identity; id=org.eclipse.tycho.bnd.executionlistener");
                }, () -> this.getLog().debug((CharSequence)"Cannot resolve execution listener, output will be missing"));
            }
        } else if (TESTER_DEFAULT.equals(this.tester)) {
            for (JUnitBundle key : JUnitClasspathContainerEntry.JUNIT4_PLUGINS) {
                this.mavenBundleResolver.resolveMavenBundle(this.project, this.session, ClasspathReader.toMaven((JUnitBundle)key)).ifPresentOrElse(bundles::add, () -> this.getLog().warn((CharSequence)("Cannot get JUnit artifact " + key + ". Test run might not resolve")));
            }
        }
    }

    private void addFramework(List<ResolvedArtifactKey> bundles) {
        this.getRunFramework().flatMap(key -> this.mavenBundleResolver.resolveMavenBundle(this.project, this.session, key)).ifPresentOrElse(bundles::add, () -> this.getLog().warn((CharSequence)("Cannot get artifact for runfw " + this.runfw + ". Test run might fail")));
    }

    private List<String> addBundleUnderTest(ScanResult scanResult, List<ResolvedArtifactKey> bundles) throws MojoExecutionException {
        ArrayList<String> roots = new ArrayList<String>();
        ArtifactKey artifactKey = this.osgiBundle.getArtifactKey(this.getReactorProject());
        roots.add("bnd.identity; id=" + artifactKey.getId() + ";version=" + artifactKey.getVersion());
        bundles.add(ResolvedArtifactKey.of((ArtifactKey)artifactKey, (File)this.project.getArtifact().getFile()));
        try {
            this.createTestPluginJar(this.getReactorProject(), "*", this.getPlainScanResult(scanResult)).ifPresent(testBundle -> {
                bundles.add((ResolvedArtifactKey)testBundle);
                roots.add("bnd.identity; id=" + testBundle.getId() + ";version=" + testBundle.getVersion());
            });
        }
        catch (Exception e) {
            throw new MojoExecutionException("Can't create test jar", e);
        }
        if (this.bundles != null) {
            for (String bundle : this.bundles) {
                roots.add("bnd.identity; id=" + bundle);
            }
        }
        return roots;
    }

    private ScanResult getPlainScanResult(ScanResult scanResult) {
        if (scanResult instanceof BundleScanResult) {
            return ((BundleScanResult)scanResult).plainTestResults;
        }
        return scanResult;
    }

    private void addBndEmbeddedRepo(List<ResolvedArtifactKey> bundles) {
        String bndVersion = TychoVersion.getBndVersion();
        for (String artifactId : BND_EMBEDDED_REPO_ARTIFACTS) {
            this.mavenBundleResolver.resolveMavenBundle(this.project, this.session, BND_EMBEDDED_REPO_ARTIFACTS_GROUP, artifactId, bndVersion).ifPresent(bundles::add);
        }
    }

    private Optional<MavenArtifactKey> getRunFramework() {
        if (FW_EQUINOX.equals(this.runfw)) {
            return Optional.of(FRAMEWORK_EQUINOX);
        }
        if (FW_FELIX.equals(this.runfw)) {
            return Optional.of(FRAMEWORK_FELIX);
        }
        return Optional.empty();
    }

    @Override
    protected boolean isCompatiblePackagingType(String packaging) {
        return this.packaging.equals(packaging);
    }

    @Override
    protected File getReportsDirectory() {
        return this.reportDirectory;
    }

    @Override
    protected File getTestClassesDirectory() {
        return this.testClassesDirectory;
    }

    @Override
    protected BundleScanResult scanForTests() {
        ScanResult moduletests = super.scanForTests();
        PomDependencies pomDependencies = this.projectManager.getTargetPlatformConfiguration(this.project).getPomDependencies();
        HashSet<String> bundleTestCases = new HashSet<String>();
        ArrayList<ResolvedArtifactKey> pomBundles = new ArrayList<ResolvedArtifactKey>();
        if (pomDependencies != PomDependencies.ignore) {
            for (Artifact artifact : this.project.getArtifacts()) {
                try {
                    File file = artifact.getFile();
                    OsgiManifest manifest = this.bundleReader.loadManifest(file);
                    String header = manifest.getValue("Test-Cases");
                    ResolvedArtifactKey key = ResolvedArtifactKey.of((ArtifactKey)manifest.toArtifactKey(), (File)file);
                    for (String test : this.getDeclaredTests(header, (ArtifactKey)key)) {
                        bundleTestCases.add(test);
                    }
                    pomBundles.add(key);
                }
                catch (OsgiManifestParserException file) {}
            }
        }
        TargetPlatform targetPlatform = TychoProjectUtils.getTargetPlatform((ReactorProject)this.getReactorProject());
        if (this.bundles != null) {
            for (String bundle : this.bundles) {
                try {
                    ArtifactKey key = targetPlatform.resolveArtifact("eclipse-plugin", bundle, Version.emptyVersion.toString());
                    File file = targetPlatform.getArtifactLocation(key);
                    if (file == null) continue;
                    OsgiManifest manifest = this.bundleReader.loadManifest(file);
                    String header = manifest.getValue("Test-Cases");
                    for (String test : this.getDeclaredTests(header, key)) {
                        bundleTestCases.add(test);
                    }
                }
                catch (DependencyResolutionException | IllegalArtifactReferenceException | OsgiManifestParserException e) {
                    this.getLog().debug((CharSequence)("Bundle " + bundle + " was not found in target platform: " + (Exception)e));
                }
            }
        }
        return new BundleScanResult(moduletests, pomBundles, List.copyOf(bundleTestCases), this.project.getFile());
    }

    private List<String> getDeclaredTests(String header, ArtifactKey key) {
        if (header != null && !header.isBlank() && this.bundles != null && this.bundles.contains(key.getId())) {
            return Strings.split((String)header);
        }
        return List.of();
    }

    private static final class BundleScanResult
    implements ScanResult {
        private ScanResult plainTestResults;
        private List<String> bundleTestCases;
        private List<ResolvedArtifactKey> pomBundles;

        public BundleScanResult(ScanResult plainTestResults, List<ResolvedArtifactKey> pomBundles, List<String> bundleTestCases, File location) {
            this.plainTestResults = plainTestResults;
            this.pomBundles = pomBundles;
            this.bundleTestCases = bundleTestCases;
        }

        public int size() {
            return this.bundleTestCases.size() + this.plainTestResults.size();
        }

        public String getClassName(int index) {
            int size = this.plainTestResults.size();
            if (index < size) {
                return this.plainTestResults.getClassName(index);
            }
            try {
                return this.bundleTestCases.get(index - size);
            }
            catch (IndexOutOfBoundsException e) {
                throw new IndexOutOfBoundsException(index);
            }
        }

        public TestsToRun applyFilter(ScannerFilter scannerFilter, ClassLoader testClassLoader) {
            throw new UnsupportedOperationException();
        }

        public List<Class<?>> getClassesSkippedByValidation(ScannerFilter scannerFilter, ClassLoader testClassLoader) {
            throw new UnsupportedOperationException();
        }

        public void writeTo(Map<String, String> properties) {
            throw new UnsupportedOperationException();
        }
    }
}

