/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.surefire.provisioning;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.p2.publisher.eclipse.FeaturesAndBundlesPublisherApplication;

public class BundlesPublisher {
    private List<File> bundles = new ArrayList<File>();
    private File workingDir;
    private Logger log;

    public BundlesPublisher(Logger log) {
        this.log = log;
    }

    public void addBundle(File bundle) {
        this.bundles.add(bundle);
    }

    public URI publishBundles(File targetDirectory) throws Exception {
        if (this.bundles.isEmpty()) {
            throw new MojoExecutionException("No bundles to be published");
        }
        File pluginsDir = new File(targetDirectory, "plugins");
        pluginsDir.mkdirs();
        for (File bundle : this.bundles) {
            FileUtils.copyFileToDirectory((File)bundle, (File)pluginsDir);
        }
        this.log.info("Publishing " + this.bundles.size() + " bundles to " + targetDirectory);
        FeaturesAndBundlesPublisherApplication application = new FeaturesAndBundlesPublisherApplication();
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("-artifactRepository");
        arguments.add(targetDirectory.toURI().toString());
        arguments.add("-metadataRepository");
        arguments.add(targetDirectory.toURI().toString());
        arguments.add("-compress");
        arguments.add("-publishArtifacts");
        arguments.add("-source");
        arguments.add(targetDirectory.toString());
        Object result = application.run((String[])arguments.toArray(String[]::new));
        if (result != IApplication.EXIT_OK) {
            throw new MojoFailureException("P2 publisher return code was " + result);
        }
        return targetDirectory.toURI();
    }
}

