/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.surefire.provider.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.model.Dependency;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.tycho.classpath.ClasspathEntry;
import org.eclipse.tycho.surefire.provider.impl.AbstractJUnitProvider;
import org.eclipse.tycho.surefire.provider.impl.ProviderHelper;
import org.eclipse.tycho.surefire.provider.spi.TestFrameworkProvider;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

@Component(role=TestFrameworkProvider.class, hint="junit47")
public class JUnit47Provider
extends AbstractJUnitProvider {
    private static final Version VERSION = Version.parseVersion((String)"4.7.0");

    @Override
    public boolean isEnabled(List<ClasspathEntry> testBundleClassPath, Properties surefireProperties) {
        if (!this.isParallelEnabled(surefireProperties)) {
            return false;
        }
        return super.isEnabled(testBundleClassPath, surefireProperties);
    }

    private boolean isParallelEnabled(Properties providerProperties) {
        return providerProperties.getProperty("parallel") != null;
    }

    @Override
    public String getSurefireProviderClassName() {
        return "org.apache.maven.surefire.junitcore.JUnitCoreProvider";
    }

    @Override
    public Version getVersion() {
        return VERSION;
    }

    @Override
    public List<Dependency> getRequiredBundles() {
        return Collections.singletonList(ProviderHelper.newDependency("org.eclipse.tycho", "org.eclipse.tycho.surefire.junit47"));
    }

    @Override
    protected Set<String> getJUnitBundleNames() {
        return new HashSet<String>(Arrays.asList("org.junit", "org.junit4"));
    }

    @Override
    protected VersionRange getJUnitVersionRange() {
        return new VersionRange("[4.7,5)");
    }
}

