/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.helper;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptorBuilder;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.TypeAwareExpressionEvaluator;
import org.codehaus.plexus.util.InterpolationFilterReader;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.tycho.helper.MojoExecutionHelper;
import org.eclipse.tycho.helper.ProjectHelper;

@Component(role=PluginConfigurationHelper.class)
public class PluginConfigurationHelper {
    @Requirement
    ProjectHelper projectHelper;
    @Requirement
    LegacySupport legacySupport;
    private Map<URL, PluginDescriptor> descriptorCache = new ConcurrentHashMap<URL, PluginDescriptor>();

    public Configuration getConfiguration() {
        MojoExecution execution = MojoExecutionHelper.getExecution().orElse(null);
        TypeAwareExpressionEvaluator evaluator = this.getEvaluator(this.legacySupport.getSession(), execution);
        if (execution == null) {
            return new Configuration(null, evaluator);
        }
        Xpp3Dom configuration = execution.getConfiguration();
        return new Configuration(configuration, evaluator);
    }

    private TypeAwareExpressionEvaluator getEvaluator(MavenSession mavenSession, MojoExecution execution) {
        if (mavenSession == null) {
            return null;
        }
        return new PluginParameterExpressionEvaluator(mavenSession, execution);
    }

    public Configuration getConfiguration(Xpp3Dom configuration) {
        return new Configuration(configuration, this.getEvaluator(this.legacySupport.getSession(), null));
    }

    public Configuration getConfiguration(String pluginGroupId, String pluginArtifactId, String goal, MavenProject project, MavenSession mavenSession) {
        return new Configuration(this.projectHelper.getPluginConfiguration(pluginGroupId, pluginArtifactId, goal, project, mavenSession), this.getEvaluator(mavenSession, null));
    }

    public <M extends Mojo> Configuration getConfiguration(Class<M> mojo) {
        MavenSession currentSession = this.legacySupport.getSession();
        if (currentSession == null) {
            return this.getConfiguration((Xpp3Dom)null);
        }
        MavenProject currentProject = currentSession.getCurrentProject();
        if (currentProject == null) {
            return this.getConfiguration((Xpp3Dom)null);
        }
        return this.getConfiguration(mojo, currentProject, currentSession);
    }

    public <M extends Mojo> Configuration getConfiguration(Class<M> mojo, MavenProject project, MavenSession mavenSession) {
        URL resource = mojo.getResource("/META-INF/maven/plugin.xml");
        if (resource == null) {
            throw new IllegalStateException("can't find plugin descriptor of mojo " + mojo.getName());
        }
        PluginDescriptor pluginDescriptor = this.descriptorCache.computeIfAbsent(resource, url -> {
            PluginDescriptor pluginDescriptor;
            BufferedReader reader = new BufferedReader(new InputStreamReader(resource.openStream()));
            try {
                InterpolationFilterReader interpolationFilterReader = new InterpolationFilterReader((Reader)reader, Map.of());
                pluginDescriptor = new PluginDescriptorBuilder().build((Reader)interpolationFilterReader);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    return null;
                }
            }
            reader.close();
            return pluginDescriptor;
        });
        if (pluginDescriptor == null) {
            throw new IllegalStateException("can't load plugin descriptor of mojo " + mojo.getName());
        }
        for (MojoDescriptor mojoDescriptor : pluginDescriptor.getMojos()) {
            if (!mojo.getName().equals(mojoDescriptor.getImplementation())) continue;
            Xpp3Dom configuration = this.projectHelper.getPluginConfiguration(pluginDescriptor.getGroupId(), pluginDescriptor.getArtifactId(), mojoDescriptor.getGoal(), project, mavenSession);
            return this.getConfiguration(configuration);
        }
        throw new IllegalArgumentException("can't find mojo " + mojo.getName() + " goal in descriptor, possible goals are " + pluginDescriptor.getMojos().stream().map(MojoDescriptor::getGoal).collect(Collectors.joining(",")));
    }

    public static final class Configuration {
        private Xpp3Dom configuration;
        private TypeAwareExpressionEvaluator evaluator;

        Configuration(Xpp3Dom configuration, TypeAwareExpressionEvaluator evaluator) {
            this.configuration = configuration;
            this.evaluator = evaluator;
        }

        public Optional<Configuration> getChild(String name) {
            if (this.configuration == null) {
                return Optional.empty();
            }
            Xpp3Dom child = this.configuration.getChild(name);
            if (child == null) {
                return Optional.empty();
            }
            return Optional.of(new Configuration(child, this.evaluator));
        }

        public Optional<String> getString(String name) {
            return this.getChild(name).map(child -> this.getValue(child.configuration));
        }

        public Optional<Boolean> getBoolean(String name) {
            return this.getString(name).map(Boolean::valueOf);
        }

        public <E extends Enum<E>> Optional<E> getEnum(String name, Class<E> type) {
            return this.getString(name).map(value -> {
                for (Enum e : (Enum[])type.getEnumConstants()) {
                    if (!e.name().equals(value)) continue;
                    return e;
                }
                return null;
            });
        }

        public String toString() {
            return this.configuration == null ? "-empty configuration-" : String.valueOf(this.configuration);
        }

        public Optional<List<String>> getStringList(String name) {
            return this.getChild(name).map(child -> Arrays.stream(child.configuration.getChildren()).map(this::getValue).toList());
        }

        private String getValue(Xpp3Dom dom) {
            String value = dom.getValue();
            if (value == null) {
                value = dom.getAttribute("default-value");
            }
            if (value != null && this.evaluator != null) {
                try {
                    return (String)this.evaluator.evaluate(value, String.class);
                }
                catch (ExpressionEvaluationException expressionEvaluationException) {
                    // empty catch block
                }
            }
            return value;
        }
    }
}

