/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.helper;

import java.util.Optional;
import org.apache.maven.plugin.MojoExecution;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.tycho.helper.MojoExecutionHelper;

@Component(role=PluginConfigurationHelper.class)
public class PluginConfigurationHelper {
    public Optional<Xpp3Dom> getDomOption(String name) {
        Optional<MojoExecution> execution = MojoExecutionHelper.getExecution();
        Optional<Xpp3Dom> configuration = execution.map(ex -> ex.getConfiguration());
        Optional<Xpp3Dom> child = configuration.map(cfg -> cfg.getChild(name));
        return child;
    }

    public Optional<String> getStringOption(String name) {
        return this.getDomOption(name).map(child -> {
            String value = child.getValue();
            if (value == null) {
                String attribute = child.getAttribute("default-value");
                return attribute;
            }
            return value;
        });
    }

    public Optional<Boolean> getBooleanOption(String name) {
        return this.getStringOption(name).map(s -> Boolean.valueOf(s));
    }
}

