/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.buildversion;

import java.util.Date;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.eclipse.tycho.ArtifactDescriptor;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.TargetPlatformService;
import org.eclipse.tycho.buildversion.BuildQualifierMojo;
import org.eclipse.tycho.buildversion.TimestampFinder;
import org.eclipse.tycho.core.ArtifactDependencyVisitor;
import org.eclipse.tycho.core.FeatureDescription;
import org.eclipse.tycho.core.PluginDescription;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;

@Mojo(name="build-qualifier-aggregator", defaultPhase=LifecyclePhase.VALIDATE, threadSafe=true)
public class BuildQualifierAggregatorMojo
extends BuildQualifierMojo {
    @Component
    private TimestampFinder timestampFinder;
    @Component
    private TargetPlatformService platformService;

    @Override
    protected Date getBuildTimestamp() throws MojoExecutionException {
        Date timestamp = super.getBuildTimestamp();
        if (this.timestampProvider == null) {
            return timestamp;
        }
        final Date[] latestTimestamp = new Date[]{timestamp};
        TychoProject projectType = (TychoProject)this.projectTypes.get(this.project.getPackaging());
        if (projectType == null) {
            throw new IllegalStateException("Unknown or unsupported packaging type " + this.packaging);
        }
        final ReactorProject thisProject = DefaultReactorProject.adapt((MavenProject)this.project);
        this.platformService.getTargetPlatform(thisProject);
        projectType.getDependencyWalker(thisProject).walk(new ArtifactDependencyVisitor(){

            public boolean visitFeature(FeatureDescription feature) {
                if (feature.getFeatureRef() == null || thisProject.equals((Object)feature.getMavenProject())) {
                    return true;
                }
                this.visitArtifact((ArtifactDescriptor)feature);
                return false;
            }

            public void visitPlugin(PluginDescription plugin) {
                if (plugin.getPluginRef() == null || thisProject.equals((Object)plugin.getMavenProject())) {
                    return;
                }
                this.visitArtifact((ArtifactDescriptor)plugin);
            }

            private void visitArtifact(ArtifactDescriptor artifact) {
                Date timestamp = BuildQualifierAggregatorMojo.this.timestampFinder.findByDescriptor(artifact, BuildQualifierAggregatorMojo.this.format);
                if (timestamp != null && latestTimestamp[0].compareTo(timestamp) < 0) {
                    latestTimestamp[0] = timestamp;
                }
            }
        });
        return latestTimestamp[0];
    }
}

