/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.packaging;

import de.pdark.decentxml.Element;
import de.pdark.decentxml.Node;
import java.util.List;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.IllegalArtifactReferenceException;
import org.eclipse.tycho.TargetPlatform;
import org.eclipse.tycho.model.IU;

@Component(role=IUXmlTransformer.class)
public class IUXmlTransformer {
    private static final String MAVEN_ARTIFACT_ID = "maven-artifactId";
    private static final String MAVEN_VERSION = "maven-version";
    private static final String MAVEN_GROUP_ID = "maven-groupId";
    @Requirement
    private Logger log;

    public IUXmlTransformer() {
    }

    public IUXmlTransformer(Logger log) {
        this.log = log;
    }

    public void replaceSelfQualifiers(IU iu, String version, String qualifier) {
        iu.setVersion(version);
        this.replaceSelfVersionInArtifact(iu, version);
        this.replaceQualifierInCapabilities(iu.getSelfCapabilities(), qualifier);
    }

    private void replaceSelfVersionInArtifact(IU iu, String version) {
        Element artifact = iu.getSelfArtifact();
        if (artifact == null) {
            return;
        }
        String currentVersion = artifact.getAttributeValue("version");
        if (this.hasQualifier(currentVersion) && iu.getId().equals(artifact.getAttributeValue("id"))) {
            artifact.setAttribute("version", version);
        }
    }

    public void replaceQualifierInCapabilities(List<Element> providedCapabilities, String qualifier) {
        if (providedCapabilities == null) {
            return;
        }
        for (Element capability : providedCapabilities) {
            String currentVersion = capability.getAttributeValue("version");
            if (!this.hasQualifier(currentVersion)) continue;
            capability.setAttribute("version", currentVersion.replaceAll("qualifier", qualifier));
        }
    }

    private boolean hasQualifier(String v) {
        if (v == null) {
            return false;
        }
        return v.endsWith(".qualifier");
    }

    public void replaceQualifierInRequirements(IU iu, TargetPlatform targetPlatform) throws MojoFailureException {
        List requirements = iu.getRequiredCapabilites();
        if (requirements == null) {
            return;
        }
        for (Element req : requirements) {
            String range = req.getAttributeValue("range");
            if (range == null || !range.endsWith(".qualifier") || !"org.eclipse.equinox.p2.iu".equals(req.getAttributeValue("namespace"))) continue;
            ArtifactKey artifact = this.resolveRequirementReference(targetPlatform, req.getAttributeValue("name"), range, req.toString());
            req.setAttribute("range", artifact.getVersion());
        }
    }

    public void replaceZerosInRequirements(IU iu, TargetPlatform targetPlatform) throws MojoFailureException {
        List requirements = iu.getRequiredCapabilites();
        if (requirements == null) {
            return;
        }
        for (Element req : requirements) {
            String range = req.getAttributeValue("range");
            if (!"0.0.0".equals(range) || !"org.eclipse.equinox.p2.iu".equals(req.getAttributeValue("namespace"))) continue;
            ArtifactKey artifact = this.resolveRequirementReference(targetPlatform, req.getAttributeValue("name"), range, req.toString());
            req.setAttribute("range", artifact.getVersion());
        }
    }

    private ArtifactKey resolveRequirementReference(TargetPlatform targetPlatform, String name, String version, String xml) throws MojoFailureException {
        try {
            return targetPlatform.resolveArtifact("p2-installable-unit", name, version);
        }
        catch (IllegalArtifactReferenceException e) {
            throw new MojoFailureException("Can't resolve reference " + xml);
        }
    }

    public void injectMavenProperties(IU iu, MavenProject project) {
        List properties = iu.getProperties();
        if (properties != null) {
            for (Element property : properties) {
                String key = property.getAttributeValue("name");
                if (!MAVEN_GROUP_ID.equals(key) && !MAVEN_ARTIFACT_ID.equals(key) && !MAVEN_VERSION.equals(key)) continue;
                property.getParent().removeNode((Node)property);
            }
        }
        iu.addProperty(MAVEN_GROUP_ID, project.getGroupId());
        iu.addProperty(MAVEN_ARTIFACT_ID, project.getArtifactId());
        iu.addProperty(MAVEN_VERSION, project.getVersion());
    }

    public void addSelfCapability(IU iu) {
        if (iu.getSelfCapabilities().size() == 0) {
            return;
        }
        iu.addSelfCapability();
    }
}

