/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.repository;

import aQute.bnd.osgi.repository.XMLResourceGenerator;
import aQute.bnd.repository.fileset.FileSetRepository;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.TychoConstants;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.osgitools.EclipseRepositoryProject;
import org.eclipse.tycho.core.utils.TychoProjectUtils;
import org.eclipse.tycho.model.Category;
import org.eclipse.tycho.model.Feature;
import org.eclipse.tycho.p2.tools.DestinationRepositoryDescriptor;
import org.eclipse.tycho.p2.tools.FacadeException;
import org.eclipse.tycho.p2.tools.RepositoryReference;
import org.eclipse.tycho.p2.tools.RepositoryReferences;
import org.eclipse.tycho.p2.tools.mirroring.facade.MirrorApplicationService;
import org.eclipse.tycho.p2tools.RepositoryReferenceTool;
import org.eclipse.tycho.plugins.p2.repository.AbstractRepositoryMojo;
import org.eclipse.tycho.targetplatform.TargetDefinition;
import org.eclipse.tycho.targetplatform.TargetDefinitionFile;
import org.osgi.service.repository.Repository;

@Mojo(name="assemble-repository", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public class AssembleRepositoryMojo
extends AbstractRepositoryMojo {
    private static final Object LOCK = new Object();
    @Parameter(defaultValue="true")
    private boolean createArtifactRepository;
    @Parameter(defaultValue="false")
    private boolean includeAllDependencies;
    @Parameter(defaultValue="false")
    private boolean includeAllSources;
    @Parameter(defaultValue="false")
    private boolean filterProvided;
    @Parameter(defaultValue="false")
    private boolean includeRequiredPlugins;
    @Parameter(defaultValue="false")
    private boolean includeRequiredFeatures;
    @Parameter(defaultValue="true")
    private boolean compress;
    @Parameter(defaultValue="true")
    private boolean xzCompress;
    @Parameter(defaultValue="true")
    private boolean keepNonXzIndexFiles;
    @Parameter(defaultValue="${project.name}")
    private String repositoryName;
    @Parameter(defaultValue="${project.basedir}")
    private File categoriesDirectory;
    @Parameter
    private Map<String, String> profileProperties;
    @Parameter
    private Map<String, String> extraArtifactRepositoryProperties;
    @Parameter
    private boolean addPomRepositoryReferences;
    @Parameter
    private boolean addIUTargetRepositoryReferences;
    @Parameter
    private boolean generateOSGiRepository;
    @Parameter(defaultValue="repository.xml")
    private String repositoryFileName;
    @Component
    private RepositoryReferenceTool repositoryReferenceTool;
    @Component
    MirrorApplicationService mirrorApp;
    @Component(role=TychoProject.class, hint="eclipse-repository")
    private EclipseRepositoryProject eclipseRepositoryProject;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        Object object = LOCK;
        synchronized (object) {
            block23: {
                try {
                    File featureResult;
                    File destination = this.getAssemblyRepositoryLocation();
                    destination.mkdirs();
                    this.copyResources(destination);
                    ReactorProject reactorProject = this.getReactorProject();
                    List projectSeeds = TychoProjectUtils.getDependencySeeds((ReactorProject)reactorProject);
                    if (projectSeeds.isEmpty()) {
                        this.getLog().warn((CharSequence)"No content specified for p2 repository");
                        return;
                    }
                    reactorProject.setContextValue(TychoConstants.CTX_METADATA_ARTIFACT_LOCATION, (Object)this.categoriesDirectory);
                    RepositoryReferences sources = this.repositoryReferenceTool.getVisibleRepositories(this.getProject(), this.getSession(), 1);
                    sources.setTargetPlatform(TychoProjectUtils.getTargetPlatform((ReactorProject)this.getReactorProject()));
                    List repositoryReferences = this.getCategories(this.categoriesDirectory).stream().map(Category::getRepositoryReferences).flatMap(Collection::stream).map(ref -> new RepositoryReference(ref.getName(), ref.getLocation(), ref.isEnabled())).collect(Collectors.toCollection(ArrayList::new));
                    if (this.addPomRepositoryReferences) {
                        for (org.apache.maven.model.Repository pomRepo : this.getProject().getRepositories()) {
                            if (!"p2".equals(pomRepo.getLayout())) continue;
                            repositoryReferences.add(new RepositoryReference(pomRepo.getName(), pomRepo.getUrl(), true));
                        }
                    }
                    if (this.addIUTargetRepositoryReferences) {
                        for (TargetDefinitionFile targetDefinitionFile : this.projectManager.getTargetPlatformConfiguration(this.getProject()).getTargets()) {
                            for (TargetDefinition.Location location : targetDefinitionFile.getLocations()) {
                                if (!(location instanceof TargetDefinition.InstallableUnitLocation)) continue;
                                TargetDefinition.InstallableUnitLocation iu = (TargetDefinition.InstallableUnitLocation)location;
                                for (TargetDefinition.Repository iuRepo : iu.getRepositories()) {
                                    repositoryReferences.add(new RepositoryReference(null, iuRepo.getLocation(), true));
                                }
                            }
                        }
                    }
                    DestinationRepositoryDescriptor destinationRepoDescriptor = new DestinationRepositoryDescriptor(destination, this.repositoryName, this.compress, this.xzCompress, this.keepNonXzIndexFiles, !this.createArtifactRepository, true, this.extraArtifactRepositoryProperties, repositoryReferences);
                    this.mirrorApp.mirrorReactor(sources, destinationRepoDescriptor, (Collection)projectSeeds, this.getBuildContext(), this.includeAllDependencies, this.includeAllSources, this.includeRequiredPlugins, this.includeRequiredFeatures, this.filterProvided, this.profileProperties);
                    if (!this.generateOSGiRepository) break block23;
                    XMLResourceGenerator resourceGenerator = new XMLResourceGenerator();
                    resourceGenerator.name(this.repositoryName);
                    resourceGenerator.base(destination.toURI());
                    File pluginsResult = new File(destination, "plugins");
                    if (pluginsResult.isDirectory()) {
                        File[] files = pluginsResult.listFiles(pathname -> pathname.isFile() && pathname.getName().endsWith(".jar"));
                        try {
                            resourceGenerator.repository((Repository)new FileSetRepository("plugins", Arrays.asList(files)));
                        }
                        catch (Exception e) {
                            throw new MojoExecutionException("Could not read p2 repository plugins", e);
                        }
                    }
                    if ((featureResult = new File(destination, "features")).isDirectory()) {
                        File[] files;
                        for (File featureFile : files = featureResult.listFiles(pathname -> pathname.isFile() && pathname.getName().endsWith(".jar"))) {
                            try {
                                Feature feature = Feature.readJar((File)featureFile);
                                feature.toResource().forEach(arg_0 -> ((XMLResourceGenerator)resourceGenerator).resource(arg_0));
                            }
                            catch (IOException e) {
                                throw new MojoExecutionException("Could not read feature " + featureFile, (Exception)e);
                            }
                        }
                    }
                    try {
                        if (this.compress) {
                            resourceGenerator.save(new File(destination, this.repositoryFileName + ".gz"));
                        } else {
                            resourceGenerator.save(new File(destination, this.repositoryFileName));
                        }
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("Could not write OSGi Repository!", (Exception)e);
                    }
                }
                catch (FacadeException e) {
                    throw new MojoExecutionException("Could not assemble p2 repository", (Exception)((Object)e));
                }
            }
        }
    }

    private void copyResources(File destination) throws MojoExecutionException {
        File outputDir = new File(this.getProject().getBuild().getOutputDirectory());
        try {
            if (outputDir.isDirectory()) {
                this.getLog().info((CharSequence)String.format("Copying resources from %s to %s", outputDir, destination));
                FileUtils.copyDirectoryStructure((File)outputDir, (File)destination);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying resources", (Exception)e);
        }
    }

    private List<Category> getCategories(File categoriesDirectory) {
        return this.eclipseRepositoryProject.loadCategories(categoriesDirectory);
    }
}

