/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.repository;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.repository.RepositorySystem;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.bc.BcPGPObjectFactory;
import org.bouncycastle.openpgp.bc.BcPGPPublicKeyRingCollection;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.sisu.equinox.EquinoxServiceFactory;
import org.eclipse.tycho.p2maven.tools.TychoFeaturesAndBundlesPublisherApplication;

@Mojo(name="assemble-maven-repository", requiresDependencyResolution=ResolutionScope.COMPILE)
public class MavenP2SiteMojo
extends AbstractMojo {
    private static final boolean INCLUDE_PGP_DEFAULT = false;
    private static final String CACHE_RELPATH = ".cache/tycho/pgpkeys";
    private static final String SIGNATURE_EXTENSION = ".asc";
    public static final String MAVEN_CENTRAL_KEY_SERVER = "http://pgp.mit.edu/pks/lookup?op=get&search={0}";
    public static final String UBUNTU_KEY_SERVER = "https://keyserver.ubuntu.com/pks/lookup?op=get&search={0}";
    private static final List<String> DEFAULT_KEY_SERVER = List.of("https://keyserver.ubuntu.com/pks/lookup?op=get&search={0}", "http://pgp.mit.edu/pks/lookup?op=get&search={0}");
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(defaultValue="true")
    private boolean includeDependencies = true;
    @Parameter(defaultValue="false")
    private boolean includeManaged = false;
    @Parameter(defaultValue="false")
    private boolean includeReactor = false;
    @Parameter(defaultValue="false")
    private boolean includeTransitiveDependencies;
    @Parameter(defaultValue="300")
    private int timeoutInSeconds = 300;
    @Parameter(defaultValue="${project.basedir}/category.xml")
    private File categoryFile;
    @Parameter(defaultValue="Bundles")
    private String categoryName;
    @Parameter(defaultValue="${project.build.directory}/repository")
    private File destination;
    @Component(hint="tycho-core")
    private EquinoxServiceFactory equinox;
    @Component
    private Logger logger;
    @Component
    private RepositorySystem repositorySystem;
    @Component
    private MavenProjectHelper projectHelper;
    @Component
    private IProvisioningAgent agent;
    @Parameter(property="project.build.directory", required=true)
    protected File buildDirectory;
    @Parameter
    private List<String> keyServerUrls;
    @Parameter(defaultValue="10")
    private int keyServerRetry = 10;
    @Parameter(defaultValue="false")
    private boolean includePGPSignature = false;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Object result;
        String categoryURI;
        this.agent.getService(IArtifactRepositoryManager.class);
        this.logger.debug("categoryName =        " + this.categoryName);
        this.logger.debug("includeDependencies = " + this.includeDependencies);
        this.logger.debug("includeManaged =      " + this.includeManaged);
        this.logger.debug("includeReactor =      " + this.includeReactor);
        this.logger.debug("includeTransitive =   " + this.includeTransitiveDependencies);
        List<String> keyServers = this.getKeyServers();
        if (this.includePGPSignature) {
            this.logger.debug("keyServerUrl =        " + keyServers.stream().collect(Collectors.joining(", ")));
            this.logger.debug("keyServerRetry =      " + this.keyServerRetry);
        }
        HashSet<String> filesAdded = new HashSet<String>();
        List dependencies = this.project.getDependencies();
        ArrayList<File> bundles = new ArrayList<File>();
        ArrayList<File> advices = new ArrayList<File>();
        ArrayList<File> signatures = new ArrayList<File>();
        if (this.includeDependencies) {
            this.resolve(dependencies, bundles, advices, signatures, filesAdded);
        }
        if (this.includeManaged) {
            this.resolve(this.project.getDependencyManagement().getDependencies(), bundles, advices, signatures, filesAdded);
        }
        if (this.includeReactor) {
            List allProjects = this.session.getAllProjects();
            for (MavenProject mavenProject : allProjects) {
                if (this.skipProject(mavenProject)) continue;
                Artifact artifact = mavenProject.getArtifact();
                File file = artifact.getFile();
                String attachedSignature = artifact.getArtifactHandler().getExtension() + SIGNATURE_EXTENSION;
                File attachedSignatureFile = null;
                if (this.includePGPSignature) {
                    for (Artifact attached : mavenProject.getAttachedArtifacts()) {
                        if (!attached.getType().equals(attachedSignature) || !Objects.equals(attached.getArtifactId(), artifact.getArtifactId()) || !Objects.equals(attached.getGroupId(), artifact.getGroupId()) || attached.getClassifier() != null && !attached.getClassifier().isEmpty()) continue;
                        attachedSignatureFile = attached.getFile();
                    }
                }
                bundles.add(file);
                advices.add(this.createMavenAdvice(artifact));
                signatures.add(attachedSignatureFile);
            }
        }
        if (this.categoryFile.exists()) {
            categoryURI = this.categoryFile.toURI().toASCIIString();
        } else {
            try {
                File categoryGenFile = File.createTempFile("category", ".xml");
                try (PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(categoryGenFile), StandardCharsets.UTF_8));){
                    writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    writer.println("<site>");
                    writer.println("<category-def name=\"bundles\" label=\"" + this.categoryName + "\"/>");
                    writer.println("<iu>");
                    writer.println("<category name=\"bundles\"/>");
                    writer.println(" <query><expression type=\"match\">providedCapabilities.exists(p | p.namespace == 'osgi.bundle')</expression></query>");
                    writer.println("</iu>");
                    writer.println("</site>");
                }
                categoryGenFile.deleteOnExit();
                categoryURI = categoryGenFile.toURI().toASCIIString();
            }
            catch (IOException e) {
                throw new MojoExecutionException("failed to generate category.xml", (Exception)e);
            }
        }
        File bundlesFile = this.writeFileList(bundles, "bundles");
        File advicesFile = this.writeFileList(advices, "advices");
        File signaturesFile = this.writeFileList(signatures, "signatures");
        HashMap<Long, PGPPublicKeyRing> publicKeys = new HashMap<Long, PGPPublicKeyRing>();
        if (this.includePGPSignature) {
            for (File file : signatures) {
                if (file == null) continue;
                try (InputStream in = PGPUtil.getDecoderStream((InputStream)new FileInputStream(file));){
                    BcPGPObjectFactory pgpFact = new BcPGPObjectFactory(in);
                    Object o = pgpFact.nextObject();
                    if (!(o instanceof PGPSignatureList)) continue;
                    PGPSignatureList list = (PGPSignatureList)o;
                    for (int i = 0; i < list.size(); ++i) {
                        PGPSignature signature = list.get(i);
                        long keyID = signature.getKeyID();
                        if (publicKeys.containsKey(keyID)) continue;
                        ArrayList<Throwable> errors = new ArrayList<Throwable>();
                        for (String keyServer : keyServers) {
                            try {
                                this.loadPublicKey(keyID, publicKeys, keyServer);
                                break;
                            }
                            catch (IOException | PGPException throwable) {
                                errors.add(throwable);
                            }
                        }
                        if (errors.isEmpty()) continue;
                        MojoFailureException exception = new MojoFailureException("Loading key from any server failed");
                        for (Exception exception2 : errors) {
                            exception.addSuppressed((Throwable)exception2);
                        }
                        throw exception;
                    }
                }
                catch (IOException e) {
                    this.logger.warn("processing signature file " + file.getAbsolutePath() + " failed!", (Throwable)e);
                }
            }
        }
        File publicKeysFile = null;
        Stream.Builder<String> arguments = Stream.builder();
        if (publicKeys.size() > 0) {
            try {
                publicKeysFile = File.createTempFile("publicKeys", ".pgp");
                publicKeysFile.deleteOnExit();
                PGPPublicKeyRingCollection collection = new PGPPublicKeyRingCollection(publicKeys.values());
                try (ArmoredOutputStream out = new ArmoredOutputStream((OutputStream)new FileOutputStream(publicKeysFile));){
                    collection.encode((OutputStream)out);
                }
                arguments.add("-publicKeys");
                arguments.add(publicKeysFile.getAbsolutePath());
            }
            catch (IOException | PGPException e) {
                throw new MojoExecutionException("failed to generate public-key section", (Exception)e);
            }
        }
        this.destination.mkdirs();
        arguments.add("-artifactRepository");
        arguments.add(this.destination.toURI().toString());
        arguments.add("-metadataRepository");
        arguments.add(this.destination.toURI().toString());
        arguments.add("-apublish");
        arguments.add("false");
        arguments.add("-bundles");
        arguments.add(bundlesFile.getAbsolutePath());
        arguments.add("-advices");
        arguments.add(advicesFile.getAbsolutePath());
        arguments.add("-signatures");
        arguments.add(signaturesFile.getAbsolutePath());
        arguments.add("-categoryDefinition");
        arguments.add(categoryURI);
        arguments.add("-artifactRepositoryName");
        arguments.add(this.project.getName());
        arguments.add("-metadataRepositoryName");
        arguments.add(this.project.getName());
        arguments.add("-rules");
        arguments.add("(&(classifier=osgi.bundle));mvn:${maven.groupId}:${maven.artifactId}:${maven.version}:${maven.extension}:${maven.classifier}");
        TychoFeaturesAndBundlesPublisherApplication application = new TychoFeaturesAndBundlesPublisherApplication();
        try {
            result = application.run((String[])arguments.build().toArray(String[]::new));
        }
        catch (Exception e) {
            throw new MojoFailureException((Throwable)e);
        }
        for (File file : advices) {
            file.delete();
        }
        bundlesFile.delete();
        advicesFile.delete();
        signaturesFile.delete();
        if (publicKeysFile != null) {
            publicKeysFile.delete();
        }
        if (result != IApplication.EXIT_OK) {
            throw new MojoFailureException("P2 publisher return code was " + result);
        }
        ZipArchiver archiver = new ZipArchiver();
        File destFile = new File(this.buildDirectory, "p2-site.zip");
        archiver.setDestFile(destFile);
        archiver.addFileSet((FileSet)new DefaultFileSet(this.destination));
        try {
            archiver.createArchive();
        }
        catch (IOException e) {
            throw new MojoExecutionException("failed to create archive", (Exception)e);
        }
        this.projectHelper.attachArtifact(this.project, "zip", "p2site", destFile);
    }

    private List<String> getKeyServers() {
        if (this.keyServerUrls != null && !this.keyServerUrls.isEmpty()) {
            return this.keyServerUrls;
        }
        return DEFAULT_KEY_SERVER;
    }

    private void loadPublicKey(long keyID, Map<Long, PGPPublicKeyRing> publicKeys, String keyServerUrl) throws MojoExecutionException, IOException, PGPException {
        FileInputStream keyStream;
        String hexKey = "0x" + Long.toHexString(keyID).toUpperCase();
        this.logger.info("Fetching PGP key with id " + hexKey + "...");
        File localRepoRoot = new File(this.session.getLocalRepository().getBasedir());
        File keyCacheFile = new File(new File(localRepoRoot, CACHE_RELPATH), hexKey + ".pub");
        if (keyCacheFile.isFile()) {
            this.logger.debug("Fetching key from cache: " + keyCacheFile.getAbsolutePath());
            keyStream = new FileInputStream(keyCacheFile);
        } else {
            URL url = new URL(MessageFormat.format(keyServerUrl, hexKey));
            this.logger.debug("Fetching key from url: " + url);
            InputStream urlStream = this.openStream(url, this.keyServerRetry);
            FileUtils.copyInputStreamToFile((InputStream)urlStream, (File)keyCacheFile);
            keyStream = new FileInputStream(keyCacheFile);
        }
        BcPGPPublicKeyRingCollection publicKeyRing = new BcPGPPublicKeyRingCollection(PGPUtil.getDecoderStream((InputStream)keyStream));
        PGPPublicKeyRing publicKey = publicKeyRing.getPublicKeyRing(keyID);
        if (publicKey != null) {
            publicKeys.put(keyID, publicKey);
        }
        ((InputStream)keyStream).close();
    }

    protected InputStream openStream(URL url, int retry) throws IOException {
        while (retry > 0) {
            HttpURLConnection http;
            int code;
            --retry;
            URLConnection connection = url.openConnection();
            connection.connect();
            if (connection instanceof HttpURLConnection && ((code = (http = (HttpURLConnection)connection).getResponseCode()) == 503 || code == 408 || code == 502)) {
                String field = http.getHeaderField("Retry-After");
                http.disconnect();
                long wait = field == null || !field.isBlank() || !Character.isDigit(field.charAt(0)) ? 10L : (long)Integer.parseInt(field);
                try {
                    TimeUnit.SECONDS.sleep(wait);
                    this.logger.debug("Server is temporary unavailable [code=" + code + "], waiting " + wait + " seconds before retry, " + retry + " retries left...");
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
            }
            return connection.getInputStream();
        }
        throw new IOException("retry count exceeded");
    }

    protected File writeFileList(List<File> files, String name) throws MojoExecutionException {
        try {
            File fileList = File.createTempFile(name, ".txt");
            fileList.deleteOnExit();
            FileUtils.writeLines((File)fileList, (String)StandardCharsets.UTF_8.name(), (Collection)files.stream().map(f -> f == null ? "" : f.getAbsolutePath()).collect(Collectors.toList()));
            return fileList;
        }
        catch (IOException e) {
            throw new MojoExecutionException("failed to generate " + name + " list", (Exception)e);
        }
    }

    protected void resolve(List<Dependency> dependencies, List<File> bundles, List<File> advices, List<File> signatures, Set<String> filesAdded) throws MojoExecutionException {
        for (Dependency dependency : dependencies) {
            this.logger.debug("resolving " + dependency.getGroupId() + "::" + dependency.getArtifactId() + "::" + dependency.getVersion() + "::" + dependency.getClassifier());
            Artifact artifact = this.repositorySystem.createArtifactWithClassifier(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getType(), dependency.getClassifier());
            Set<Artifact> artifacts = this.resolveArtifact(artifact, this.includeTransitiveDependencies);
            for (Artifact resolvedArtifact : artifacts) {
                this.logger.debug("    resolved " + resolvedArtifact.getGroupId() + "::" + resolvedArtifact.getArtifactId() + "::" + resolvedArtifact.getVersion() + "::" + resolvedArtifact.getClassifier());
                File file = resolvedArtifact.getFile();
                if (!filesAdded.add(file.getAbsolutePath())) continue;
                bundles.add(file);
                advices.add(this.createMavenAdvice(resolvedArtifact));
                signatures.add(this.getSignatureFile(artifact));
            }
        }
    }

    protected File createMavenAdvice(Artifact artifact) throws MojoExecutionException {
        try {
            int cnt = 0;
            File p2 = File.createTempFile("p2properties", ".inf");
            p2.deleteOnExit();
            Properties properties = new Properties();
            this.addProvidesAndProperty(properties, "maven-groupId", artifact.getGroupId(), cnt++);
            this.addProvidesAndProperty(properties, "maven-artifactId", artifact.getArtifactId(), cnt++);
            this.addProvidesAndProperty(properties, "maven-version", artifact.getVersion(), cnt++);
            this.addProvidesAndProperty(properties, "maven-extension", artifact.getType(), cnt++);
            this.addProvidesAndProperty(properties, "maven-classifier", artifact.getClassifier(), cnt++);
            this.addProvidesAndProperty(properties, "maven-scope", artifact.getScope(), cnt++);
            properties.store(new FileOutputStream(p2), null);
            return p2;
        }
        catch (IOException e) {
            throw new MojoExecutionException("failed to generate p2.inf", (Exception)e);
        }
    }

    private void addProvidesAndProperty(Properties properties, String key, String value, int i) {
        this.addProvides(properties, key.replace('-', '.'), value, null, i);
        this.addProperty(properties, key, value, i);
    }

    private void addProvides(Properties properties, String namespace, String name, String version, int i) {
        if (name != null && !name.isBlank()) {
            properties.setProperty("provides." + i + ".namespace", namespace);
            properties.setProperty("provides." + i + ".name", name);
            if (version != null && !version.isBlank()) {
                properties.setProperty("provides." + i + ".version", version);
            }
        }
    }

    private void addProperty(Properties properties, String name, String value, int i) {
        if (value != null && !value.isBlank()) {
            properties.setProperty("properties." + i + ".name", name);
            properties.setProperty("properties." + i + ".value", value);
        }
    }

    protected Set<Artifact> resolveArtifact(Artifact artifact, boolean resolveTransitively) {
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setArtifact(artifact);
        request.setOffline(this.session.isOffline());
        request.setLocalRepository(this.session.getLocalRepository());
        request.setResolveTransitively(resolveTransitively);
        request.setRemoteRepositories(this.session.getCurrentProject().getRemoteArtifactRepositories());
        ArtifactResolutionResult result = this.repositorySystem.resolve(request);
        return result.getArtifacts();
    }

    private File getSignatureFile(final Artifact artifact) {
        if (this.includePGPSignature) {
            Artifact signatureArtifact = this.repositorySystem.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), artifact.getClassifier());
            signatureArtifact.setArtifactHandler(new ArtifactHandler(){

                public boolean isIncludesDependencies() {
                    return artifact.getArtifactHandler().isIncludesDependencies();
                }

                public boolean isAddedToClasspath() {
                    return artifact.getArtifactHandler().isAddedToClasspath();
                }

                public String getPackaging() {
                    return artifact.getArtifactHandler().getPackaging();
                }

                public String getLanguage() {
                    return artifact.getArtifactHandler().getLanguage();
                }

                public String getExtension() {
                    return artifact.getArtifactHandler().getExtension() + MavenP2SiteMojo.SIGNATURE_EXTENSION;
                }

                public String getDirectory() {
                    return artifact.getArtifactHandler().getDirectory();
                }

                public String getClassifier() {
                    return artifact.getArtifactHandler().getClassifier();
                }
            });
            Iterator<Artifact> iterator = this.resolveArtifact(signatureArtifact, false).iterator();
            if (iterator.hasNext()) {
                Artifact signature = iterator.next();
                return signature.getFile();
            }
        }
        return null;
    }

    protected boolean skipProject(MavenProject mavenProject) {
        String packaging = mavenProject.getPackaging();
        if (packaging.equalsIgnoreCase("pom")) {
            return true;
        }
        Artifact artifact = mavenProject.getArtifact();
        if (artifact == null) {
            return true;
        }
        File file = artifact.getFile();
        if (file == null || !file.isFile()) {
            return true;
        }
        return this.isSkippedDeploy(mavenProject);
    }

    protected boolean isSkippedDeploy(MavenProject mavenProject) {
        String property = mavenProject.getProperties().getProperty("maven.deploy.skip");
        if (property != null) {
            boolean skip = Boolean.parseBoolean(property);
            this.getLog().debug((CharSequence)("deploy is " + (skip ? "" : "not") + " skipped in MavenProject " + mavenProject.getName() + " because of property 'maven.deploy.skip'"));
            return skip;
        }
        String pluginId = "org.apache.maven.plugins:maven-deploy-plugin";
        property = MavenP2SiteMojo.getPluginParameter(mavenProject, pluginId, "skip");
        if (property != null) {
            boolean skip = Boolean.parseBoolean(property);
            this.getLog().debug((CharSequence)("deploy is " + (skip ? "" : "not") + " skipped in MavenProject " + mavenProject.getName() + " because of configuration of the plugin 'org.apache.maven.plugins:maven-deploy-plugin'"));
            return skip;
        }
        if (mavenProject.getParent() != null) {
            return this.isSkippedDeploy(mavenProject.getParent());
        }
        this.getLog().debug((CharSequence)("not skipping deploy of MavenProject '" + mavenProject.getName() + "'"));
        return false;
    }

    private static String getPluginParameter(MavenProject p, String pluginId, String param) {
        Xpp3Dom xpp3Dom;
        Plugin plugin = MavenP2SiteMojo.getPlugin(p, pluginId);
        if (plugin != null && (xpp3Dom = (Xpp3Dom)plugin.getConfiguration()) != null && xpp3Dom.getChild(param) != null && xpp3Dom.getChild(param).getValue() != null && !xpp3Dom.getChild(param).getValue().isEmpty()) {
            return xpp3Dom.getChild(param).getValue();
        }
        return null;
    }

    private static Plugin getPlugin(MavenProject p, String pluginId) {
        if (p.getBuild() == null || p.getBuild().getPluginsAsMap() == null) {
            return null;
        }
        Plugin plugin = (Plugin)p.getBuild().getPluginsAsMap().get(pluginId);
        if (plugin == null && p.getBuild().getPluginManagement() != null && p.getBuild().getPluginManagement().getPluginsAsMap() != null) {
            plugin = (Plugin)p.getBuild().getPluginManagement().getPluginsAsMap().get(pluginId);
        }
        return plugin;
    }
}

