/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Repository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.tycho.IDependencyMetadata;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.artifactcomparator.ArtifactComparator;
import org.eclipse.tycho.core.EcJLogFileEnhancer;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.p2.metadata.IP2Artifact;
import org.eclipse.tycho.p2.metadata.P2Generator;
import org.eclipse.tycho.plugins.p2.BaselineMode;
import org.eclipse.tycho.plugins.p2.BaselineReplace;
import org.eclipse.tycho.plugins.p2.BaselineValidator;

@Mojo(name="p2-metadata", threadSafe=true)
public class P2MetadataMojo
extends AbstractMojo {
    private static final Object LOCK = new Object();
    @Parameter(property="project")
    protected MavenProject project;
    @Parameter(defaultValue="true")
    protected boolean attachP2Metadata;
    @Component
    protected MavenProjectHelper projectHelper;
    @Component
    P2Generator p2generator;
    @Parameter
    private List<String> supportedProjectTypes = List.of("eclipse-plugin", "eclipse-test-plugin", "eclipse-feature", "p2-installable-unit");
    @Parameter
    private List<Repository> baselineRepositories;
    @Parameter(property="tycho.baseline", defaultValue="warn")
    private BaselineMode baselineMode;
    @Parameter
    private List<String> ignoredPatterns;
    @Parameter(property="tycho.debug.artifactcomparator", defaultValue="false")
    private boolean writeComparatorDelta;
    @Parameter(property="tycho.baseline.replace", defaultValue="all")
    private BaselineReplace baselineReplace;
    @Parameter(property="tycho.generateDownloadStatsProperty", defaultValue="false")
    private boolean generateDownloadStatsProperty;
    @Component
    private BaselineValidator baselineValidator;
    @Parameter(property="tycho.generateChecksums", defaultValue="true")
    private boolean generateChecksums;
    @Component
    private IProvisioningAgent agent;
    @Parameter(defaultValue="false")
    private boolean enhanceLogs;
    @Parameter(defaultValue="${project.build.directory}/compile-logs")
    private File logDirectory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        Object object = LOCK;
        synchronized (object) {
            this.attachP2Metadata();
        }
    }

    protected void attachP2Metadata() throws MojoExecutionException {
        if (!this.attachP2Metadata || !this.supportedProjectTypes.contains(this.project.getPackaging())) {
            return;
        }
        File file = this.project.getArtifact().getFile();
        if (file == null || !file.canRead()) {
            throw new IllegalStateException();
        }
        this.agent.getService(Object.class);
        try {
            Map<String, IP2Artifact> generatedMetadata = this.p2generator.generateMetadata(this.project, this.generateDownloadStatsProperty, this.generateChecksums);
            if (this.baselineMode != BaselineMode.disable) {
                ArtifactComparator.ComparisonData data = new ArtifactComparator.ComparisonData(this.ignoredPatterns, this.writeComparatorDelta);
                if (this.enhanceLogs && this.logDirectory != null && this.logDirectory.isDirectory()) {
                    try (EcJLogFileEnhancer enhancer = EcJLogFileEnhancer.create((File)this.logDirectory);){
                        generatedMetadata = this.baselineValidator.validateAndReplace(this.project, data, generatedMetadata, this.baselineRepositories, this.baselineMode, this.baselineReplace, enhancer);
                    }
                    catch (IOException e) {
                        this.getLog().warn((CharSequence)("Can't enhance logs in directory " + String.valueOf(this.logDirectory)));
                    }
                } else {
                    generatedMetadata = this.baselineValidator.validateAndReplace(this.project, data, generatedMetadata, this.baselineRepositories, this.baselineMode, this.baselineReplace, null);
                }
            }
            P2Generator.FileInfo info = this.p2generator.persistMetadata((Map)generatedMetadata, this.project);
            this.attachArtifact(this.project, "xml", "p2metadata", info.metadata());
            this.attachArtifact(this.project, "xml", "p2artifacts", info.artifacts());
            ReactorProject reactorProject = DefaultReactorProject.adapt((MavenProject)this.project);
            LinkedHashSet installableUnits = new LinkedHashSet();
            generatedMetadata.forEach((classifier, p2artifact) -> {
                installableUnits.addAll(p2artifact.getInstallableUnits());
                if (classifier != null && !P2MetadataMojo.hasAttachedArtifact(this.project, classifier)) {
                    this.projectHelper.attachArtifact(this.project, P2MetadataMojo.getExtension(p2artifact.getLocation()), classifier, p2artifact.getLocation());
                }
            });
            reactorProject.setDependencyMetadata(IDependencyMetadata.DependencyMetadataType.SEED, installableUnits);
            reactorProject.setDependencyMetadata(IDependencyMetadata.DependencyMetadataType.RESOLVE, Collections.emptySet());
            this.p2generator.writeArtifactLocations(this.project);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not generate P2 metadata", (Exception)e);
        }
    }

    private void attachArtifact(MavenProject project, String type, String classifier, File file) {
        for (Artifact artifact : project.getAttachedArtifacts()) {
            if (!classifier.equals(artifact.getClassifier()) || !type.equals(artifact.getType())) continue;
            artifact.setFile(file);
            return;
        }
        this.projectHelper.attachArtifact(project, type, classifier, file);
    }

    private static boolean hasAttachedArtifact(MavenProject project, String classifier) {
        for (Artifact artifact : project.getAttachedArtifacts()) {
            if (!classifier.equals(artifact.getClassifier())) continue;
            return true;
        }
        return false;
    }

    private static String getExtension(File file) {
        String fileName = file.getName();
        int separator = fileName.lastIndexOf(46);
        if (separator < 0) {
            throw new IllegalArgumentException("No file extension in \"" + fileName + "\"");
        }
        return fileName.substring(separator + 1);
    }
}

