/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.director;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.plugin.MojoFailureException;
import org.eclipse.tycho.DependencySeed;
import org.eclipse.tycho.plugins.p2.director.Product;

class ProductConfig {
    private List<Product> products;
    private Collection<DependencySeed> projectSeeds;

    public ProductConfig(List<Product> userConfig, Collection<DependencySeed> projectSeeds) throws MojoFailureException {
        this.projectSeeds = projectSeeds;
        if (userConfig != null) {
            this.products = userConfig;
            for (Product product : this.products) {
                ProductConfig.checkConfiguredProductsExist(product, projectSeeds);
            }
        } else {
            this.products = ProductConfig.getPublishedProduct(projectSeeds);
        }
        this.fillInInstallationRoots(this.products, projectSeeds);
    }

    private static void checkConfiguredProductsExist(Product configuredProduct, Collection<DependencySeed> projectSeeds) throws MojoFailureException {
        if (configuredProduct.getId() == null) {
            throw new MojoFailureException("Attribute 'id' is required in POM product configuration");
        }
        for (DependencySeed seed : projectSeeds) {
            if (!"eclipse-product".equals(seed.getType()) || !configuredProduct.getId().equals(seed.getId())) continue;
            return;
        }
        throw new MojoFailureException("Product with id '" + configuredProduct.getId() + "' does not exist in the project");
    }

    private static List<Product> getPublishedProduct(Collection<DependencySeed> projectSeeds) {
        ArrayList<Product> result = new ArrayList<Product>(1);
        for (DependencySeed seed : projectSeeds) {
            if (!"eclipse-product".equals(seed.getType())) continue;
            result.add(new Product(seed.getId()));
        }
        return result;
    }

    private void fillInInstallationRoots(List<Product> products, Collection<DependencySeed> projectSeeds) {
        for (Product product : products) {
            for (DependencySeed seed : projectSeeds) {
                if (!seed.isAddOnFor("eclipse-product", product.getId())) continue;
                product.addInstallationSeed(seed);
            }
        }
    }

    public boolean uniqueAttachIds() {
        HashSet<String> attachIDs = new HashSet<String>();
        for (Product product : this.products) {
            if (!attachIDs.contains(product.getAttachId())) {
                attachIDs.add(product.getAttachId());
                continue;
            }
            return false;
        }
        return true;
    }

    public List<Product> getProducts() {
        return this.products;
    }

    public Collection<DependencySeed> getProjectSeeds() {
        return this.projectSeeds;
    }
}

