/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.director;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.bzip2.BZip2Archiver;
import org.codehaus.plexus.archiver.gzip.GZipArchiver;
import org.codehaus.plexus.archiver.snappy.SnappyArchiver;
import org.codehaus.plexus.archiver.tar.TarArchiver;
import org.codehaus.plexus.archiver.tar.TarLongFileMode;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.archiver.xz.XZArchiver;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.eclipse.tycho.TargetEnvironment;
import org.eclipse.tycho.plugins.p2.director.AbstractProductMojo;
import org.eclipse.tycho.plugins.p2.director.Product;
import org.eclipse.tycho.plugins.p2.director.ProductConfig;
import org.eclipse.tycho.plugins.tar.TarGzArchiver;

@Mojo(name="archive-products", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public final class ProductArchiverMojo
extends AbstractProductMojo {
    private static final String ZIP_ARCHIVE_FORMAT = "zip";
    private static final String TAR_GZ_ARCHIVE_FORMAT = "tar.gz";
    private static final String TGZ_ARCHIVE_FORMAT = "tgz";
    private static final String BZIP2_ARCHIVE_FORMAT = "bzip2";
    private static final String GZIP_ARCHIVE_FORMAT = "gzip";
    private static final String SNAPPY_ARCHIVE_FORMAT = "snappy";
    private static final String XZ_ARCHIVE_FORMAT = "xz";
    private static final Map<String, ThreadLocal<Archiver>> productArchivers;
    @Parameter
    private Map<String, String> formats;
    @Parameter
    private boolean parallel;
    @Component
    private MavenProjectHelper helper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        ProductConfig config = this.getProductConfig();
        if (!config.uniqueAttachIds()) {
            throw new MojoFailureException("Artifact file names for the archived products are not unique. Configure the attachId or select a subset of products. Current configuration: " + config.getProducts());
        }
        if (this.parallel) {
            ExecutorService executorService = Executors.newWorkStealingPool();
            ExecutorCompletionService<Void> service = new ExecutorCompletionService<Void>(executorService);
            try {
                int tasks = 0;
                for (Product product : config.getProducts()) {
                    File bundlePool = this.getProductBundlePoolDirectory(product);
                    if (bundlePool != null) {
                        service.submit(() -> {
                            this.materialize(product, null);
                            return null;
                        });
                        ++tasks;
                        continue;
                    }
                    for (TargetEnvironment env : this.getEnvironments()) {
                        service.submit(() -> {
                            this.materialize(product, env);
                            return null;
                        });
                        ++tasks;
                    }
                }
                for (int i = 0; i < tasks; ++i) {
                    try {
                        service.take().get();
                        continue;
                    }
                    catch (InterruptedException e) {
                        executorService.shutdown();
                        return;
                    }
                    catch (ExecutionException e) {
                        Throwable cause = e.getCause();
                        if (cause instanceof RuntimeException) {
                            RuntimeException rte = (RuntimeException)cause;
                            throw rte;
                        }
                        if (cause instanceof MojoFailureException) {
                            MojoFailureException mfe = (MojoFailureException)cause;
                            throw mfe;
                        }
                        if (cause instanceof MojoExecutionException) {
                            MojoExecutionException mee = (MojoExecutionException)cause;
                            throw mee;
                        }
                        throw new MojoFailureException("internal error", (Throwable)e);
                    }
                }
            }
            finally {
                executorService.shutdown();
            }
        } else {
            for (Product product : config.getProducts()) {
                File bundlePool = this.getProductBundlePoolDirectory(product);
                if (bundlePool != null) {
                    this.materialize(product, null);
                    continue;
                }
                for (TargetEnvironment env : this.getEnvironments()) {
                    this.materialize(product, env);
                }
            }
        }
    }

    private void materialize(Product product, TargetEnvironment env) throws MojoExecutionException {
        String format = this.getArchiveFormat(product, env);
        ThreadLocal<Archiver> productArchiver = productArchivers.get(format);
        if (productArchiver == null) {
            String os = env != null ? "os=" + env.getOs() : "";
            throw new MojoExecutionException("Unknown or unsupported archive format " + os + " format=" + format);
        }
        File productArchive = new File(this.getProductsBuildDirectory(), ProductArchiverMojo.getArchiveFileName(product) + "-" + ProductArchiverMojo.getOsWsArch(env, '.') + "." + format);
        try {
            File sourceDir = this.getProductMaterializeDirectory(product, env);
            if ((TGZ_ARCHIVE_FORMAT.equals(format) || TAR_GZ_ARCHIVE_FORMAT.equals(format)) && !"plexus".equals(this.getSession().getUserProperties().getProperty("tycho.tar"))) {
                this.getLog().debug((CharSequence)"Using commons-compress tar");
                this.createCommonsCompressTarGz(productArchive, sourceDir);
            } else {
                Archiver archiver = productArchiver.get();
                archiver.setDestFile(productArchive);
                DefaultFileSet fileSet = new DefaultFileSet(sourceDir);
                fileSet.setUsingDefaultExcludes(false);
                archiver.addFileSet((FileSet)fileSet);
                archiver.createArchive();
            }
        }
        catch (IOException | ArchiverException e) {
            throw new MojoExecutionException("Error packing product", (Exception)e);
        }
        String artifactClassifier = ProductArchiverMojo.getArtifactClassifier(product, env);
        this.helper.attachArtifact(this.getProject(), format, artifactClassifier, productArchive);
    }

    private void createCommonsCompressTarGz(File productArchive, File sourceDir) throws IOException {
        TarGzArchiver archiver = new TarGzArchiver();
        archiver.setLog(this.getLog());
        archiver.addDirectory(sourceDir);
        archiver.setDestFile(productArchive);
        archiver.createArchive();
    }

    private String getArchiveFormat(Product product, TargetEnvironment env) {
        if (this.formats != null) {
            String format;
            if (product.isMultiPlatformPackage()) {
                format = this.formats.get("multiPlatformPackage");
            } else {
                String string = format = env != null ? this.formats.get(env.getOs()) : null;
            }
            if (format != null && !format.trim().isBlank()) {
                return format.trim();
            }
        }
        if (product.isMultiPlatformPackage()) {
            return ZIP_ARCHIVE_FORMAT;
        }
        if (env != null && ("linux".equals(env.getOs()) || "macosx".equals(env.getOs()))) {
            return TAR_GZ_ARCHIVE_FORMAT;
        }
        return ZIP_ARCHIVE_FORMAT;
    }

    static String getArchiveFileName(Product product) {
        if (product.getArchiveFileName() != null) {
            return product.getArchiveFileName();
        }
        return product.getId();
    }

    static String getArtifactClassifier(Product product, TargetEnvironment environment) {
        Object artifactClassifier = product.getAttachId() == null ? ProductArchiverMojo.getOsWsArch(environment, '.') : product.getAttachId() + "-" + ProductArchiverMojo.getOsWsArch(environment, '.');
        return artifactClassifier;
    }

    static {
        ThreadLocal<Archiver> zipFormat = ThreadLocal.withInitial(() -> new ZipArchiver());
        ThreadLocal<Archiver> tgzFormat = ThreadLocal.withInitial(() -> {
            TarArchiver tar = new TarArchiver();
            tar.setCompression(TarArchiver.TarCompressionMethod.gzip);
            tar.setLongfile(TarLongFileMode.gnu);
            return tar;
        });
        ThreadLocal<Archiver> bzip2Format = ThreadLocal.withInitial(() -> new BZip2Archiver());
        ThreadLocal<Archiver> gzipFormat = ThreadLocal.withInitial(() -> new GZipArchiver());
        ThreadLocal<Archiver> snappyFormat = ThreadLocal.withInitial(() -> new SnappyArchiver());
        ThreadLocal<Archiver> xzFormat = ThreadLocal.withInitial(() -> new XZArchiver());
        productArchivers = Map.of(ZIP_ARCHIVE_FORMAT, zipFormat, TAR_GZ_ARCHIVE_FORMAT, tgzFormat, TGZ_ARCHIVE_FORMAT, tgzFormat, BZIP2_ARCHIVE_FORMAT, bzip2Format, GZIP_ARCHIVE_FORMAT, gzipFormat, SNAPPY_ARCHIVE_FORMAT, snappyFormat, XZ_ARCHIVE_FORMAT, xzFormat);
    }
}

