/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.director;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.tar.TarArchiver;
import org.codehaus.plexus.archiver.tar.TarLongFileMode;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.eclipse.tycho.core.shared.TargetEnvironment;
import org.eclipse.tycho.plugins.p2.director.AbstractProductMojo;
import org.eclipse.tycho.plugins.p2.director.Product;
import org.eclipse.tycho.plugins.p2.director.ProductConfig;
import org.eclipse.tycho.plugins.tar.TarGzArchiver;

@Mojo(name="archive-products", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public final class ProductArchiverMojo
extends AbstractProductMojo {
    private static final Object LOCK = new Object();
    private static final String DEFAULT_ARCHIVE_FORMAT = "zip";
    private static final String TAR_GZ_ARCHIVE_FORMAT = "tar.gz";
    private final Map<String, ProductArchiver> productArchivers = new HashMap<String, ProductArchiver>();
    @Parameter
    private Map<String, String> formats;
    @Component(role=Archiver.class, hint="zip")
    private Archiver zipArchiver;
    @Component(role=Archiver.class, hint="tar")
    private TarArchiver tarArchiver;
    @Component
    private MavenProjectHelper helper;

    public ProductArchiverMojo() {
        this.productArchivers.put(DEFAULT_ARCHIVE_FORMAT, new ProductArchiver(){

            @Override
            Archiver getArchiver() {
                return ProductArchiverMojo.this.zipArchiver;
            }
        });
        this.productArchivers.put(TAR_GZ_ARCHIVE_FORMAT, new ProductArchiver(){

            @Override
            Archiver getArchiver() throws ArchiverException {
                ProductArchiverMojo.this.tarArchiver.setCompression(TarArchiver.TarCompressionMethod.gzip);
                ProductArchiverMojo.this.tarArchiver.setLongfile(TarLongFileMode.gnu);
                return ProductArchiverMojo.this.tarArchiver;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        Object object = LOCK;
        synchronized (object) {
            ProductConfig config = this.getProductConfig();
            if (!config.uniqueAttachIds()) {
                throw new MojoFailureException("Artifact file names for the archived products are not unique. Configure the attachId or select a subset of products. Current configuration: " + config.getProducts());
            }
            for (Product product : config.getProducts()) {
                for (TargetEnvironment env : this.getEnvironments()) {
                    String format = this.getArchiveFormat(env);
                    ProductArchiver productArchiver = this.productArchivers.get(format);
                    if (productArchiver == null) {
                        throw new MojoExecutionException("Unknown or unsupported archive format os=" + env.getOs() + " format=" + format);
                    }
                    File productArchive = new File(this.getProductsBuildDirectory(), ProductArchiverMojo.getArchiveFileName(product) + "-" + ProductArchiverMojo.getOsWsArch(env, '.') + "." + format);
                    try {
                        File sourceDir = this.getProductMaterializeDirectory(product, env);
                        if (TAR_GZ_ARCHIVE_FORMAT.equals(format) && !"plexus".equals(this.getSession().getUserProperties().getProperty("tycho.tar"))) {
                            this.getLog().debug((CharSequence)"Using commons-compress tar");
                            this.createCommonsCompressTarGz(productArchive, sourceDir);
                        } else {
                            Archiver archiver = productArchiver.getArchiver();
                            archiver.setDestFile(productArchive);
                            DefaultFileSet fileSet = new DefaultFileSet(sourceDir);
                            fileSet.setUsingDefaultExcludes(false);
                            archiver.addFileSet((FileSet)fileSet);
                            archiver.createArchive();
                        }
                    }
                    catch (ArchiverException e) {
                        throw new MojoExecutionException("Error packing product", (Exception)((Object)e));
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("Error packing product", (Exception)e);
                    }
                    String artifactClassifier = ProductArchiverMojo.getArtifactClassifier(product, env);
                    this.helper.attachArtifact(this.getProject(), format, artifactClassifier, productArchive);
                }
            }
        }
    }

    private void createCommonsCompressTarGz(File productArchive, File sourceDir) throws IOException {
        TarGzArchiver archiver = new TarGzArchiver();
        archiver.setLog(this.getLog());
        archiver.addDirectory(sourceDir);
        archiver.setDestFile(productArchive);
        archiver.createArchive();
    }

    private String getArchiveFormat(TargetEnvironment env) {
        String format;
        String string = format = this.formats != null ? this.formats.get(env.getOs()) : DEFAULT_ARCHIVE_FORMAT;
        if (format != null) {
            format = format.trim();
        }
        if (format == null || format.length() == 0) {
            format = DEFAULT_ARCHIVE_FORMAT;
        }
        return format;
    }

    static String getArchiveFileName(Product product) {
        if (product.getArchiveFileName() != null) {
            return product.getArchiveFileName();
        }
        return product.getId();
    }

    static String getArtifactClassifier(Product product, TargetEnvironment environment) {
        String artifactClassifier = product.getAttachId() == null ? ProductArchiverMojo.getOsWsArch(environment, '.') : product.getAttachId() + "-" + ProductArchiverMojo.getOsWsArch(environment, '.');
        return artifactClassifier;
    }

    private abstract class ProductArchiver {
        private ProductArchiver() {
        }

        abstract Archiver getArchiver() throws ArchiverException;
    }
}

