/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.model.project;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.tycho.model.project.EclipseProject;
import org.eclipse.tycho.model.project.ProjectVariable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class ProjectParser {
    private static final String PROJECT_LOC = "PROJECT_LOC";
    private static final Pattern DOLLAR_VARIABLE_PATTERN = Pattern.compile("\\$\\{([^\\$]+)\\}");
    private static final Pattern PARENT_PROJECT_PATTERN = Pattern.compile("PARENT-(\\d+)-PROJECT_LOC");

    ProjectParser() {
    }

    public static EclipseProject parse(Path path) throws IOException {
        EclipseProject eclipseProject;
        block9: {
            InputStream stream = Files.newInputStream(path, new OpenOption[0]);
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(stream);
                Element root = doc.getDocumentElement();
                Node nameNode = root.getElementsByTagName("name").item(0);
                Node commentNode = root.getElementsByTagName("comment").item(0);
                final Path location = path.getParent();
                final String name = nameNode != null ? nameNode.getTextContent().strip() : location.getFileName().toString();
                final String comment = commentNode == null ? null : commentNode.getTextContent();
                NodeList natureNodes = root.getElementsByTagName("nature");
                int length = natureNodes.getLength();
                final HashSet<String> natureSet = new HashSet<String>();
                for (int i2 = 0; i2 < length; ++i2) {
                    natureSet.add(natureNodes.item(i2).getTextContent());
                }
                NodeList variableNodes = root.getElementsByTagName("variable");
                final List<ProjectVariable> variables = IntStream.range(0, variableNodes.getLength()).mapToObj(i -> variableNodes.item(i)).map(Element.class::cast).map(e -> ProjectParser.parseVariable(e)).filter(Objects::nonNull).toList();
                final Map<String, URI> variablesMap = variables.stream().collect(Collectors.toMap(ProjectVariable::name, ProjectVariable::value));
                NodeList linkNodes = root.getElementsByTagName("link");
                final Set links = IntStream.range(0, linkNodes.getLength()).mapToObj(i -> linkNodes.item(i)).map(Element.class::cast).map(e -> ProjectParser.parseLink(e)).filter(Objects::nonNull).collect(Collectors.toSet());
                eclipseProject = new EclipseProject(){

                    public String toString() {
                        return this.getName() + " @ " + String.valueOf(this.getLocation());
                    }

                    public int hashCode() {
                        return this.getLocation().hashCode();
                    }

                    public boolean equals(Object obj) {
                        if (obj instanceof EclipseProject) {
                            EclipseProject p = (EclipseProject)obj;
                            return p.getLocation().equals(this.getLocation());
                        }
                        return false;
                    }

                    @Override
                    public String getName() {
                        return name;
                    }

                    @Override
                    public Path getLocation() {
                        return location;
                    }

                    @Override
                    public boolean hasNature(String nature) {
                        return natureSet.contains(nature);
                    }

                    @Override
                    public String getComment() {
                        if (comment == null || comment.isBlank()) {
                            return null;
                        }
                        return comment;
                    }

                    @Override
                    public Path getFile(Path path) {
                        if (path == null) {
                            return null;
                        }
                        if (!path.isAbsolute()) {
                            path = location.resolve(path);
                        }
                        if (Files.isRegularFile(path, new LinkOption[0])) {
                            return path;
                        }
                        Path relative = location.relativize(path);
                        for (LinkDescription link : links) {
                            if (!relative.startsWith(link.name())) continue;
                            return ProjectParser.resolvePath(link, relative, location, variablesMap);
                        }
                        return path;
                    }

                    @Override
                    public Path getFile(String path) {
                        return this.getFile(location.resolve(path));
                    }

                    @Override
                    public Collection<ProjectVariable> getVariables() {
                        return variables;
                    }
                };
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ParserConfigurationException | SAXException e2) {
                    throw new IOException("parsing failed", e2);
                }
            }
            stream.close();
        }
        return eclipseProject;
    }

    private static Path uriToPath(URI uri) {
        if (uri.getScheme() == null || "file".equals(uri.getScheme())) {
            return Path.of(uri.getSchemeSpecificPart(), new String[0]);
        }
        return null;
    }

    static Path resolvePath(LinkDescription link, Path path, Path projectLocation, Map<String, URI> variablesMap) {
        Path linkPath;
        if (link.location() != null) {
            linkPath = link.location();
        } else if (link.locationURI() != null) {
            URI uri = link.locationURI();
            if (uri == null) {
                return null;
            }
            String schemeSpecificPart = uri.getSchemeSpecificPart();
            if (schemeSpecificPart == null) {
                return null;
            }
            linkPath = Path.of(schemeSpecificPart, new String[0]);
            int count = linkPath.getNameCount();
            if (count == 0) {
                return null;
            }
        } else {
            return null;
        }
        if (link.type() == 1 && path.getNameCount() > 1) {
            return null;
        }
        Path result = ProjectParser.resolveVariables(linkPath, projectLocation, variablesMap);
        if (result == null) {
            return null;
        }
        result = projectLocation.resolve(result);
        result = ProjectParser.appendRemaining(path, result);
        result = result.normalize();
        return result;
    }

    private static Path resolveVariables(Path path, Path projectLocation, Map<String, URI> variablesMap) {
        Path first = path.getName(0);
        String name = first.toString();
        URI variableUri = variablesMap.get(name);
        if (variableUri != null) {
            Path variablePath = ProjectParser.uriToPath(variableUri);
            if (variablePath == null) {
                return null;
            }
            Path[] resolvedPath = new Path[]{variablePath};
            HashSet<String> seenVariables = new HashSet<String>(Set.of(name));
            while (ProjectParser.resolveDollarVariable(resolvedPath, projectLocation, seenVariables, variablesMap)) {
            }
            if (resolvedPath[0] == null) {
                return null;
            }
            return ProjectParser.appendRemaining(path, resolvedPath[0]);
        }
        if (PROJECT_LOC.equals(name)) {
            return ProjectParser.appendRemaining(path, projectLocation);
        }
        Matcher parentMatcher = PARENT_PROJECT_PATTERN.matcher(name);
        if (parentMatcher.matches()) {
            return ProjectParser.appendRemaining(path, ProjectParser.dotDotTimes(Integer.parseInt(parentMatcher.group(1))));
        }
        return path;
    }

    private static boolean resolveDollarVariable(Path[] resolvedPath, Path projectLocation, Set<String> seenVariables, Map<String, URI> variablesMap) {
        Matcher dollarVariableMatcher = DOLLAR_VARIABLE_PATTERN.matcher(resolvedPath[0].getName(0).toString());
        if (!dollarVariableMatcher.matches()) {
            return false;
        }
        String expanded = dollarVariableMatcher.group(1);
        if (PROJECT_LOC.equals(expanded)) {
            resolvedPath[0] = ProjectParser.appendRemaining(resolvedPath[0], projectLocation);
            return false;
        }
        Matcher parentMatcher = PARENT_PROJECT_PATTERN.matcher(expanded);
        if (parentMatcher.matches()) {
            resolvedPath[0] = ProjectParser.appendRemaining(resolvedPath[0], ProjectParser.dotDotTimes(Integer.parseInt(parentMatcher.group(1))));
            return false;
        }
        URI variableUri = variablesMap.get(expanded);
        if (variableUri == null) {
            return false;
        }
        Path variablePath = ProjectParser.uriToPath(variableUri);
        if (variablePath == null) {
            resolvedPath[0] = null;
            return false;
        }
        if (!seenVariables.add(expanded)) {
            resolvedPath[0] = null;
            return false;
        }
        resolvedPath[0] = ProjectParser.appendRemaining(resolvedPath[0], variablePath);
        return true;
    }

    private static Path dotDotTimes(int count) {
        Path path = Path.of("..", new String[0]);
        for (int i = 1; i < count; ++i) {
            path = path.resolve("..");
        }
        return path;
    }

    private static Path appendRemaining(Path path, Path resolvedPath) {
        int count = path.getNameCount();
        for (int i = 1; i < count; ++i) {
            resolvedPath = resolvedPath.resolve(path.getName(i));
        }
        return resolvedPath;
    }

    private static ProjectVariable parseVariable(Element element) {
        try {
            String name = element.getElementsByTagName("name").item(0).getTextContent();
            String value = element.getElementsByTagName("value").item(0).getTextContent();
            return new ProjectVariable(name, URI.create(value));
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    private static LinkDescription parseLink(Element element) {
        try {
            String name = element.getElementsByTagName("name").item(0).getTextContent();
            String type = element.getElementsByTagName("type").item(0).getTextContent();
            Node locationNode = element.getElementsByTagName("location").item(0);
            Node locationUriNode = element.getElementsByTagName("locationURI").item(0);
            Path location = locationNode == null ? null : Path.of(locationNode.getTextContent(), new String[0]);
            URI locationURI = locationUriNode == null ? null : URI.create(locationUriNode.getTextContent());
            return new LinkDescription(Path.of(name, new String[0]), Integer.parseInt(type), location, locationURI);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    record LinkDescription(Path name, int type, Path location, URI locationURI) {
        static final int FILE = 1;
        static final int FOLDER = 2;
        static final int PROJECT = 4;
        static final int ROOT = 8;
    }
}

