/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.model.project;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.tycho.model.project.EclipseProject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class ProjectParser {
    ProjectParser() {
    }

    public static EclipseProject parse(Path path) throws IOException {
        EclipseProject eclipseProject;
        block9: {
            InputStream stream = Files.newInputStream(path, new OpenOption[0]);
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(stream);
                Element root = doc.getDocumentElement();
                Node nameNode = root.getElementsByTagName("name").item(0);
                Node commentNode = root.getElementsByTagName("comment").item(0);
                final Path location = path.getParent();
                final String name = nameNode != null ? nameNode.getTextContent().strip() : location.getFileName().toString();
                final String comment = commentNode == null ? null : commentNode.getTextContent();
                NodeList natureNodes = root.getElementsByTagName("nature");
                int length = natureNodes.getLength();
                final HashSet<String> natureSet = new HashSet<String>();
                for (int i = 0; i < length; ++i) {
                    natureSet.add(natureNodes.item(i).getTextContent());
                }
                eclipseProject = new EclipseProject(){

                    public String toString() {
                        return this.getName() + " @ " + this.getLocation();
                    }

                    public int hashCode() {
                        return this.getLocation().hashCode();
                    }

                    public boolean equals(Object obj) {
                        if (obj instanceof EclipseProject) {
                            EclipseProject p = (EclipseProject)obj;
                            return p.getLocation().equals(this.getLocation());
                        }
                        return false;
                    }

                    @Override
                    public String getName() {
                        return name;
                    }

                    @Override
                    public Path getLocation() {
                        return location;
                    }

                    @Override
                    public boolean hasNature(String nature) {
                        return natureSet.contains(nature);
                    }

                    @Override
                    public String getComment() {
                        if (comment == null || comment.isBlank()) {
                            return null;
                        }
                        return comment;
                    }
                };
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ParserConfigurationException | SAXException e) {
                    throw new IOException("parsing failed", e);
                }
            }
            stream.close();
        }
        return eclipseProject;
    }
}

