/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.compiler;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.tycho.SourcepathEntry;
import org.eclipse.tycho.compiler.AbstractOsgiCompilerMojo;
import org.eclipse.tycho.core.osgitools.project.BuildOutputJar;

@Mojo(name="compile", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class OsgiCompilerMojo
extends AbstractOsgiCompilerMojo {
    @Override
    protected void doFinish() throws MojoExecutionException {
        BuildOutputJar dotOutputJar = this.getEclipsePluginProject().getDotOutputJar();
        if (dotOutputJar != null) {
            this.project.getArtifact().setFile(dotOutputJar.getOutputDirectory());
        }
    }

    @Override
    public List<SourcepathEntry> getSourcepath() throws MojoExecutionException {
        ArrayList<SourcepathEntry> entries = new ArrayList<SourcepathEntry>();
        for (BuildOutputJar jar : this.getEclipsePluginProject().getOutputJars()) {
            for (File sourcesRoot : jar.getSourceFolders()) {
                BuildOutputJarSourcepathEntry entry = new BuildOutputJarSourcepathEntry(sourcesRoot, jar);
                entries.add(entry);
            }
        }
        return entries;
    }

    @Override
    protected String getDependencyScope() {
        return "compile";
    }

    private final class BuildOutputJarSourcepathEntry
    implements SourcepathEntry {
        private final File sourcesRoot;
        private final BuildOutputJar jar;

        private BuildOutputJarSourcepathEntry(File sourcesRoot, BuildOutputJar jar) {
            this.sourcesRoot = sourcesRoot;
            this.jar = jar;
        }

        public File getSourcesRoot() {
            return this.sourcesRoot;
        }

        public File getOutputDirectory() {
            return this.jar.getOutputDirectory();
        }

        public List<String> getIncludes() {
            return null;
        }

        public List<String> getExcludes() {
            return this.jar.getFilesToExclude();
        }
    }
}

