/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.extras.buildtimestamp.jgit;

import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.jgit.ignore.FastIgnoreRule;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class PathFilter
extends TreeFilter {
    private static final Pattern FILTER_DELIMITER = Pattern.compile("[\n\r\f]");
    private final byte[] basedir;
    private final List<FastIgnoreRule> rules;

    public PathFilter(String basedir, String filters) {
        this.basedir = Constants.encode((String)basedir);
        Stream<FastIgnoreRule> standardRules = Stream.of(new FastIgnoreRule(".tycho-consumer-pom.xml"), new FastIgnoreRule(".polyglot.*"), new FastIgnoreRule("pom.tycho"));
        Stream<Object> filterRules = Stream.empty();
        if (filters != null) {
            filterRules = FILTER_DELIMITER.splitAsStream(filters).filter(f -> !f.isBlank()).map(String::strip).map(FastIgnoreRule::new);
        }
        this.rules = Stream.concat(standardRules, filterRules).toList();
    }

    public boolean include(TreeWalk tw) throws IOException {
        if (tw.isPathPrefix(this.basedir, this.basedir.length) != 0) {
            return false;
        }
        if (!tw.isSubtree()) {
            String path = tw.getPathString();
            for (FastIgnoreRule rule : this.rules) {
                if (!rule.isMatch(path, tw.isSubtree())) continue;
                return !rule.getResult();
            }
        }
        return true;
    }

    public boolean shouldBeRecursive() {
        return true;
    }

    public TreeFilter clone() {
        return this;
    }
}

