/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.bnd.maven;

import aQute.bnd.build.Project;
import aQute.bnd.build.SubProject;
import aQute.bnd.build.Workspace;
import biz.aQute.resolve.Bndrun;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Manifest;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.tycho.bnd.maven.BndMavenProject;
import org.eclipse.tycho.bnd.mojos.BndRunMojo;
import org.eclipse.tycho.bndlib.BndRunFile;
import org.eclipse.tycho.core.bnd.BndPluginManager;

@Component(role=AbstractMavenLifecycleParticipant.class)
public class BndMavenLifecycleParticipant
extends AbstractMavenLifecycleParticipant {
    private static final Set<Map.Entry<String, String>> BND_TO_MAVEN_MAPPING = Map.of("-runbundles", "runtime", "-dependson", "runtime", "-buildpath", "compile", "-testpath", "test").entrySet();
    @Requirement
    private Logger logger;
    @Requirement
    private BndPluginManager bndPluginManager;

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        Set<String> added;
        MavenProject mavenProject;
        Workspace.setDriver((String)"tycho-maven-build");
        Map<MavenProject, Project> bndProjects = this.getProjects(session);
        Map<String, BndMavenProject> manifestFirstProjects = this.getManifestFirstProjects(session, bndProjects.keySet());
        HashMap<Object, BndMavenProject> bndWorkspaceProjects = new HashMap<Object, BndMavenProject>();
        for (Map.Entry<MavenProject, Project> entry : bndProjects.entrySet()) {
            MavenProject mavenProject2 = entry.getKey();
            Project project = entry.getValue();
            this.logger.debug("==" + mavenProject2.getId() + "==");
            List subProjects = project.getSubProjects();
            this.logger.debug("Main: " + project.getName());
            if (subProjects.isEmpty()) {
                bndWorkspaceProjects.put(project.getName(), new BndMavenProject(mavenProject2, project, null));
                continue;
            }
            for (SubProject subProject : subProjects) {
                this.logger.debug("Sub: " + subProject.getName());
                bndWorkspaceProjects.put(project.getName() + "." + subProject.getName(), new BndMavenProject(mavenProject2, project, subProject.getName()));
            }
        }
        HashMap<MavenProject, Set<String>> dependencyMap = new HashMap<MavenProject, Set<String>>();
        for (Map.Entry<MavenProject, Project> entry : bndProjects.entrySet()) {
            mavenProject = entry.getKey();
            added = BndMavenLifecycleParticipant.getProjectSet(mavenProject, dependencyMap);
            Project bndProject = entry.getValue();
            try {
                for (Map.Entry<String, String> mapping : BND_TO_MAVEN_MAPPING) {
                    Set<String> requirements = this.getRequirements(bndProject, mavenProject, session, mapping.getKey());
                    String mavenScope = mapping.getValue();
                    for (String required : requirements) {
                        BndMavenProject bndMavenProject = (BndMavenProject)bndWorkspaceProjects.get(required);
                        if (bndMavenProject == null) {
                            bndMavenProject = manifestFirstProjects.get(required);
                        }
                        if (bndMavenProject == null || bndMavenProject.mavenProject() == mavenProject) continue;
                        MavenProject requiredMavenProject = bndMavenProject.mavenProject();
                        this.logger.debug(mavenProject.getId() + " depends on reactor project " + requiredMavenProject.getId() + " ...");
                        Dependency dependency = new Dependency();
                        dependency.setGroupId(requiredMavenProject.getGroupId());
                        dependency.setArtifactId(requiredMavenProject.getArtifactId());
                        dependency.setVersion(requiredMavenProject.getVersion());
                        dependency.setScope(mavenScope);
                        if (bndMavenProject.classifier() != null) {
                            Dependency clone = dependency.clone();
                            clone.setClassifier(bndMavenProject.classifier());
                            clone.setType("jar");
                            BndMavenLifecycleParticipant.addDependency(mavenProject, clone, added);
                        }
                        dependency.setType(requiredMavenProject.getPackaging());
                        BndMavenLifecycleParticipant.addDependency(mavenProject, dependency, added);
                    }
                }
            }
            catch (Exception e) {
                this.logError("Can't get dependents of project " + mavenProject.getId(), e);
            }
        }
        for (BndMavenProject bndMavenProject : manifestFirstProjects.values()) {
            mavenProject = bndMavenProject.mavenProject();
            added = BndMavenLifecycleParticipant.getProjectSet(mavenProject, dependencyMap);
            try {
                File file = new File(mavenProject.getBasedir(), "build.properties");
                if (!file.isFile()) continue;
                Properties properties = new Properties();
                try (FileInputStream stream = new FileInputStream(file);){
                    properties.load(stream);
                }
                String property = properties.getProperty("additional.bundles");
                if (property == null || property.isBlank()) continue;
                for (String bundle : property.split(",")) {
                    BndMavenProject requiredMavenProject = (BndMavenProject)bndWorkspaceProjects.get(bundle.trim());
                    if (requiredMavenProject == null || requiredMavenProject.mavenProject() == mavenProject) continue;
                    this.logger.debug(mavenProject.getId() + " depends on reactor project " + requiredMavenProject.mavenProject().getId() + " ...");
                    Dependency dependency = new Dependency();
                    dependency.setGroupId(requiredMavenProject.mavenProject().getGroupId());
                    dependency.setArtifactId(requiredMavenProject.mavenProject().getArtifactId());
                    dependency.setVersion(requiredMavenProject.mavenProject().getVersion());
                    BndMavenLifecycleParticipant.addDependency(mavenProject, dependency, added);
                }
            }
            catch (Exception e) {
                this.logError("Can't get dependents of project " + mavenProject.getId(), e);
            }
        }
    }

    private Set<String> getRequirements(Project bndProject, MavenProject mavenProject, MavenSession session, String property) throws MavenExecutionException {
        if ("-runbundles".equals(property)) {
            Plugin plugin = mavenProject.getPlugin(Plugin.constructKey((String)"org.eclipse.tycho", (String)"tycho-bnd-plugin"));
            HashSet<String> selectedBndRuns = new HashSet<String>();
            if (plugin != null) {
                for (PluginExecution pluginExecution : plugin.getExecutions()) {
                    if (!pluginExecution.getGoals().contains("run")) continue;
                    String exportsProperty = session.getUserProperties().getProperty("bndrun.exports");
                    if (exportsProperty == null) {
                        PlexusConfiguration[] children;
                        Xpp3Dom dom;
                        XmlPlexusConfiguration cfg;
                        PlexusConfiguration child;
                        String[] configuration = pluginExecution.getConfiguration();
                        if (!(configuration instanceof Xpp3Dom) || (child = (cfg = new XmlPlexusConfiguration(dom = (Xpp3Dom)configuration)).getChild("exports", false)) == null) continue;
                        for (PlexusConfiguration c : children = child.getChildren()) {
                            selectedBndRuns.add(c.getValue());
                        }
                        continue;
                    }
                    for (String run : exportsProperty.split(",")) {
                        selectedBndRuns.add(run);
                    }
                }
            }
            if (selectedBndRuns.isEmpty()) {
                return Set.of();
            }
            try {
                List<BndRunFile> bndRuns = BndRunMojo.getBndRuns(mavenProject.getBasedir().toPath(), selectedBndRuns);
                if (bndRuns.isEmpty()) {
                    return Set.of();
                }
                HashSet<String> dependencies = new HashSet<String>();
                for (BndRunFile runFile : bndRuns) {
                    try {
                        Bndrun bndrun = Bndrun.createBndrun((Workspace)bndProject.getWorkspace(), (File)runFile.path().toFile());
                        dependencies.addAll(bndrun.getMergedParameters(property).keySet());
                    }
                    catch (Exception e) {
                        throw new MavenExecutionException("can't read required bnd run " + String.valueOf(runFile.path()), (Throwable)e);
                    }
                }
                return dependencies;
            }
            catch (MojoExecutionException e) {
                throw new MavenExecutionException("can't read required bnd runs", e.getCause());
            }
        }
        return bndProject.getMergedParameters(property).keySet();
    }

    private Map<String, BndMavenProject> getManifestFirstProjects(MavenSession session, Set<MavenProject> existing) {
        HashMap<String, BndMavenProject> result = new HashMap<String, BndMavenProject>();
        for (MavenProject mavenProject : session.getProjects()) {
            File basedir;
            File manifestFile;
            if (existing.contains(mavenProject) || !(manifestFile = new File(basedir = mavenProject.getBasedir(), "META-INF/MANIFEST.MF")).exists()) continue;
            try (FileInputStream stream = new FileInputStream(manifestFile);){
                Manifest manifest = new Manifest(stream);
                String value = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
                if (value == null) continue;
                String bsn = value.split(";", 2)[0];
                result.put(bsn, new BndMavenProject(mavenProject, null, null));
            }
            catch (Exception e) {
                this.logError("Can't read project " + mavenProject.getId(), e);
            }
        }
        return result;
    }

    private Map<MavenProject, Project> getProjects(MavenSession session) {
        HashSet<Workspace> workspaces = new HashSet<Workspace>();
        HashMap<MavenProject, Project> result = new HashMap<MavenProject, Project>();
        for (MavenProject mavenProject : session.getProjects()) {
            if (!BndMavenLifecycleParticipant.isBNDProject(mavenProject)) continue;
            try {
                File basedir = mavenProject.getBasedir();
                Workspace ws = Workspace.findWorkspace((File)basedir.getParentFile());
                if (workspaces.add(ws)) {
                    this.bndPluginManager.setupWorkspace(ws);
                }
                Project project = ws.getProject(basedir.getName());
                mavenProject.setContextValue(Project.class.getName(), (Object)project);
                result.put(mavenProject, project);
            }
            catch (Exception e) {
                this.logError("Can't read project " + mavenProject.getId(), e);
            }
        }
        return result;
    }

    static boolean isBNDProject(MavenProject mavenProject) {
        if (mavenProject.getPlugin("org.eclipse.tycho:tycho-bnd-plugin") == null) {
            return false;
        }
        File basedir = mavenProject.getBasedir();
        File bndFile = new File(basedir, "bnd.bnd");
        try {
            return bndFile.isFile() && Workspace.findWorkspace((File)basedir) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void logError(String msg, Exception e) {
        if (this.logger.isDebugEnabled()) {
            this.logger.error(msg, (Throwable)e);
        } else {
            this.logger.warn(msg + ": " + String.valueOf(e));
        }
    }

    private static Set<String> getProjectSet(MavenProject mavenProject, Map<MavenProject, Set<String>> dependencyMap) {
        Set set = dependencyMap.computeIfAbsent(mavenProject, nil -> new HashSet());
        mavenProject.getDependencies().stream().map(d -> BndMavenLifecycleParticipant.getKey(d)).forEach(set::add);
        return set;
    }

    private static void addDependency(MavenProject mavenProject, Dependency dependency, Set<String> added) {
        if (added.add(BndMavenLifecycleParticipant.getKey(dependency))) {
            mavenProject.getDependencies().add(dependency);
        }
    }

    private static String getKey(Dependency dependency) {
        return dependency.getManagementKey() + ":" + dependency.getVersion() + ":" + Objects.requireNonNullElse(dependency.getClassifier(), "");
    }
}

