/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.zipcomparator.internal;

import aQute.bnd.header.OSGiHeader;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.resource.CapReqBuilder;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.tycho.artifactcomparator.ArtifactComparator;
import org.eclipse.tycho.artifactcomparator.ArtifactDelta;
import org.eclipse.tycho.artifactcomparator.ComparatorInputStream;
import org.eclipse.tycho.zipcomparator.internal.CompoundArtifactDelta;
import org.eclipse.tycho.zipcomparator.internal.ContentsComparator;
import org.eclipse.tycho.zipcomparator.internal.SimpleArtifactDelta;

@Component(role=ContentsComparator.class, hint="manifest")
public class ManifestComparator
implements ContentsComparator {
    public static final String TYPE = "manifest";
    private static final Set<Attributes.Name> IGNORED_KEYS = Set.of(new Attributes.Name("Archiver-Version"), new Attributes.Name("Created-By"), new Attributes.Name("Build-Jdk"), new Attributes.Name("Built-By"), new Attributes.Name("Build-Jdk-Spec"), new Attributes.Name("Bnd-LastModified"), new Attributes.Name("Bundle-Developers"), new Attributes.Name("Tool"), new Attributes.Name("Eclipse-SourceReferences"), new Attributes.Name("Java-Version"));

    @Override
    public ArtifactDelta getDelta(ComparatorInputStream baseline, ComparatorInputStream reactor, ArtifactComparator.ComparisonData data) throws IOException {
        TreeMap<String, ManifestDelta> result = new TreeMap<String, ManifestDelta>();
        Manifest baselineManifest = new Manifest(baseline);
        Manifest projectManifest = new Manifest(reactor);
        Attributes baselineAttributes = baselineManifest.getMainAttributes();
        Attributes projectAttributes = projectManifest.getMainAttributes();
        LinkedHashSet<Attributes.Name> names = new LinkedHashSet<Attributes.Name>();
        this.addNames(baselineAttributes, names);
        this.addNames(projectAttributes, names);
        for (Attributes.Name key : names) {
            String baselineValue = baselineAttributes.getValue(key);
            String reactorValue = projectAttributes.getValue(key);
            if (baselineValue == null) {
                this.addDelta(result, key, "not present in baseline version", Change.PROJECT_ONLY, reactorValue, reactorValue);
                continue;
            }
            if (reactorValue == null) {
                this.addDelta(result, key, "present in baseline version only", Change.BASELINE_ONLY, baselineValue, baselineValue);
                continue;
            }
            if (ManifestComparator.isEquivialentHeaderValue(key.toString(), baselineValue, reactorValue)) continue;
            this.addDelta(result, key, "baseline='" + baselineValue + "' != reactor='" + reactorValue + "'", Change.DIFFERENT, baselineValue, reactorValue);
        }
        this.checkForEEChange(result);
        return !result.isEmpty() ? new CompoundArtifactDelta("different", result) : ArtifactDelta.NO_DIFFERENCE;
    }

    private void checkForEEChange(Map<String, ManifestDelta> result) {
        try {
            Map.Entry bree;
            if (result.size() > 1 && (bree = (Map.Entry)result.entrySet().stream().filter(e -> "Bundle-RequiredExecutionEnvironment".equalsIgnoreCase((String)e.getKey())).findFirst().orElse(null)) != null) {
                Map.Entry cap;
                ManifestDelta breeDelta = (ManifestDelta)bree.getValue();
                if (breeDelta.change != Change.DIFFERENT && (cap = (Map.Entry)result.entrySet().stream().filter(e -> "Require-Capability".equalsIgnoreCase((String)e.getKey())).findFirst().orElse(null)) != null) {
                    ManifestDelta capDelta = (ManifestDelta)cap.getValue();
                    if (capDelta.change != Change.DIFFERENT) {
                        if (ManifestComparator.isEquivialentBreeCap(breeDelta.value, capDelta.value)) {
                            result.remove(cap.getKey());
                            result.remove(bree.getKey());
                        }
                        return;
                    }
                    if (breeDelta.change == Change.BASELINE_ONLY && ManifestComparator.isEquivialentBreeCap(breeDelta.value, capDelta.value, capDelta.changed)) {
                        result.remove(cap.getKey());
                        result.remove(bree.getKey());
                    }
                }
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private void addDelta(TreeMap<String, ManifestDelta> result, Attributes.Name key, String message, Change change, String value, String changed) {
        result.put(key.toString(), new ManifestDelta(message, change, value, changed));
    }

    private void addNames(Attributes attributes, Set<Attributes.Name> names) {
        for (Object key : attributes.keySet()) {
            Attributes.Name name = (Attributes.Name)key;
            if (ManifestComparator.isIgnoredHeaderName(name)) continue;
            names.add(name);
        }
    }

    public static boolean isIgnoredHeaderName(String name) {
        return name != null && IGNORED_KEYS.contains(new Attributes.Name(name));
    }

    public static boolean isIgnoredHeaderName(Attributes.Name name) {
        return IGNORED_KEYS.contains(name);
    }

    @Override
    public boolean matches(String extension) {
        return TYPE.equalsIgnoreCase(extension);
    }

    public static boolean isEquivialentBreeCap(String bree, String cap) {
        String[] parts = bree.split("-");
        String osgiee = "osgi.ee;filter:=\"(&(osgi.ee=" + parts[0] + ")(version=" + parts[1] + "))\"";
        return cap.equalsIgnoreCase(osgiee);
    }

    public static boolean isEquivialentBreeCap(String bree, String capBase, String capChange) {
        try {
            String[] parts = bree.split("-");
            String osgiee = "osgi.ee;filter:=\"(&(osgi.ee=" + parts[0] + ")(version=" + parts[1] + "))\"";
            String withoutEE = capChange.replace(osgiee, "").replace(",,", ",");
            if (withoutEE.endsWith(",")) {
                withoutEE = withoutEE.substring(0, withoutEE.length() - 1);
            }
            if (withoutEE.startsWith(",")) {
                withoutEE = withoutEE.substring(1);
            }
            return ManifestComparator.isEquivialentHeaderValue("Require-Capability", capBase, withoutEE);
        }
        catch (RuntimeException runtimeException) {
            return ManifestComparator.isEquivialentHeaderValue("Require-Capability", capBase, capChange);
        }
    }

    public static boolean isEquivialentHeaderValue(String key, String base, String project) {
        if (base != null && project != null) {
            try {
                if ("Require-Capability".equalsIgnoreCase(key)) {
                    Parameters baseHeader = OSGiHeader.parseHeader((String)base);
                    Parameters projectHeader = OSGiHeader.parseHeader((String)project);
                    HashSet baseCapabilities = new HashSet(CapReqBuilder.getCapabilitiesFrom((Parameters)baseHeader));
                    HashSet projectCapabilities = new HashSet(CapReqBuilder.getCapabilitiesFrom((Parameters)projectHeader));
                    return baseCapabilities.equals(projectCapabilities);
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return Objects.equals(base, project);
    }

    private static enum Change {
        BASELINE_ONLY,
        PROJECT_ONLY,
        DIFFERENT;

    }

    private static final class ManifestDelta
    extends SimpleArtifactDelta {
        private Change change;
        private String value;
        private String changed;

        public ManifestDelta(String message, Change change, String value, String changed) {
            super(message);
            this.change = change;
            this.value = value;
            this.changed = changed;
        }
    }
}

