/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.zipcomparator.internal;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.tycho.artifactcomparator.ArtifactComparator;
import org.eclipse.tycho.artifactcomparator.ArtifactDelta;
import org.eclipse.tycho.artifactcomparator.ComparatorInputStream;
import org.eclipse.tycho.zipcomparator.internal.ContentsComparator;
import org.eclipse.tycho.zipcomparator.internal.SimpleArtifactDelta;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.util.TraceClassVisitor;

@Component(role=ContentsComparator.class, hint="class")
public class ClassfileComparator
implements ContentsComparator {
    public static final String TYPE = "class";

    @Override
    public ArtifactDelta getDelta(ComparatorInputStream baseline, ComparatorInputStream reactor, ArtifactComparator.ComparisonData data) throws IOException {
        try {
            String baselineDisassemble = this.disassemble(baseline.asBytes());
            String reactorDisassemble = this.disassemble(reactor.asBytes());
            if (baselineDisassemble.equals(reactorDisassemble)) {
                return ArtifactDelta.NO_DIFFERENCE;
            }
            return new ClassfileArtifactDelta(baselineDisassemble, reactorDisassemble, baseline, reactor);
        }
        catch (RuntimeException e) {
            return baseline.compare(reactor);
        }
    }

    private String disassemble(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode clazz = new ClassNode();
        reader.accept((ClassVisitor)clazz, 589830);
        if (clazz.innerClasses != null && !clazz.innerClasses.isEmpty()) {
            ArrayList sorted = new ArrayList(clazz.innerClasses);
            Collections.sort(sorted, (o1, o2) -> o1.name.compareTo(o2.name));
            clazz.innerClasses = sorted;
        }
        StringWriter buffer = new StringWriter();
        try (PrintWriter writer = new PrintWriter(buffer);){
            clazz.accept((ClassVisitor)new TraceClassVisitor(writer));
        }
        return buffer.toString();
    }

    @Override
    public boolean matches(String extension) {
        return TYPE.equalsIgnoreCase(extension);
    }

    public static final class ClassfileArtifactDelta
    extends SimpleArtifactDelta {
        private ComparatorInputStream baselineStream;
        private ComparatorInputStream reactorStream;

        ClassfileArtifactDelta(String baseline, String reactor, ComparatorInputStream baselineStream, ComparatorInputStream reactorStream) {
            super("different", baseline, reactor);
            this.baselineStream = baselineStream;
            this.reactorStream = reactorStream;
        }

        @Override
        public void writeDetails(File destination) throws IOException {
            super.writeDetails(destination);
            File basedir = destination.getParentFile();
            ClassfileArtifactDelta.writeFile(basedir, destination.getName() + "-baseline.class", this.baselineStream);
            ClassfileArtifactDelta.writeFile(basedir, destination.getName() + "-build.class", this.reactorStream);
        }
    }
}

