/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.artifactcomparator;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.eclipse.tycho.artifactcomparator.ArtifactDelta;

public class ComparatorInputStream
extends ByteArrayInputStream {
    private final byte[] content;

    public ComparatorInputStream(InputStream stream) throws IOException {
        this(stream.readAllBytes());
    }

    public ComparatorInputStream(byte[] content) {
        super(content);
        this.content = content;
    }

    public int size() {
        return this.content.length;
    }

    public InputStream asNewStream() {
        return new ByteArrayInputStream(this.content);
    }

    public String asString(Charset charset) {
        return new String(this.content, charset);
    }

    public byte[] asBytes() {
        return (byte[])this.content.clone();
    }

    public ArtifactDelta compare(ComparatorInputStream other) {
        if (Arrays.equals(this.content, other.content)) {
            return ArtifactDelta.NO_DIFFERENCE;
        }
        return ArtifactDelta.DEFAULT;
    }
}

