/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.zipcomparator.internal;

import com.github.difflib.DiffUtils;
import com.github.difflib.UnifiedDiffUtils;
import com.github.difflib.patch.Patch;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.tycho.artifactcomparator.ArtifactComparator;
import org.eclipse.tycho.artifactcomparator.ArtifactDelta;
import org.eclipse.tycho.artifactcomparator.ComparatorInputStream;
import org.eclipse.tycho.zipcomparator.internal.ContentsComparator;
import org.eclipse.tycho.zipcomparator.internal.SimpleArtifactDelta;

@Component(role=ContentsComparator.class, hint="txt")
public class TextComparator
implements ContentsComparator {
    static final String HINT = "txt";

    @Override
    public ArtifactDelta getDelta(ComparatorInputStream baseline, ComparatorInputStream reactor, ArtifactComparator.ComparisonData data) throws IOException {
        return TextComparator.compareText(baseline, reactor);
    }

    public static ArtifactDelta compareText(ComparatorInputStream baseline, ComparatorInputStream reactor) throws IOException {
        ByteIterator baselineIterator = new ByteIterator(baseline.asBytes());
        ByteIterator reactorIterator = new ByteIterator(reactor.asBytes());
        while (baselineIterator.hasNext() && reactorIterator.hasNext()) {
            if (baselineIterator.next() == reactorIterator.next()) continue;
            return TextComparator.createDelta(ArtifactDelta.DEFAULT.getMessage(), baseline, reactor);
        }
        if (baselineIterator.hasNext() || reactorIterator.hasNext()) {
            return TextComparator.createDelta(ArtifactDelta.DEFAULT.getMessage(), baseline, reactor);
        }
        return ArtifactDelta.NO_DIFFERENCE;
    }

    @Override
    public boolean matches(String nameOrExtension) {
        return HINT.equalsIgnoreCase(nameOrExtension);
    }

    public static ArtifactDelta createDelta(String message, ComparatorInputStream baseline, ComparatorInputStream reactor) {
        if (SHOW_DIFF_DETAILS) {
            String detailed;
            try {
                List source = IOUtils.readLines((InputStream)baseline.asNewStream(), (Charset)StandardCharsets.UTF_8);
                List target = IOUtils.readLines((InputStream)reactor.asNewStream(), (Charset)StandardCharsets.UTF_8);
                Patch patch = DiffUtils.diff((List)source, (List)target);
                List unifiedDiffList = UnifiedDiffUtils.generateUnifiedDiff((String)"baseline", (String)"reactor", (List)source, (Patch)patch, (int)0);
                detailed = unifiedDiffList.stream().collect(Collectors.joining(System.lineSeparator()));
            }
            catch (Exception e) {
                detailed = message;
            }
            return new SimpleArtifactDelta(message, detailed, baseline.asString(StandardCharsets.UTF_8), reactor.asString(StandardCharsets.UTF_8));
        }
        return ArtifactDelta.DEFAULT;
    }

    private static final class ByteIterator {
        private byte[] bytes;
        private int index;

        public ByteIterator(byte[] bytes) {
            this.bytes = bytes;
        }

        byte next() throws EOFException {
            if (this.hasNext()) {
                byte b = this.bytes[this.index];
                ++this.index;
                return b;
            }
            throw new EOFException();
        }

        boolean hasNext() {
            this.skipNewLines();
            return this.index < this.bytes.length;
        }

        private void skipNewLines() {
            while (this.index < this.bytes.length) {
                byte b = this.bytes[this.index];
                if (b == 10 || b == 13) {
                    ++this.index;
                    continue;
                }
                return;
            }
        }
    }
}

