/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.target;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.internal.p2.updatesite.SiteCategory;
import org.eclipse.equinox.internal.p2.updatesite.SiteXMLAction;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.CollectionResult;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.TargetPlatform;
import org.eclipse.tycho.TargetPlatformService;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.p2.repository.ListCompositeMetadataRepository;
import org.eclipse.tycho.p2.repository.PublishingRepository;
import org.eclipse.tycho.p2.tools.FacadeException;
import org.eclipse.tycho.p2.tools.mirroring.facade.MirrorApplicationService;
import org.eclipse.tycho.p2maven.InstallableUnitSlicer;
import org.eclipse.tycho.p2maven.ListCompositeArtifactRepository;
import org.eclipse.tycho.p2maven.SlicingOptions;
import org.eclipse.tycho.repository.registry.facade.ReactorRepositoryManager;

@Mojo(name="mirror-target-platform", threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.PACKAGE)
public class MirrorTargetPlatformMojo
extends AbstractMojo {
    private static final SiteXMLAction CATEGORY_FACTORY = new SiteXMLAction((URI)null, (String)null);
    @Parameter(property="project", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/target-platform-repository")
    private File destination;
    @Parameter(defaultValue="${project.id}")
    private String name;
    @Parameter(defaultValue="true")
    private boolean includeCategories = true;
    @Parameter
    private SlicingOptions options;
    @Component
    private TargetPlatformService platformService;
    @Component
    private MirrorApplicationService mirrorService;
    @Component
    private ReactorRepositoryManager repositoryManager;
    @Component
    private IProvisioningAgent agent;
    @Component
    private InstallableUnitSlicer installableUnitSlicer;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ReactorProject reactorProject = DefaultReactorProject.adapt((MavenProject)this.project);
        TargetPlatform targetPlatform = this.platformService.getTargetPlatform(reactorProject).orElse(null);
        if (targetPlatform == null) {
            this.getLog().info((CharSequence)"Project has no target platform, skip execution.");
            return;
        }
        IArtifactRepository sourceArtifactRepository = targetPlatform.getArtifactRepository();
        IMetadataRepository sourceMetadataRepository = targetPlatform.getMetadataRepository();
        PublishingRepository publishingRepository = this.repositoryManager.getPublishingRepository(reactorProject);
        try {
            ListCompositeMetadataRepository mirrorUnits;
            IMetadataRepository projectRepository = publishingRepository.getMetadataRepository();
            ListCompositeArtifactRepository artifactRepository = new ListCompositeArtifactRepository(List.of(sourceArtifactRepository, publishingRepository.getArtifactRepository()), this.agent);
            ListCompositeMetadataRepository metadataRepository = new ListCompositeMetadataRepository(List.of(sourceMetadataRepository, projectRepository), this.agent);
            if ("eclipse-target-definition".equals(this.project.getPackaging())) {
                mirrorUnits = metadataRepository;
            } else {
                try {
                    IQueryResult query = projectRepository.query(QueryUtil.ALL_UNITS, null);
                    Set rootIus = query.toSet();
                    String projectName = this.project.getName();
                    String label = projectName != null && !projectName.isBlank() ? projectName : this.project.getId();
                    rootIus.add(MirrorTargetPlatformMojo.createCategory(label, (IQueryResult<IInstallableUnit>)query));
                    mirrorUnits = this.installableUnitSlicer.computeDependencies((Collection)rootIus, (IQueryable)metadataRepository, this.options);
                }
                catch (CoreException e) {
                    throw new MojoFailureException("Failed to compute dependencies to mirror", (Throwable)e);
                }
            }
            Set toMirror = mirrorUnits.query(QueryUtil.ALL_UNITS, null).toSet();
            if (!this.includeCategories) {
                toMirror.removeIf(QueryUtil::isCategory);
            }
            this.getLog().info((CharSequence)("Mirroring " + toMirror.size() + " unit(s) from the target platform, this can take a while ..."));
            this.mirrorService.mirrorDirect((IArtifactRepository)artifactRepository, (IQueryable)new CollectionResult((Collection)toMirror), this.destination, this.name);
        }
        catch (FacadeException e) {
            throw new MojoFailureException(e.getMessage(), e.getCause());
        }
    }

    private static IInstallableUnit createCategory(String label, IQueryResult<IInstallableUnit> result) {
        SiteCategory category = new SiteCategory();
        category.setLabel(label);
        category.setName("generated.project.category." + String.valueOf(UUID.randomUUID()));
        return CATEGORY_FACTORY.createCategoryIU(category, result.stream().filter(iu -> !iu.getId().endsWith(".feature.jar")).collect(Collectors.toSet()));
    }
}

