/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.osgi.connect;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Disposable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.sisu.equinox.EquinoxServiceFactory;
import org.eclipse.sisu.equinox.embedder.EmbeddedEquinox;
import org.eclipse.sisu.equinox.embedder.EquinoxLifecycleListener;
import org.eclipse.sisu.osgi.connect.DummyClassRealm;
import org.eclipse.sisu.osgi.connect.PlexusConnectFramework;
import org.eclipse.sisu.osgi.connect.PlexusFrameworkUtilHelper;
import org.eclipse.sisu.osgi.connect.PlexusModuleConnector;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.connect.ConnectFrameworkFactory;
import org.osgi.framework.connect.ModuleConnector;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentConfigurationDTO;
import org.osgi.service.component.runtime.dto.UnsatisfiedReferenceDTO;
import org.osgi.util.tracker.ServiceTracker;

@Component(role=EquinoxServiceFactory.class, hint="connect")
public class PlexusFrameworkConnectServiceFactory
implements Initializable,
Disposable,
EquinoxServiceFactory {
    private static final StackWalker WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
    @Requirement
    private Logger log;
    private static final Map<ClassRealm, PlexusConnectFramework> frameworkMap = new HashMap<ClassRealm, PlexusConnectFramework>();
    private static final Map<ClassLoader, ClassRealm> loaderMap = new HashMap<ClassLoader, ClassRealm>();
    @Requirement(role=EquinoxLifecycleListener.class)
    private Map<String, EquinoxLifecycleListener> lifecycleListeners;
    private final String name = this.getName(this.getClass().getClassLoader());

    protected String getName(ClassLoader classLoader) {
        String string;
        if (classLoader instanceof ClassRealm) {
            ClassRealm classRealm = (ClassRealm)classLoader;
            string = classRealm.getId();
        } else {
            string = classLoader.toString();
        }
        return string;
    }

    synchronized PlexusConnectFramework getFramework(ClassRealm realm) throws BundleException {
        PlexusConnectFramework cachedFramework = frameworkMap.get(realm);
        if (cachedFramework != null) {
            return cachedFramework;
        }
        Framework foreignFramework = PlexusFrameworkConnectServiceFactory.getForeignFramework(realm);
        if (foreignFramework != null) {
            PlexusConnectFramework connectFwk = new PlexusConnectFramework(foreignFramework, this.log, this, realm, true, null);
            frameworkMap.put(realm, connectFwk);
            return connectFwk;
        }
        if (this.log.isDebugEnabled()) {
            this.printRealm(realm, 0, new HashSet<ClassRealm>());
        }
        Collection<ClassRealm> realms = PlexusFrameworkConnectServiceFactory.collectRealms(realm, new LinkedHashSet<ClassRealm>());
        this.log.debug("Create framework for " + String.valueOf(this) + " with Realm " + String.valueOf(realm));
        String storagePath = this.createStoragePath();
        PlexusConnectFramework fwLogger = new PlexusConnectFramework(null, this.log, this, realm, false, storagePath);
        Map<String, String> p = PlexusFrameworkConnectServiceFactory.readProperties((ClassLoader)realm, fwLogger);
        p.put("org.osgi.framework.system.packages.extra", "javax.security.auth.x500;version=\"1.3.0\", org.slf4j;version=\"1.7.37\"");
        p.put("osgi.framework.useSystemProperties", "false");
        p.put("osgi.parentClassloader", "fwk");
        p.put("org.osgi.framework.storage", storagePath + File.separator + "storage");
        p.put("org.osgi.framework.startlevel.beginning", "6");
        p.put("osgi.instance.area", storagePath + File.separator + "instance");
        ServiceLoader<ConnectFrameworkFactory> loader = ServiceLoader.load(ConnectFrameworkFactory.class, this.getClass().getClassLoader());
        ConnectFrameworkFactory factory = loader.findFirst().orElseThrow(() -> new NoSuchElementException("No ConnectFrameworkFactory found"));
        PlexusModuleConnector connector = new PlexusModuleConnector(factory);
        Framework osgiFramework = factory.newFramework(p, (ModuleConnector)connector);
        PlexusConnectFramework connectFramework = new PlexusConnectFramework(osgiFramework, this.log, this, realm, false, storagePath);
        PlexusFrameworkUtilHelper.registerHelper(connectFramework);
        osgiFramework.init(new FrameworkListener[]{connectFramework});
        frameworkMap.put(realm, connectFramework);
        connectFramework.start(osgiFramework.getBundleContext());
        for (ClassRealm r : realms) {
            connector.installRealm(r, osgiFramework.getBundleContext(), connectFramework);
        }
        FrameworkWiring wiring = (FrameworkWiring)osgiFramework.adapt(FrameworkWiring.class);
        wiring.resolveBundles(Collections.emptyList());
        osgiFramework.start();
        for (EquinoxLifecycleListener listener : this.lifecycleListeners.values()) {
            connectFramework.debug("Calling " + String.valueOf(listener));
            try {
                listener.afterFrameworkStarted((EmbeddedEquinox)connectFramework);
            }
            catch (RuntimeException e) {
                this.log.warn("Internal error in EquinoxLifecycleListener " + String.valueOf(listener), (Throwable)e);
            }
        }
        if (this.log.isDebugEnabled()) {
            PlexusFrameworkConnectServiceFactory.printFrameworkState(osgiFramework, connectFramework);
        }
        return connectFramework;
    }

    private String createStoragePath() {
        try {
            Path createTempDirectory = Files.createTempDirectory("plexus.osgi.", new FileAttribute[0]);
            return createTempDirectory.toFile().getAbsolutePath();
        }
        catch (IOException e) {
            return System.getProperty("java.io.tmpdir") + File.separator + "plexus.osgi." + String.valueOf(UUID.randomUUID());
        }
    }

    private void printRealm(ClassRealm realm, int indent, Set<ClassRealm> printed) {
        if (printed.add(realm)) {
            ClassRealm parentRealm = realm.getParentRealm();
            if (parentRealm != null) {
                this.printRealm(parentRealm, indent, printed);
                indent += 2;
            }
            String indentation = StringUtils.repeat((String)" ", (int)indent);
            System.out.println(indentation + "> " + realm.getId() + " (parent = " + String.valueOf(realm.getParentRealm()) + ")");
            Enumeration resources = realm.loadResourcesFromSelf("META-INF/maven/extension.xml");
            if (resources != null) {
                resources.asIterator().forEachRemaining(url -> System.out.println(indentation + "  " + String.valueOf(url)));
            }
            realm.display();
            for (ClassRealm imports : realm.getImportRealms()) {
                this.printRealm(imports, indent + 2, printed);
            }
        }
    }

    private static Collection<ClassRealm> collectRealms(ClassRealm realm, Collection<ClassRealm> realms) {
        if (realms.add(realm)) {
            ClassRealm parentRealm = realm.getParentRealm();
            if (parentRealm != null) {
                realms.add(parentRealm);
            }
            for (ClassRealm imported : realm.getImportRealms()) {
                PlexusFrameworkConnectServiceFactory.collectRealms(imported, realms);
            }
        }
        return realms;
    }

    protected ClassRealm getRealm(ClassLoader classloader) {
        ClassRealm classRealm;
        return classloader instanceof ClassRealm ? (classRealm = (ClassRealm)classloader) : loaderMap.computeIfAbsent(classloader, cl -> new DummyClassRealm("Not called from a ClassRealm", (ClassLoader)cl, this.log));
    }

    private static Map<String, String> readProperties(ClassLoader classloader, Logger logger) {
        Enumeration<URL> resources;
        HashMap<String, String> frameworkProperties = new HashMap<String, String>();
        try {
            resources = classloader.getResources("META-INF/sisu/connect.properties");
        }
        catch (IOException e1) {
            return frameworkProperties;
        }
        resources.asIterator().forEachRemaining(url -> {
            logger.debug("Reading properties from " + String.valueOf(url));
            Properties properties = new Properties();
            try (InputStream stream = url.openStream();){
                properties.load(stream);
            }
            catch (IOException e) {
                logger.warn("Cannot read properties from URL " + String.valueOf(url));
            }
            for (String property : properties.stringPropertyNames()) {
                String value = properties.getProperty(property);
                frameworkProperties.merge(property, value, (v1, v2) -> v1 + "," + v2);
            }
        });
        return frameworkProperties;
    }

    private static void printFrameworkState(Framework framework, Logger log) {
        Bundle[] bundles = PlexusFrameworkConnectServiceFactory.printBundles(framework, log);
        PlexusFrameworkConnectServiceFactory.printComponents(framework, log);
        PlexusFrameworkConnectServiceFactory.printExtensions(framework, log);
        PlexusFrameworkConnectServiceFactory.printServices(log, bundles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printExtensions(Framework framework, Logger log) {
        log.info("============ Extension Registry ==================");
        st.open(true);
        try (ServiceTracker st = new ServiceTracker(framework.getBundleContext(), IExtensionRegistry.class, null);){
            IExtensionPoint[] extensionPoints;
            IExtensionRegistry registry = (IExtensionRegistry)st.getService();
            if (registry == null) {
                log.info("No IExtensionRegistry installed (or started) in this framework");
                return;
            }
            for (IExtensionPoint point : extensionPoints = registry.getExtensionPoints()) {
                log.info(point.getUniqueIdentifier() + " [contributed by " + String.valueOf(point.getContributor()) + "]");
                for (IExtension extention : point.getExtensions()) {
                    log.info("\t" + extention.getUniqueIdentifier() + " [from " + extention.getContributor().getName() + "]");
                    for (IConfigurationElement element : extention.getConfigurationElements()) {
                        PlexusFrameworkConnectServiceFactory.printConfigElement(element, 2, log);
                    }
                }
            }
        }
    }

    private static void printConfigElement(IConfigurationElement element, int level, Logger log) {
        StringBuilder sb = new StringBuilder();
        sb.append("\t".repeat(level));
        sb.append(element.getName());
        for (String attr : element.getAttributeNames()) {
            sb.append(' ');
            sb.append(attr);
            sb.append('=');
            sb.append(element.getAttribute(attr));
        }
        String value = element.getValue();
        if (value != null) {
            sb.append(" @value = ");
            sb.append(value);
        }
        log.info(sb.toString());
        for (IConfigurationElement child : element.getChildren()) {
            PlexusFrameworkConnectServiceFactory.printConfigElement(child, level + 1, log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printComponents(Framework framework, Logger log) {
        st.open();
        try (ServiceTracker st = new ServiceTracker(framework.getBundleContext(), ServiceComponentRuntime.class, null);){
            ServiceComponentRuntime componentRuntime = (ServiceComponentRuntime)st.getService();
            if (componentRuntime != null) {
                log.info("============ Framework Components ==================");
                Collection descriptionDTOs = componentRuntime.getComponentDescriptionDTOs(new Bundle[0]);
                Comparator<ComponentConfigurationDTO> byComponentName = Comparator.comparing(dto -> dto.description.name, String.CASE_INSENSITIVE_ORDER);
                Comparator<ComponentConfigurationDTO> byComponentState = Comparator.comparingInt(dto -> dto.state);
                descriptionDTOs.stream().flatMap(dto -> componentRuntime.getComponentConfigurationDTOs(dto).stream()).sorted(byComponentState.thenComparing(byComponentName)).forEachOrdered(dto -> {
                    if (dto.state == 16) {
                        log.info(PlexusFrameworkConnectServiceFactory.toComponentState(dto.state) + " | " + dto.description.name + " | " + dto.failure);
                    } else {
                        log.info(PlexusFrameworkConnectServiceFactory.toComponentState(dto.state) + " | " + dto.description.name);
                    }
                    for (int i = 0; i < dto.unsatisfiedReferences.length; ++i) {
                        UnsatisfiedReferenceDTO ref = dto.unsatisfiedReferences[i];
                        log.info("\t" + ref.name + " is missing");
                    }
                });
            } else {
                log.info("No service component runtime installed (or started) in this framework");
            }
        }
    }

    private static void printServices(Logger log, Bundle[] bundles) {
        log.info("============ Registered Services ==================");
        Arrays.stream(bundles).map(Bundle::getRegisteredServices).filter(Objects::nonNull).flatMap(Arrays::stream).forEach(reference -> {
            Object service = reference.getProperty("objectClass");
            if (service instanceof Object[]) {
                Object[] objects = (Object[])service;
                service = objects.length == 1 ? objects[0] : Arrays.toString(objects);
            }
            log.info(String.valueOf(service) + " registered by " + reference.getBundle().getSymbolicName() + " | " + String.valueOf(reference.getProperties()));
        });
    }

    private static Bundle[] printBundles(Framework framework, Logger log) {
        Bundle[] bundles = framework.getBundleContext().getBundles();
        log.info("============ Framework Bundles ==================");
        Comparator<Bundle> bySymbolicName = Comparator.comparing(Bundle::getSymbolicName, String.CASE_INSENSITIVE_ORDER);
        Comparator<Bundle> byState = Comparator.comparingInt(Bundle::getState);
        Arrays.stream(bundles).sorted(byState.thenComparing(bySymbolicName)).forEachOrdered(bundle -> {
            String state = PlexusFrameworkConnectServiceFactory.toBundleState(bundle.getState());
            log.info(state + " | " + bundle.getSymbolicName() + " (" + String.valueOf(bundle.getVersion()) + ") at " + bundle.getLocation());
        });
        return bundles;
    }

    private static String toComponentState(int state) {
        return switch (state) {
            case 8 -> "ACTIVE     ";
            case 16 -> "FAILED     ";
            case 4 -> "SATISFIED  ";
            case 1, 2 -> "UNSATISFIED";
            default -> String.valueOf(state);
        };
    }

    private static String toBundleState(int state) {
        return switch (state) {
            case 32 -> "ACTIVE   ";
            case 2 -> "INSTALLED";
            case 4 -> "RESOLVED ";
            case 8 -> "STARTING ";
            case 16 -> "STOPPING ";
            default -> String.valueOf(state);
        };
    }

    public void dispose() {
        frameworkMap.values().removeIf(connect -> {
            block14: {
                if (connect.factory != this) {
                    return false;
                }
                String storagePath = connect.getStoragePath();
                try {
                    if (connect.foreign) break block14;
                    Framework fw = connect.getFramework();
                    BundleContext systemContext = fw.getBundleContext();
                    try {
                        connect.stop(systemContext);
                        try {
                            fw.stop();
                        }
                        catch (BundleException bundleException) {
                            // empty catch block
                        }
                        try {
                            fw.waitForStop(TimeUnit.SECONDS.toMillis(10L));
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    finally {
                        PlexusFrameworkUtilHelper.unregisterHelper(connect);
                    }
                }
                catch (Throwable t) {
                    System.err.println("Error on disposing framework: " + String.valueOf(t));
                }
                finally {
                    if (!connect.foreign && storagePath != null) {
                        FileUtils.deleteQuietly((File)new File(storagePath));
                    }
                }
            }
            return true;
        });
    }

    public void initialize() throws InitializationException {
        this.log.debug("Init instance " + String.valueOf(this) + " [" + String.valueOf(this.getClass().getClassLoader()) + "]");
    }

    public <T> T getService(Class<T> clazz) {
        return this.locateClass(clazz, null, WALKER.getCallerClass());
    }

    public <T> T getService(Class<T> clazz, String filter) {
        return this.locateClass(clazz, filter, WALKER.getCallerClass());
    }

    private <T> T locateClass(Class<T> clazz, String filter, Class<?> callerClass) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            if (clazz == null || callerClass == null) {
                T t = null;
                return t;
            }
            ClassRealm realm = this.getRealm(callerClass.getClassLoader());
            T t = this.getFramework(realm).getService(clazz, filter);
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    public String toString() {
        return this.name;
    }

    public static Framework getForeignFramework(ClassRealm realm) {
        Class<PlexusFrameworkConnectServiceFactory> thisClass = PlexusFrameworkConnectServiceFactory.class;
        Class foreignFactoryClass = realm.loadClassFromSelf(thisClass.getName());
        if (foreignFactoryClass != null && foreignFactoryClass != thisClass) {
            try {
                Method method = foreignFactoryClass.getMethod("getOsgiFramework", ClassRealm.class);
                return (Framework)method.invoke(null, realm);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Framework getOsgiFramework(ClassRealm realm) {
        PlexusConnectFramework cachedFramework = frameworkMap.get(realm);
        if (cachedFramework != null) {
            return cachedFramework.getFramework();
        }
        return null;
    }
}

