/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.equinox.launching.internal;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringJoiner;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.sisu.equinox.launching.BundleReference;
import org.eclipse.sisu.equinox.launching.BundleStartLevel;
import org.eclipse.sisu.equinox.launching.EquinoxInstallation;
import org.eclipse.sisu.equinox.launching.EquinoxInstallationDescription;
import org.eclipse.sisu.equinox.launching.EquinoxInstallationFactory;
import org.eclipse.sisu.equinox.launching.internal.DefaultEquinoxInstallation;

@Component(role=EquinoxInstallationFactory.class)
public class DefaultEquinoxInstallationFactory
implements EquinoxInstallationFactory {
    @Requirement
    private PlexusContainer plexus;
    private final Map<String, Manifest> manifestCache = new HashMap<String, Manifest>();
    @Requirement
    private Logger log;

    public DefaultEquinoxInstallationFactory() {
    }

    DefaultEquinoxInstallationFactory(Logger log) {
        this.log = log;
    }

    public EquinoxInstallation createInstallation(EquinoxInstallationDescription description, File location) {
        Set bundlesToExplode = description.getBundlesToExplode();
        Collection frameworkExtensions = description.getFrameworkExtensions();
        Map startLevel = description.getBundleStartLevel();
        BundleStartLevel defaultBundleStartLevel = description.getDefaultBundleStartLevel();
        if (defaultBundleStartLevel == null) {
            defaultBundleStartLevel = new BundleStartLevel(null, 4, false);
        }
        try {
            LinkedHashMap<BundleReference, File> effective = new LinkedHashMap<BundleReference, File>();
            for (BundleReference artifact : description.getBundles()) {
                boolean directoryShape;
                File file = artifact.getLocation();
                Manifest mf = this.getManifest(file);
                boolean bl = directoryShape = bundlesToExplode.contains(artifact.getId()) || this.isDirectoryShape(mf);
                if (!file.isDirectory() && directoryShape) {
                    String filename = artifact.getId() + "_" + artifact.getVersion();
                    File unpacked = new File(location, "plugins/" + filename);
                    unpacked.mkdirs();
                    this.unpack(file, unpacked);
                    effective.put(artifact, unpacked);
                    continue;
                }
                effective.put(artifact, file);
            }
            location.mkdirs();
            Properties p = new Properties();
            p.putAll((Map<?, ?>)description.getPlatformProperties());
            String newOsgiBundles = this.toOsgiBundles(effective, startLevel, defaultBundleStartLevel);
            p.setProperty("osgi.bundles", newOsgiBundles);
            p.setProperty("osgi.bundlefile.limit", "100");
            p.setProperty("osgi.install.area", "file:" + location.getAbsolutePath().replace('\\', '/'));
            p.setProperty("osgi.configuration.cascaded", "false");
            p.setProperty("osgi.framework", "org.eclipse.osgi");
            p.setProperty("osgi.bundles.defaultStartLevel", String.valueOf(defaultBundleStartLevel.getLevel()));
            Object url = p.getProperty("osgi.framework");
            if (url != null) {
                BundleReference desc = description.getBundle((String)url, null);
                if (desc != null) {
                    url = "file:" + desc.getLocation().getAbsolutePath().replace('\\', '/');
                } else if (((String)url).startsWith("file:")) {
                    String path = ((String)url).substring("file:".length());
                    File file = new File(path);
                    if (!file.isAbsolute()) {
                        file = new File(location, path);
                    }
                    url = "file:" + file.getAbsolutePath().replace('\\', '/');
                }
            }
            if (url != null) {
                p.setProperty("osgi.framework", (String)url);
            }
            if (!frameworkExtensions.isEmpty()) {
                List<String> bundleNames = this.unpackFrameworkExtensions(location, frameworkExtensions);
                p.setProperty("osgi.framework", this.copySystemBundle(description, location));
                p.setProperty("osgi.framework.extensions", StringUtils.join(bundleNames.iterator(), (String)","));
            }
            if (!description.getDevEntries().isEmpty()) {
                p.put("osgi.dev", this.createDevProperties(location, description.getDevEntries()));
            }
            File configIni = new File(location, "configuration/config.ini");
            File configurationLocation = configIni.getParentFile();
            configurationLocation.mkdirs();
            try (FileOutputStream fos = new FileOutputStream(configIni);){
                p.store(fos, null);
            }
            return new DefaultEquinoxInstallation(description, location, configurationLocation);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception creating test eclipse runtime", e);
        }
    }

    private boolean isDirectoryShape(Manifest mf) {
        String value = mf.getMainAttributes().getValue("Eclipse-BundleShape");
        return "dir".equals(value);
    }

    private Manifest getManifest(File file) throws IOException {
        String key = file.getAbsolutePath();
        Manifest manifest = this.manifestCache.get(key);
        if (manifest != null) {
            return manifest;
        }
        if (file.isDirectory()) {
            try (FileInputStream stream = new FileInputStream(new File(file, "META-INF/MANIFEST.MF"));){
                manifest = new Manifest(stream);
            }
        }
        try (JarFile jarFile = new JarFile(file);){
            manifest = jarFile.getManifest();
        }
        this.manifestCache.put(key, manifest);
        return manifest;
    }

    private String createDevProperties(File location, Map<String, String> devEntries) throws IOException {
        File file = new File(location, "dev.properties");
        Properties properties = new Properties();
        properties.putAll(devEntries);
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));){
            properties.store(os, null);
        }
        return file.toURI().toURL().toExternalForm();
    }

    protected void unpack(File source, File destination) {
        UnArchiver unzip;
        try {
            unzip = (UnArchiver)this.plexus.lookup(UnArchiver.class, "zip");
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException("Could not lookup required component", e);
        }
        unzip.setIgnorePermissions(true);
        destination.mkdirs();
        unzip.setSourceFile(source);
        unzip.setDestDirectory(destination);
        try {
            unzip.extract();
        }
        catch (ArchiverException e) {
            throw new RuntimeException("Unable to unpack jar " + source, e);
        }
    }

    private List<String> unpackFrameworkExtensions(File location, Collection<File> frameworkExtensions) throws IOException {
        ArrayList<String> bundleNames = new ArrayList<String>();
        for (File bundleFile : frameworkExtensions) {
            Manifest mf = this.getManifest(bundleFile);
            String symbolicName = mf.getMainAttributes().getValue("Bundle-SymbolicName");
            String version = mf.getMainAttributes().getValue("Bundle-Version");
            bundleNames.add(symbolicName);
            File bundleDir = new File(location, "plugins/" + symbolicName + "_" + version);
            if (bundleFile.isFile()) {
                this.unpack(bundleFile, bundleDir);
                continue;
            }
            FileUtils.copyDirectoryStructure((File)bundleFile, (File)bundleDir);
        }
        return bundleNames;
    }

    private String copySystemBundle(EquinoxInstallationDescription description, File location) throws IOException {
        BundleReference bundle = description.getSystemBundle();
        File srcFile = bundle.getLocation();
        File dstFile = new File(location, "plugins/" + srcFile.getName());
        FileUtils.copyFileIfModified((File)srcFile, (File)dstFile);
        return "file:" + dstFile.getAbsolutePath().replace('\\', '/');
    }

    protected String toOsgiBundles(Map<BundleReference, File> effective, Map<String, BundleStartLevel> startLevel, BundleStartLevel defaultStartLevel) throws IOException {
        this.log.debug("Installation OSGI bundles:");
        StringJoiner result = new StringJoiner(",");
        for (Map.Entry<BundleReference, File> entry : effective.entrySet()) {
            BundleStartLevel level = startLevel.get(entry.getKey().getId());
            if (level != null && level.getLevel() == -1) continue;
            StringBuilder line = new StringBuilder();
            line.append(this.appendAbsolutePath(entry.getValue()));
            if (level != null) {
                line.append('@');
                if (level.getLevel() > 0) {
                    line.append(level.getLevel());
                }
                if (level.isAutoStart()) {
                    if (line.charAt(line.length() - 1) == '@') {
                        line.append("start");
                    } else {
                        line.append(":start");
                    }
                }
            } else if (defaultStartLevel.isAutoStart()) {
                line.append("@start");
            }
            this.log.debug("\t" + line);
            result.add(line.toString());
        }
        return result.toString();
    }

    private String appendAbsolutePath(File file) throws IOException {
        String url = file.getAbsolutePath().replace('\\', '/');
        return "reference:file:" + url;
    }
}

