/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven.transport;

import java.io.File;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.LegacySupport;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.tycho.TychoConstants;
import org.eclipse.tycho.p2maven.transport.TransportCacheConfig;

@Component(role=TransportCacheConfig.class)
public class DefaultTransportCacheConfig
implements TransportCacheConfig,
Initializable {
    private static final boolean DEBUG_REQUESTS = Boolean.getBoolean("tycho.p2.transport.debug");
    private boolean offline;
    private boolean update;
    private boolean interactive;
    @Requirement
    private LegacySupport legacySupport;
    private File cacheLocation;

    public void initialize() throws InitializationException {
        File repoDir;
        MavenSession session = this.legacySupport.getSession();
        if (session == null) {
            repoDir = TychoConstants.DEFAULT_USER_LOCALREPOSITORY;
            this.offline = false;
            this.update = false;
            this.interactive = false;
        } else {
            this.offline = session.isOffline();
            repoDir = new File(session.getLocalRepository().getBasedir());
            this.update = session.getRequest().isUpdateSnapshots();
            this.interactive = session.getRequest().isInteractiveMode() && this.showTransferProgress(session);
        }
        String property = System.getProperty("tycho.p2.transport.cache");
        this.cacheLocation = property == null || property.isBlank() ? new File(repoDir, ".cache/tycho") : new File(property);
        this.cacheLocation.mkdirs();
    }

    private boolean showTransferProgress(MavenSession session) {
        TransferListener transferListener = session.getRequest().getTransferListener();
        return transferListener == null || !"QuietMavenTransferListener".equals(transferListener.getClass().getSimpleName());
    }

    @Override
    public boolean isOffline() {
        return this.offline;
    }

    @Override
    public boolean isUpdate() {
        return this.update;
    }

    @Override
    public boolean isInteractive() {
        return this.interactive;
    }

    @Override
    public File getCacheLocation() {
        return this.cacheLocation;
    }

    @Override
    public boolean isDebug() {
        return DEBUG_REQUESTS;
    }
}

