/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven.transport;

import java.io.File;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.eclipse.equinox.internal.p2.repository.CacheManagerComponent;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.spi.IAgentServiceFactory;
import org.eclipse.tycho.p2maven.transport.TychoRepositoryTransport;
import org.eclipse.tycho.p2maven.transport.TychoRepositoryTransportCacheManager;

@Component(role=IAgentServiceFactory.class, hint="org.eclipse.equinox.internal.p2.repository.CacheManager")
public class TychoRepositoryTransportCacheManagerAgentFactory
implements IAgentServiceFactory,
Initializable {
    @Requirement
    private LegacySupport legacySupport;
    private File repoDir;

    public Object createService(IProvisioningAgent agent) {
        Object transport = agent.getService(Transport.SERVICE_NAME);
        if (transport instanceof TychoRepositoryTransport) {
            TychoRepositoryTransport tychoRepositoryTransport = (TychoRepositoryTransport)((Object)transport);
            return new TychoRepositoryTransportCacheManager(tychoRepositoryTransport, this.repoDir);
        }
        return new CacheManagerComponent().createService(agent);
    }

    public void initialize() throws InitializationException {
        MavenSession session = this.legacySupport.getSession();
        this.repoDir = session == null ? RepositorySystem.defaultUserLocalRepository : new File(session.getLocalRepository().getBasedir());
    }
}

