/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven.transport;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.equinox.internal.p2.repository.AuthenticationFailedException;
import org.eclipse.tycho.p2maven.transport.CacheEntry;
import org.eclipse.tycho.p2maven.transport.HttpCache;
import org.eclipse.tycho.p2maven.transport.HttpTransport;
import org.eclipse.tycho.p2maven.transport.HttpTransportFactory;
import org.eclipse.tycho.p2maven.transport.Response;
import org.eclipse.tycho.p2maven.transport.TransportCacheConfig;

@Component(role=HttpCache.class)
public class SharedHttpCacheStorage
implements HttpCache {
    private static final int MAX_CACHE_LINES = Integer.getInteger("tycho.p2.transport.max-cache-lines", 1000);
    public static final long MIN_CACHE_PERIOD = Long.getLong("tycho.p2.transport.min-cache-minutes", TimeUnit.HOURS.toMinutes(1L));
    private static final String LAST_MODIFIED_HEADER = "Last-Modified";
    private static final String EXPIRES_HEADER = "Expires";
    private static final String CACHE_CONTROL_HEADER = "Cache-Control";
    private static final String MAX_AGE_DIRECTIVE = "max-age";
    private static final String MUST_REVALIDATE_DIRECTIVE = "must-revalidate";
    private static final String ETAG_HEADER = "ETag";
    private static final int MAX_IN_MEMORY = 1000;
    @Requirement
    TransportCacheConfig cacheConfig;
    private final Map<File, CacheLine> entryCache = new LinkedHashMap<File, CacheLine>(MAX_CACHE_LINES, 0.75f, true){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<File, CacheLine> eldest) {
            return this.size() > 1000;
        }
    };

    @Override
    public CacheEntry getCacheEntry(URI uri, final Logger logger) throws FileNotFoundException {
        final URI normalized = uri.normalize();
        final CacheLine cacheLine = this.getCacheLine(normalized);
        if (!this.cacheConfig.isUpdate()) {
            int code = cacheLine.getResponseCode();
            if (code == 404) {
                throw new FileNotFoundException(normalized.toASCIIString());
            }
            if (code == 301) {
                return this.getCacheEntry(cacheLine.getRedirect(normalized), logger);
            }
        }
        return new CacheEntry(){

            @Override
            public long getLastModified(HttpTransportFactory transportFactory) throws IOException {
                if (SharedHttpCacheStorage.this.cacheConfig.isOffline()) {
                    return cacheLine.getLastModified(normalized, transportFactory, SharedHttpCacheStorage::mavenIsOffline, logger);
                }
                try {
                    return cacheLine.fetchLastModified(normalized, transportFactory, logger);
                }
                catch (FileNotFoundException | AuthenticationFailedException e) {
                    throw e;
                }
                catch (IOException e) {
                    if (!SharedHttpCacheStorage.this.cacheConfig.isUpdate() && cacheLine.getResponseCode() > 0) {
                        logger.warn("Request to " + normalized + " failed, trying cache instead");
                        return cacheLine.getLastModified(normalized, transportFactory, nil -> e, logger);
                    }
                    throw e;
                }
            }

            @Override
            public File getCacheFile(HttpTransportFactory transportFactory) throws IOException {
                if (SharedHttpCacheStorage.this.cacheConfig.isOffline()) {
                    return cacheLine.getFile(normalized, transportFactory, SharedHttpCacheStorage::mavenIsOffline, logger);
                }
                try {
                    return cacheLine.fetchFile(normalized, transportFactory, logger);
                }
                catch (FileNotFoundException | AuthenticationFailedException e) {
                    throw e;
                }
                catch (IOException e) {
                    if (!SharedHttpCacheStorage.this.cacheConfig.isUpdate() && cacheLine.getResponseCode() > 0) {
                        logger.warn("Request to " + normalized + " failed, trying cache instead");
                        return cacheLine.getFile(normalized, transportFactory, nil -> e, logger);
                    }
                    throw e;
                }
            }
        };
    }

    private synchronized CacheLine getCacheLine(URI uri) {
        File location;
        Object cleanPath = uri.normalize().toASCIIString().replace(':', '/').replace('?', '/').replace('&', '/').replace('*', '/').replaceAll("/+", "/");
        if (((String)cleanPath).endsWith("/")) {
            cleanPath = (String)cleanPath + ".idx";
        }
        File file = new File(this.cacheConfig.getCacheLocation(), (String)cleanPath);
        try {
            location = file.getCanonicalFile();
        }
        catch (IOException e) {
            location = file.getAbsoluteFile();
        }
        return this.entryCache.computeIfAbsent(location, x$0 -> new CacheLine((File)x$0));
    }

    private static boolean isRedirected(int code) {
        return code == 301 || code == 302;
    }

    private static boolean isNotFound(int code) {
        return code == 404;
    }

    private static IOException mavenIsOffline(URI uri) {
        return new IOException("maven is currently in offline mode requested URL " + uri + " does not exist locally!");
    }

    private final class CacheLine {
        private static final String RESPONSE_CODE = "HTTP_RESPONSE_CODE";
        private static final String LAST_UPDATED = "FILE-LAST_UPDATED";
        private static final String STATUS_LINE = "HTTP_STATUS_LINE";
        private final File file;
        private final File headerFile;
        private Properties header;
        private final DateFormat httpDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);

        public CacheLine(File file) {
            this.file = file;
            this.headerFile = new File(file.getParent(), file.getName() + ".headers");
            this.httpDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        }

        public synchronized long fetchLastModified(URI uri, HttpTransportFactory transportFactory, Logger logger) throws IOException {
            HttpTransport transport = transportFactory.createTransport(uri);
            try (Response<Void> response = transport.head();){
                int code = response.statusCode();
                if (this.isAuthFailure(code)) {
                    throw new AuthenticationFailedException();
                }
                if (SharedHttpCacheStorage.isNotFound(code)) {
                    this.updateHeader(response, code);
                    throw new FileNotFoundException(uri.toString());
                }
                if (SharedHttpCacheStorage.isRedirected(code)) {
                    this.updateHeader(response, code);
                    long l = SharedHttpCacheStorage.this.getCacheEntry(uri, logger).getLastModified(transportFactory);
                    return l;
                }
                long l = response.getLastModified();
                return l;
            }
        }

        public synchronized long getLastModified(URI uri, HttpTransportFactory transportFactory, Function<URI, IOException> notAviableExceptionSupplier, Logger logger) throws IOException {
            int code = this.getResponseCode();
            if (code > 0) {
                if (this.isAuthFailure(code)) {
                    throw new AuthenticationFailedException();
                }
                if (SharedHttpCacheStorage.isNotFound(code)) {
                    throw new FileNotFoundException(uri.toString());
                }
                if (SharedHttpCacheStorage.isRedirected(code)) {
                    return SharedHttpCacheStorage.this.getCacheEntry(uri, logger).getLastModified(transportFactory);
                }
                Properties offlineHeader = this.getHeader();
                Date lastModified = this.pareHttpDate(offlineHeader.getProperty(SharedHttpCacheStorage.LAST_MODIFIED_HEADER.toLowerCase()));
                if (lastModified != null) {
                    return lastModified.getTime();
                }
                return -1L;
            }
            throw notAviableExceptionSupplier.apply(uri);
        }

        public synchronized File fetchFile(URI uri, HttpTransportFactory transportFactory, Logger logger) throws IOException {
            boolean exits = this.file.isFile();
            if (exits && !this.mustValidate()) {
                return this.file;
            }
            HttpTransport transport = transportFactory.createTransport(uri);
            Properties lastHeader = this.getHeader();
            if (exits) {
                if (lastHeader.containsKey(SharedHttpCacheStorage.ETAG_HEADER.toLowerCase())) {
                    transport.setHeader("If-None-Match", lastHeader.getProperty(SharedHttpCacheStorage.ETAG_HEADER.toLowerCase()));
                }
                if (lastHeader.contains(SharedHttpCacheStorage.LAST_MODIFIED_HEADER.toLowerCase())) {
                    transport.setHeader("If-Modified-Since", lastHeader.getProperty(SharedHttpCacheStorage.LAST_MODIFIED_HEADER.toLowerCase()));
                }
            }
            try (Response<InputStream> response = transport.get();){
                int code = response.statusCode();
                if (exits && code == 304) {
                    this.updateHeader(response, this.getResponseCode());
                    File file = this.file;
                    return file;
                }
                if (this.isAuthFailure(code)) {
                    throw new AuthenticationFailedException();
                }
                this.updateHeader(response, code);
                if (SharedHttpCacheStorage.isRedirected(code)) {
                    File file = SharedHttpCacheStorage.this.getCacheEntry(this.getRedirect(uri), logger).getCacheFile(transportFactory);
                    return file;
                }
                if (exits) {
                    FileUtils.forceDelete((File)this.file);
                }
                response.checkResponseCode();
                File tempFile = File.createTempFile("download", ".tmp", this.file.getParentFile());
                try (InputStream inputStream = response.body();
                     FileOutputStream os = new FileOutputStream(tempFile);){
                    inputStream.transferTo(os);
                }
                catch (IOException e) {
                    tempFile.delete();
                    throw e;
                }
                FileUtils.moveFile((File)tempFile, (File)this.file);
            }
            return this.file;
        }

        public synchronized File getFile(URI uri, HttpTransportFactory transportFactory, Function<URI, IOException> notAviableExceptionSupplier, Logger logger) throws IOException {
            int code = this.getResponseCode();
            if (code > 0) {
                if (this.isAuthFailure(code)) {
                    throw new AuthenticationFailedException();
                }
                if (SharedHttpCacheStorage.isNotFound(code)) {
                    throw new FileNotFoundException(uri.toString());
                }
                if (SharedHttpCacheStorage.isRedirected(code)) {
                    return SharedHttpCacheStorage.this.getCacheEntry(this.getRedirect(uri), logger).getCacheFile(transportFactory);
                }
                if (this.file.isFile()) {
                    return this.file;
                }
            }
            throw notAviableExceptionSupplier.apply(uri);
        }

        private boolean mustValidate() {
            String[] cacheControls;
            if (SharedHttpCacheStorage.this.cacheConfig.isUpdate()) {
                return true;
            }
            for (String string : cacheControls = this.getCacheControl()) {
                if (!SharedHttpCacheStorage.MUST_REVALIDATE_DIRECTIVE.equals(string)) continue;
                return true;
            }
            Properties properties = this.getHeader();
            long lastUpdated = this.parseLong(properties.getProperty(LAST_UPDATED));
            if (lastUpdated + TimeUnit.MINUTES.toMillis(MIN_CACHE_PERIOD) > System.currentTimeMillis()) {
                return false;
            }
            for (String directive : cacheControls) {
                if (!directive.toLowerCase().startsWith(SharedHttpCacheStorage.MAX_AGE_DIRECTIVE)) continue;
                long maxAge = this.parseLong(directive.substring(SharedHttpCacheStorage.MAX_AGE_DIRECTIVE.length() + 1));
                if (maxAge <= 0L) {
                    return true;
                }
                return lastUpdated + TimeUnit.SECONDS.toMillis(maxAge) < System.currentTimeMillis();
            }
            Date date = this.pareHttpDate(properties.getProperty(SharedHttpCacheStorage.EXPIRES_HEADER.toLowerCase()));
            if (date != null) {
                return date.after(new Date());
            }
            return true;
        }

        protected long parseLong(String value) {
            if (value != null) {
                try {
                    return Long.parseLong(value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return 0L;
        }

        private String[] getCacheControl() {
            String property = this.getHeader().getProperty(SharedHttpCacheStorage.CACHE_CONTROL_HEADER);
            if (property != null) {
                return property.split(",\\s*");
            }
            return new String[0];
        }

        protected boolean isAuthFailure(int code) {
            return code == 407 || code == 401;
        }

        protected void updateHeader(Response<?> response, int code) throws IOException, FileNotFoundException {
            this.header = new Properties();
            this.header.setProperty(RESPONSE_CODE, String.valueOf(code));
            this.header.setProperty(LAST_UPDATED, String.valueOf(System.currentTimeMillis()));
            Map<String, List<String>> headerFields = response.headers();
            for (Map.Entry<String, List<String>> entry : headerFields.entrySet()) {
                String key = entry.getKey();
                if (key == null) {
                    key = STATUS_LINE;
                }
                if ("Authorization".equalsIgnoreCase(key = key.toLowerCase()) || "Proxy-Authorization".equalsIgnoreCase(key) || key.toLowerCase().startsWith("x-")) continue;
                List<String> value = entry.getValue();
                if (value.size() == 1) {
                    this.header.put(key, value.get(0));
                    continue;
                }
                this.header.put(key, value.stream().collect(Collectors.joining(",")));
            }
            FileUtils.forceMkdir((File)this.file.getParentFile());
            try (FileOutputStream out = new FileOutputStream(this.headerFile);){
                this.header.store(out, null);
            }
        }

        private synchronized Date pareHttpDate(String input) {
            if (input != null) {
                try {
                    return this.httpDateFormat.parse(input);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            return null;
        }

        public int getResponseCode() {
            return Integer.parseInt(this.getHeader().getProperty(RESPONSE_CODE, "-1"));
        }

        public URI getRedirect(URI base) throws FileNotFoundException {
            String location = this.getHeader().getProperty("location");
            if (location == null) {
                throw new FileNotFoundException(base.toASCIIString());
            }
            return base.resolve(location);
        }

        public Properties getHeader() {
            if (this.header == null) {
                this.header = new Properties();
                if (this.headerFile.isFile()) {
                    try {
                        this.header.load(new FileInputStream(this.headerFile));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            return this.header;
        }
    }
}

