/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.SessionScoped;
import org.apache.maven.execution.MavenSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.repository.DownloadStatus;
import org.eclipse.equinox.internal.p2.repository.helpers.ChecksumHelper;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.tycho.helper.MavenPropertyHelper;
import org.eclipse.tycho.transport.ArtifactDownloadProvider;

@Named
@SessionScoped
public class MavenArtifactDownloadProvider
implements ArtifactDownloadProvider {
    private MavenSession session;
    private RepositorySystem repoSystem;
    private boolean useMavenMirror;
    private int priority;

    @Inject
    public MavenArtifactDownloadProvider(MavenSession session, RepositorySystem repoSystem, MavenPropertyHelper propertyHelper) {
        this.session = session;
        this.repoSystem = repoSystem;
        this.useMavenMirror = propertyHelper.getGlobalBooleanProperty("tycho.p2.transport.mavenmirror.enabled", true);
        this.priority = propertyHelper.getGlobalIntProperty("tycho.p2.transport.mavenmirror.priority", 500);
    }

    public IStatus downloadArtifact(URI source, OutputStream target, IArtifactDescriptor descriptor) {
        ArtifactRequest artifactRequest;
        Path path;
        if (!this.useMavenMirror) {
            return Status.CANCEL_STATUS;
        }
        String groupId = descriptor.getProperty("maven-groupId");
        if (groupId == null) {
            return Status.CANCEL_STATUS;
        }
        String artifactId = descriptor.getProperty("maven-artifactId");
        if (artifactId == null) {
            return Status.CANCEL_STATUS;
        }
        String version = descriptor.getProperty("maven-version");
        if (version == null) {
            return Status.CANCEL_STATUS;
        }
        if (version.endsWith("-SNAPSHOT")) {
            return Status.CANCEL_STATUS;
        }
        String classifer = descriptor.getProperty("maven-classifier");
        if ("sources".equals(classifer)) {
            return Status.CANCEL_STATUS;
        }
        String repository = descriptor.getProperty("maven-repository");
        if (repository == null || repository.isBlank()) {
            return Status.CANCEL_STATUS;
        }
        List repositories = RepositoryUtils.toRepos((List)this.session.getRequest().getRemoteRepositories());
        RepositorySystemSession repositorySession = this.session.getRepositorySession();
        ArtifactTypeRegistry stereotypes = repositorySession.getArtifactTypeRegistry();
        DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, classifer, stereotypes.get(Objects.requireNonNullElse(descriptor.getProperty("maven-type"), "jar")).getExtension(), version);
        try {
            VersionRangeRequest rangeRequest = new VersionRangeRequest((Artifact)new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getExtension(), "[0,)"), repositories, "");
            VersionRangeResult range = this.repoSystem.resolveVersionRange(repositorySession, rangeRequest);
            List versions = range.getVersions();
            if (versions.isEmpty() || versions.stream().map(v -> v.toString()).noneMatch(s -> s.equals(artifact.getVersion()))) {
                return Status.CANCEL_STATUS;
            }
        }
        catch (VersionRangeResolutionException e) {
            return Status.CANCEL_STATUS;
        }
        Map<String, String> checksums = MavenArtifactDownloadProvider.getChecksums(descriptor);
        boolean checksumMatch = false;
        for (Map.Entry entry : checksums.entrySet()) {
            ArtifactRequest artifactRequest2 = new ArtifactRequest((Artifact)new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), MavenArtifactDownloadProvider.toMavenChecksumKey((String)entry.getKey(), artifact.getExtension()), artifact.getVersion()), repositories, null);
            try {
                Path path2 = this.resolveArtifact(repositorySession, artifactRequest2).orElse(null);
                if (path2 == null) continue;
                String content = Files.readString(path2);
                if (!((String)entry.getValue()).equals(content)) {
                    return Status.CANCEL_STATUS;
                }
                checksumMatch = true;
                break;
            }
            catch (Exception path2) {
            }
        }
        if ((path = (Path)this.resolveArtifact(repositorySession, artifactRequest = new ArtifactRequest((Artifact)artifact, repositories, null)).orElse(null)) != null) {
            if (checksumMatch) {
                return MavenArtifactDownloadProvider.copyToTarget(target, path, (Artifact)artifact, descriptor);
            }
            if (MavenArtifactDownloadProvider.matchFileSize(path, descriptor)) {
                for (Map.Entry<String, String> entry : checksums.entrySet()) {
                    if (!MavenArtifactDownloadProvider.checksumMatch(path, entry)) continue;
                    return MavenArtifactDownloadProvider.copyToTarget(target, path, (Artifact)artifact, descriptor);
                }
            }
        }
        return Status.CANCEL_STATUS;
    }

    private Optional<Path> resolveArtifact(RepositorySystemSession repositorySession, ArtifactRequest artifactRequest) {
        try {
            ArtifactResult result = this.repoSystem.resolveArtifact(repositorySession, artifactRequest);
            return Optional.ofNullable(result.getArtifact()).filter(a -> a.getFile() != null && a.getFile().isFile()).map(a -> a.getFile()).map(f -> f.toPath());
        }
        catch (ArtifactResolutionException e) {
            return Optional.empty();
        }
    }

    private static boolean checksumMatch(Path file, Map.Entry<String, String> entry) {
        String key = entry.getKey();
        try {
            MessageDigest md = MessageDigest.getInstance(key.toUpperCase());
            try (InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);
                 DigestOutputStream outputStream = new DigestOutputStream(OutputStream.nullOutputStream(), md);){
                inputStream.transferTo(outputStream);
            }
            return ChecksumHelper.toHexString((byte[])md.digest()).equals(entry.getValue());
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static IStatus copyToTarget(OutputStream target, Path path, Artifact resolved, IArtifactDescriptor descriptor) {
        try {
            Files.copy(path, target);
        }
        catch (IOException e) {
            return Status.error((String)"Can't copy file to target", (Throwable)e);
        }
        DownloadStatus status = new DownloadStatus(0, "org.eclipse.tycho", "Download of " + String.valueOf(descriptor.getArtifactKey()) + " as " + String.valueOf(resolved), null);
        try {
            status.setFileSize(Files.size(path));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            status.setLastModified(Files.getLastModifiedTime(path, new LinkOption[0]).toMillis());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return status;
    }

    private static boolean matchFileSize(Path file, IArtifactDescriptor descriptor) {
        String sizeProperty = descriptor.getProperty("download.size");
        if (sizeProperty != null) {
            try {
                return Long.parseLong(sizeProperty) == Files.size(file);
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return true;
    }

    private static String toMavenChecksumKey(String key, String extension) {
        return extension + "." + key.replace("-", "");
    }

    private static Map<String, String> getChecksums(IArtifactDescriptor descriptor) {
        TreeMap<String, String> map = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER.reversed());
        Map properties = descriptor.getProperties();
        for (Map.Entry entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith("download.checksum.")) continue;
            map.put(key.substring("download.checksum.".length()), (String)entry.getValue());
        }
        return map;
    }

    public int getPriority() {
        return this.priority;
    }
}

