/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.eclipse.tycho.p2maven.helper.ProxyHelper;
import org.eclipse.tycho.p2maven.transport.HttpTransport;
import org.eclipse.tycho.p2maven.transport.HttpTransportFactory;
import org.eclipse.tycho.p2maven.transport.MavenAuthenticator;
import org.eclipse.tycho.p2maven.transport.Response;

@Component(role=HttpTransportFactory.class, hint="Java11Client")
public class Java11HttpTransportFactory
implements HttpTransportFactory,
Initializable {
    private static final int MAX_DISCARD = 10240;
    private static final byte[] DUMMY_BUFFER = new byte[10240];
    private static final String LAST_MODIFIED_HEADER = "Last-Modified";
    private static final List<ThreadLocal<DateFormat>> DATE_PATTERNS = List.of(ThreadLocal.withInitial(() -> new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.ENGLISH)), ThreadLocal.withInitial(() -> new SimpleDateFormat("EEE, dd-MMM-yy HH:mm:ss zzz", Locale.ENGLISH)), ThreadLocal.withInitial(() -> new SimpleDateFormat("EEE MMMd HH:mm:ss yyyy", Locale.ENGLISH)));
    static final String HINT = "Java11Client";
    @Requirement
    ProxyHelper proxyHelper;
    @Requirement
    MavenAuthenticator authenticator;
    private HttpClient client;

    @Override
    public HttpTransport createTransport(URI uri) {
        Java11HttpTransport transport = new Java11HttpTransport(this.client, HttpRequest.newBuilder().uri(uri));
        this.authenticator.preemtiveAuth((k, v) -> transport.setHeader((String)k, (String)v), uri);
        return transport;
    }

    public void initialize() throws InitializationException {
        this.client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NEVER).proxy(new ProxySelector(){

            @Override
            public List<Proxy> select(URI uri) {
                Proxy proxy = Java11HttpTransportFactory.this.proxyHelper.getProxy(uri);
                return List.of(proxy);
            }

            @Override
            public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
            }
        }).build();
    }

    private static final class Java11HttpTransport
    implements HttpTransport {
        private HttpRequest.Builder builder;
        private HttpClient client;

        public Java11HttpTransport(HttpClient client, HttpRequest.Builder builder) {
            this.client = client;
            this.builder = builder;
        }

        @Override
        public void setHeader(String key, String value) {
            this.builder.setHeader(key, value);
        }

        @Override
        public Response<InputStream> get() throws IOException {
            try {
                final HttpResponse<InputStream> response = this.client.send(this.builder.GET().build(), HttpResponse.BodyHandlers.ofInputStream());
                return new ResponseImplementation<InputStream>(response){

                    @Override
                    public void close() {
                        if (response.version() == HttpClient.Version.HTTP_1_1) {
                            try (InputStream stream2 = (InputStream)this.body();){
                                int read;
                                for (int discarded = 0; discarded < 10240; discarded += read) {
                                    read = stream2.read(DUMMY_BUFFER);
                                    if (read >= 0) continue;
                                    break;
                                }
                            }
                            catch (IOException stream2) {}
                        } else {
                            try {
                                InputStream stream = (InputStream)this.body();
                                if (stream != null) {
                                    stream.close();
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                };
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
        }

        @Override
        public Response<Void> head() throws IOException {
            try {
                HttpResponse<Void> response = this.client.send(this.builder.method("HEAD", null).build(), HttpResponse.BodyHandlers.discarding());
                return new ResponseImplementation<Void>(response){

                    @Override
                    public void close() {
                    }
                };
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
        }
    }

    private static abstract class ResponseImplementation<T>
    implements Response<T> {
        private final HttpResponse<T> response;

        private ResponseImplementation(HttpResponse<T> response) {
            this.response = response;
        }

        @Override
        public int statusCode() {
            return this.response.statusCode();
        }

        @Override
        public Map<String, List<String>> headers() {
            return this.response.headers().map();
        }

        @Override
        public T body() {
            return this.response.body();
        }

        @Override
        public String getHeader(String header) {
            return this.response.headers().firstValue(header).orElse(null);
        }

        @Override
        public URI getURI() {
            return this.response.uri();
        }

        @Override
        public long getLastModified() {
            String lastModifiedHeader = this.getHeader(Java11HttpTransportFactory.LAST_MODIFIED_HEADER);
            if (lastModifiedHeader == null) {
                return 0L;
            }
            if (lastModifiedHeader.length() > 1 && lastModifiedHeader.startsWith("'") && lastModifiedHeader.endsWith("'")) {
                lastModifiedHeader = lastModifiedHeader.substring(1, lastModifiedHeader.length() - 1);
            }
            for (ThreadLocal<DateFormat> dateFormat : DATE_PATTERNS) {
                try {
                    return dateFormat.get().parse(lastModifiedHeader).getTime();
                }
                catch (ParseException parseException) {
                }
            }
            return 0L;
        }
    }
}

