/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven.actions;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.internal.p2.publisher.eclipse.IProductDescriptor;
import org.eclipse.equinox.internal.p2.publisher.eclipse.ProductContentType;
import org.eclipse.equinox.internal.p2.publisher.eclipse.ProductFile;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.publisher.AdviceFileAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.eclipse.FeatureEntry;
import org.eclipse.tycho.p2maven.actions.AbstractDependenciesAction;

public class ProductDependenciesAction
extends AbstractDependenciesAction {
    private final IProductDescriptor product;

    public ProductDependenciesAction(IProductDescriptor product) {
        this.product = product;
    }

    @Override
    protected Version getVersion() {
        return Version.create((String)this.product.getVersion());
    }

    @Override
    protected String getId() {
        return this.product.getId();
    }

    @Override
    protected Set<IRequirement> getRequiredCapabilities() {
        LinkedHashSet<IRequirement> required = new LinkedHashSet<IRequirement>();
        ProductContentType type = this.product.getProductContentType();
        if (type == ProductContentType.FEATURES || type == ProductContentType.MIXED) {
            for (IVersionedId feature : this.product.getFeatures()) {
                String id = feature.getId() + ".feature.group";
                Version version = feature.getVersion();
                this.addRequiredCapability(required, id, version, null, false);
            }
        }
        if (type == ProductContentType.BUNDLES || type == ProductContentType.MIXED) {
            for (FeatureEntry plugin : ((ProductFile)this.product).getProductEntries()) {
                this.addRequiredCapability(required, plugin.getId(), Version.parseVersion((String)plugin.getVersion()), null, true);
            }
        }
        if (this.product.includeLaunchers()) {
            this.addRequiredCapability(required, "org.eclipse.equinox.executable.feature.group", null, null, false);
        }
        return required;
    }

    @Override
    protected void addPublisherAdvice(IPublisherInfo publisherInfo) {
        String productFileName;
        String p2infFilename;
        Path basePath;
        Version parseVersion;
        File productFileLocation = this.product.getLocation();
        if (productFileLocation == null) {
            return;
        }
        String id = this.product.getId();
        AdviceFileAdvice advice = new AdviceFileAdvice(id, parseVersion = Version.parseVersion((String)this.product.getVersion()), (IPath)(basePath = new Path(productFileLocation.getParent())), (IPath)new Path(p2infFilename = (productFileName = productFileLocation.getName()).substring(0, productFileName.length() - ".product".length()) + ".p2.inf"));
        if (advice.containsAdvice()) {
            publisherInfo.addAdvice((IPublisherAdvice)advice);
        }
    }

    @Override
    protected void addProperties(MetadataFactory.InstallableUnitDescription iud) {
        iud.setProperty("org.eclipse.equinox.p2.type.product", Boolean.toString(true));
    }
}

